/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.BdaBitString;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;

public final class BdaDoubleBitPos
extends BdaBitString {
    public BdaDoubleBitPos(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, 2, dchg, dupd);
        this.basicType = BdaType.DOUBLE_BIT_POS;
        this.setDefault();
    }

    @Override
    public void setDefault() {
        this.value = new byte[]{64};
    }

    @Override
    public BdaDoubleBitPos copy() {
        BdaDoubleBitPos copy = new BdaDoubleBitPos(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    public DoubleBitPos getDoubleBitPos() {
        if ((this.value[0] & 0xC0) == 192) {
            return DoubleBitPos.BAD_STATE;
        }
        if ((this.value[0] & 0x80) == 128) {
            return DoubleBitPos.ON;
        }
        if ((this.value[0] & 0x40) == 64) {
            return DoubleBitPos.OFF;
        }
        return DoubleBitPos.INTERMEDIATE_STATE;
    }

    public void setDoubleBitPos(DoubleBitPos doubleBitPos) {
        this.value[0] = doubleBitPos == DoubleBitPos.BAD_STATE ? -64 : (doubleBitPos == DoubleBitPos.ON ? -128 : (doubleBitPos == DoubleBitPos.OFF ? 64 : 0));
    }

    @Override
    public String getValueString() {
        return this.getDoubleBitPos().toString();
    }

    public static enum DoubleBitPos {
        INTERMEDIATE_STATE(0),
        OFF(1),
        ON(2),
        BAD_STATE(3);

        private final int value;

        private DoubleBitPos(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return this.value;
        }
    }
}

