/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.FloatingPoint;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import com.beanit.iec61850bean.internal.mms.asn1.Unsigned8;
import java.nio.ByteBuffer;

public final class BdaFloat32
extends BasicDataAttribute {
    private volatile byte[] value;

    public BdaFloat32(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.FLOAT32;
        this.setDefault();
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaFloat32)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public Float getFloat() {
        return Float.valueOf(Float.intBitsToFloat((0xFF & this.value[1]) << 24 | (0xFF & this.value[2]) << 16 | (0xFF & this.value[3]) << 8 | (0xFF & this.value[4]) << 0));
    }

    public void setFloat(Float value) {
        this.value = ByteBuffer.allocate(5).put((byte)8).putFloat(value.floatValue()).array();
    }

    @Override
    public void setDefault() {
        this.value = new byte[]{8, 0, 0, 0, 0};
    }

    @Override
    public BdaFloat32 copy() {
        BdaFloat32 copy = new BdaFloat32(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        if (this.value == null) {
            return null;
        }
        Data data = new Data();
        data.setFloatingPoint(new FloatingPoint(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getFloatingPoint() == null || data.getFloatingPoint().value.length != 5) {
            throw new ServiceError(10, "expected type: floating_point as an octet string of size 5");
        }
        this.value = data.getFloatingPoint().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription.FloatingPoint floatingPointTypeDescription = new TypeDescription.FloatingPoint();
        floatingPointTypeDescription.setFormatWidth(new Unsigned8(32L));
        floatingPointTypeDescription.setExponentWidth(new Unsigned8(8L));
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setFloatingPoint(floatingPointTypeDescription);
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.getFloat();
    }

    @Override
    public String getValueString() {
        return this.getFloat().toString();
    }
}

