/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.FcModelNode;
import com.beanit.iec61850bean.ModelNode;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class FcDataObject
extends FcModelNode {
    public FcDataObject(ObjectReference objectReference, Fc fc, List<FcModelNode> children) {
        this.children = new LinkedHashMap((int)((double)children.size() / 0.75 + 1.0));
        this.objectReference = objectReference;
        for (ModelNode modelNode : children) {
            this.children.put(modelNode.getReference().getName(), modelNode);
            modelNode.setParent(this);
        }
        this.fc = fc;
    }

    @Override
    public FcDataObject copy() {
        ArrayList<FcModelNode> childCopies = new ArrayList<FcModelNode>(this.children.size());
        for (ModelNode childNode : this.children.values()) {
            childCopies.add((FcModelNode)childNode.copy());
        }
        return new FcDataObject(this.objectReference, this.fc, childCopies);
    }

    @Override
    Data getMmsDataObj() {
        Data.Structure dataStructure = new Data.Structure();
        List<Data> seq = dataStructure.getData();
        for (ModelNode modelNode : this.getChildren()) {
            Data child = modelNode.getMmsDataObj();
            if (child == null) {
                throw new IllegalArgumentException("Unable to convert Child: " + modelNode.objectReference + " to MMS Data Object.");
            }
            seq.add(child);
        }
        if (seq.size() == 0) {
            throw new IllegalArgumentException("Converting ModelNode: " + this.objectReference + " to MMS Data Object resulted in Sequence of size zero.");
        }
        Data data = new Data();
        data.setStructure(dataStructure);
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getStructure() == null) {
            throw new ServiceError(10, "expected type: structure");
        }
        if (data.getStructure().getData().size() != this.children.size()) {
            throw new ServiceError(10, "expected type: structure with " + this.children.size() + " elements");
        }
        Iterator<Data> iterator = data.getStructure().getData().iterator();
        for (ModelNode child : this.children.values()) {
            child.setValueFromMmsDataObj(iterator.next());
        }
    }
}

