/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import com.beanit.iec61850bean.BasicDataAttribute;
import com.beanit.iec61850bean.Fc;
import com.beanit.iec61850bean.ObjectReference;
import com.beanit.iec61850bean.ServiceError;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.Identifier;
import com.beanit.iec61850bean.internal.mms.asn1.TypeDescription;
import com.beanit.iec61850bean.internal.mms.asn1.TypeSpecification;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ModelNode
implements Iterable<ModelNode> {
    protected ObjectReference objectReference;
    protected Map<String, ModelNode> children;
    ModelNode parent;

    public abstract ModelNode copy();

    public ModelNode getChild(String name) {
        return this.getChild(name, null);
    }

    public ModelNode getChild(String name, Fc fc) {
        return this.children.get(name);
    }

    public Collection<ModelNode> getChildren() {
        if (this.children == null) {
            return null;
        }
        return this.children.values();
    }

    protected Iterator<Iterator<? extends ModelNode>> getIterators() {
        ArrayList<Iterator<ModelNode>> iterators = new ArrayList<Iterator<ModelNode>>();
        if (this.children != null) {
            iterators.add(this.children.values().iterator());
        }
        return iterators.iterator();
    }

    public ObjectReference getReference() {
        return this.objectReference;
    }

    public String getName() {
        return this.objectReference.getName();
    }

    @Override
    public Iterator<ModelNode> iterator() {
        return this.children.values().iterator();
    }

    public List<BasicDataAttribute> getBasicDataAttributes() {
        ArrayList<BasicDataAttribute> subBasicDataAttributes = new ArrayList<BasicDataAttribute>();
        for (ModelNode child : this.children.values()) {
            subBasicDataAttributes.addAll(child.getBasicDataAttributes());
        }
        return subBasicDataAttributes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReference().toString());
        for (ModelNode childNode : this.children.values()) {
            sb.append("\n");
            sb.append(childNode.toString());
        }
        return sb.toString();
    }

    public ModelNode getParent() {
        return this.parent;
    }

    void setParent(ModelNode parent) {
        this.parent = parent;
    }

    Data getMmsDataObj() {
        return null;
    }

    void setValueFromMmsDataObj(Data data) throws ServiceError {
    }

    TypeDescription getMmsTypeSpec() {
        TypeDescription.Structure.Components componentsSequenceType = new TypeDescription.Structure.Components();
        List<TypeDescription.Structure.Components.SEQUENCE> structComponents = componentsSequenceType.getSEQUENCE();
        for (ModelNode child : this.children.values()) {
            TypeSpecification typeSpecification = new TypeSpecification();
            typeSpecification.setTypeDescription(child.getMmsTypeSpec());
            TypeDescription.Structure.Components.SEQUENCE component = new TypeDescription.Structure.Components.SEQUENCE();
            component.setComponentName(new Identifier(child.getName().getBytes(StandardCharsets.UTF_8)));
            component.setComponentType(typeSpecification);
            structComponents.add(component);
        }
        TypeDescription.Structure structure = new TypeDescription.Structure();
        structure.setComponents(componentsSequenceType);
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setStructure(structure);
        return typeDescription;
    }
}

