/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ObjectReference
implements Iterable<String> {
    private final String objectReference;
    private List<String> nodeNames = null;
    private int arrayIndexPosition = -1;

    public ObjectReference(String objectReference) {
        if (objectReference == null || objectReference.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.objectReference = objectReference;
    }

    public String getName() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.get(this.nodeNames.size() - 1);
    }

    public String getLdName() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.get(0);
    }

    public String toString() {
        return this.objectReference;
    }

    public boolean isLogicalDeviceRef() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.size() == 1;
    }

    public boolean isLogicalNodeRef() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.size() == 2;
    }

    public boolean isDataRef() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.size() > 2;
    }

    int getArrayIndexPosition() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.arrayIndexPosition;
    }

    @Override
    public Iterator<String> iterator() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.iterator();
    }

    public String get(int i) {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.get(i);
    }

    public int size() {
        if (this.nodeNames == null) {
            this.parseForNameList();
        }
        return this.nodeNames.size();
    }

    private void parseForNameList() {
        this.nodeNames = new ArrayList<String>();
        int lastDelim = -1;
        int nextDelim = this.objectReference.indexOf(47);
        if (nextDelim == -1) {
            this.nodeNames.add(this.objectReference.substring(lastDelim + 1));
            return;
        }
        this.nodeNames.add(this.objectReference.substring(lastDelim + 1, nextDelim));
        int dotIndex = -1;
        int openingbracketIndex = -1;
        int closingbracketIndex = -1;
        while (true) {
            lastDelim = nextDelim;
            if (dotIndex == -1 && (dotIndex = this.objectReference.indexOf(46, lastDelim + 1)) == -1) {
                dotIndex = this.objectReference.length();
            }
            if (openingbracketIndex == -1 && (openingbracketIndex = this.objectReference.indexOf(40, lastDelim + 1)) == -1) {
                openingbracketIndex = this.objectReference.length();
            }
            if (closingbracketIndex == -1 && (closingbracketIndex = this.objectReference.indexOf(41, lastDelim + 1)) == -1) {
                closingbracketIndex = this.objectReference.length();
            }
            if (dotIndex == openingbracketIndex && dotIndex == closingbracketIndex) {
                this.nodeNames.add(this.objectReference.substring(lastDelim + 1));
                return;
            }
            if (dotIndex < openingbracketIndex && dotIndex < closingbracketIndex) {
                nextDelim = dotIndex;
                dotIndex = -1;
            } else if (openingbracketIndex < dotIndex && openingbracketIndex < closingbracketIndex) {
                nextDelim = openingbracketIndex;
                openingbracketIndex = -1;
                this.arrayIndexPosition = this.nodeNames.size() + 1;
            } else if (closingbracketIndex < dotIndex && closingbracketIndex < openingbracketIndex) {
                if (closingbracketIndex == this.objectReference.length() - 1) {
                    this.nodeNames.add(this.objectReference.substring(lastDelim + 1, closingbracketIndex));
                    return;
                }
                nextDelim = closingbracketIndex + 1;
                closingbracketIndex = -1;
                dotIndex = -1;
                this.nodeNames.add(this.objectReference.substring(lastDelim + 1, nextDelim - 1));
                continue;
            }
            this.nodeNames.add(this.objectReference.substring(lastDelim + 1, nextDelim));
        }
    }
}

