/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean;

public final class ServiceError
extends Exception {
    public static final int NO_ERROR = 0;
    public static final int INSTANCE_NOT_AVAILABLE = 1;
    public static final int INSTANCE_IN_USE = 2;
    public static final int ACCESS_VIOLATION = 3;
    public static final int ACCESS_NOT_ALLOWED_IN_CURRENT_STATE = 4;
    public static final int PARAMETER_VALUE_INAPPROPRIATE = 5;
    public static final int PARAMETER_VALUE_INCONSISTENT = 6;
    public static final int CLASS_NOT_SUPPORTED = 7;
    public static final int INSTANCE_LOCKED_BY_OTHER_CLIENT = 8;
    public static final int CONTROL_MUST_BE_SELECTED = 9;
    public static final int TYPE_CONFLICT = 10;
    public static final int FAILED_DUE_TO_COMMUNICATIONS_CONSTRAINT = 11;
    public static final int FAILED_DUE_TO_SERVER_CONSTRAINT = 12;
    public static final int APPLICATION_UNREACHABLE = 13;
    public static final int CONNECTION_LOST = 14;
    public static final int MEMORY_UNAVAILABLE = 15;
    public static final int PROCESSOR_RESOURCE_UNAVAILABLE = 16;
    public static final int FILE_NONE_EXISTENT = 17;
    public static final int FATAL = 20;
    public static final int TIMEOUT = 22;
    public static final int UNKNOWN = 23;
    private static final long serialVersionUID = 4290107163231828564L;
    private final int errorCode;

    public ServiceError(int errorCode) {
        this(errorCode, "", null);
    }

    public ServiceError(int errorCode, String s) {
        this(errorCode, s, null);
    }

    public ServiceError(int errorCode, Throwable cause) {
        this(errorCode, "", cause);
    }

    public ServiceError(int errorCode, String s, Throwable cause) {
        super("Service error: " + ServiceError.getErrorName(errorCode) + "(" + errorCode + ")" + (s.isEmpty() ? "" : " " + s), cause);
        this.errorCode = errorCode;
    }

    private static String getErrorName(int code) {
        switch (code) {
            case 0: {
                return "NO_ERROR";
            }
            case 1: {
                return "INSTANCE_NOT_AVAILABLE";
            }
            case 2: {
                return "INSTANCE_IN_USE";
            }
            case 3: {
                return "ACCESS_VIOLATION";
            }
            case 4: {
                return "ACCESS_NOT_ALLOWED_IN_CURRENT_STATE";
            }
            case 5: {
                return "PARAMETER_VALUE_INAPPROPRIATE";
            }
            case 6: {
                return "PARAMETER_VALUE_INCONSISTENT";
            }
            case 7: {
                return "CLASS_NOT_SUPPORTED";
            }
            case 8: {
                return "INSTANCE_LOCKED_BY_OTHER_CLIENT";
            }
            case 9: {
                return "CONTROL_MUST_BE_SELECTED";
            }
            case 10: {
                return "TYPE_CONFLICT";
            }
            case 11: {
                return "FAILED_DUE_TO_COMMUNICATIONS_CONSTRAINT";
            }
            case 12: {
                return "FAILED_DUE_TO_SERVER_CONSTRAINT";
            }
            case 13: {
                return "APPLICATION_UNREACHABLE";
            }
            case 14: {
                return "CONNECTION_LOST";
            }
            case 15: {
                return "MEMORY_UNAVAILABLE";
            }
            case 16: {
                return "PROCESSOR_RESOURCE_UNAVAILABLE";
            }
            case 17: {
                return "FILE_NONE_EXISTENT";
            }
            case 20: {
                return "FATAL";
            }
            case 22: {
                return "TIMEOUT_ERROR";
            }
            case 23: {
                return "UNKNOWN";
            }
        }
        return "Unknown ServiceError code";
    }

    public int getErrorCode() {
        return this.errorCode;
    }
}

