/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaFloat32;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;

public class Float32DataBind
extends TextFieldDataBind<BdaFloat32> {
    private static final FloatFilter FILTER = new FloatFilter();

    public Float32DataBind(BdaFloat32 data) {
        super(data, BdaType.FLOAT32, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(((BdaFloat32)this.data).getFloat().toString());
    }

    @Override
    protected void writeImpl() {
        float newFloat = Float.parseFloat(this.inputField.getText());
        ((BdaFloat32)this.data).setFloat(Float.valueOf(newFloat));
    }

    private static class FloatFilter
    extends TextFieldDataBind.AbstractFilter {
        private FloatFilter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Float.parseFloat(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

