/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaFloat64;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;

public class Float64DataBind
extends TextFieldDataBind<BdaFloat64> {
    private static final DoubleFilter FILTER = new DoubleFilter();

    public Float64DataBind(BdaFloat64 data) {
        super(data, BdaType.FLOAT64, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(((BdaFloat64)this.data).getDouble().toString());
    }

    @Override
    protected void writeImpl() {
        double newDouble = Double.parseDouble(this.inputField.getText());
        ((BdaFloat64)this.data).setDouble(newDouble);
    }

    private static class DoubleFilter
    extends TextFieldDataBind.AbstractFilter {
        private DoubleFilter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

