/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaInt16U;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;

public class Int16UDataBind
extends TextFieldDataBind<BdaInt16U> {
    private static final UInt16Filter FILTER = new UInt16Filter();

    public Int16UDataBind(BdaInt16U data) {
        super(data, BdaType.INT16U, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Integer.toString(((BdaInt16U)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt16U)this.data).setValue(Integer.parseInt(this.inputField.getText()));
    }

    private static class UInt16Filter
    extends TextFieldDataBind.AbstractFilter {
        private UInt16Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                int value = Integer.parseInt(text);
                return value >= 0 && value <= 65535;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

