/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaInt32;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;

public class Int32DataBind
extends TextFieldDataBind<BdaInt32> {
    private static final Int32Filter FILTER = new Int32Filter();

    public Int32DataBind(BdaInt32 data) {
        super(data, BdaType.INT32, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Integer.toString(((BdaInt32)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt32)this.data).setValue(Integer.parseInt(this.inputField.getText()));
    }

    private static class Int32Filter
    extends TextFieldDataBind.AbstractFilter {
        private Int32Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Integer.parseInt(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

