/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaInt64;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;

public class Int64DataBind
extends TextFieldDataBind<BdaInt64> {
    private static final Int64Filter FILTER = new Int64Filter();

    public Int64DataBind(BdaInt64 data) {
        super(data, BdaType.INT64, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(Long.toString(((BdaInt64)this.data).getValue()));
    }

    @Override
    protected void writeImpl() {
        ((BdaInt64)this.data).setValue(Long.parseLong(this.inputField.getText()));
    }

    private static class Int64Filter
    extends TextFieldDataBind.AbstractFilter {
        private Int64Filter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Long.parseLong(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

