/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaTimestamp;
import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;
import java.time.Instant;
import java.time.format.DateTimeParseException;

public class TimeStampDataBind
extends TextFieldDataBind<BdaTimestamp> {
    private static final TimestampFilter FILTER = new TimestampFilter();

    public TimeStampDataBind(BdaTimestamp data) {
        super(data, BdaType.TIMESTAMP, FILTER);
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(((BdaTimestamp)this.data).getInstant().toString());
    }

    @Override
    protected void writeImpl() {
        ((BdaTimestamp)this.data).setInstant(Instant.parse(this.inputField.getText()));
    }

    private static class TimestampFilter
    extends TextFieldDataBind.AbstractFilter {
        private TimestampFilter() {
        }

        @Override
        protected boolean test(String text) {
            try {
                Instant.parse(text);
                return true;
            }
            catch (DateTimeParseException e) {
                return false;
            }
        }
    }
}

