/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.clientgui.databind;

import com.beanit.iec61850bean.BdaType;
import com.beanit.iec61850bean.BdaVisibleString;
import com.beanit.iec61850bean.clientgui.databind.TextFieldDataBind;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

public class VisibleStringDataBind
extends TextFieldDataBind<BdaVisibleString> {
    private static final Charset ASCII = StandardCharsets.US_ASCII;

    public VisibleStringDataBind(BdaVisibleString data) {
        super(data, BdaType.VISIBLE_STRING, new AsciiFilter(data.getMaxLength()));
    }

    @Override
    protected void resetImpl() {
        this.inputField.setText(new String(((BdaVisibleString)this.data).getValue(), ASCII));
    }

    @Override
    protected void writeImpl() {
        ((BdaVisibleString)this.data).setValue(ASCII.encode(this.inputField.getText()).array());
    }

    private static class AsciiFilter
    extends TextFieldDataBind.AbstractFilter {
        private final CharsetEncoder encoder = StandardCharsets.US_ASCII.newEncoder();
        private final int maxBytes;

        public AsciiFilter(int maxBytes) {
            this.maxBytes = maxBytes;
        }

        @Override
        protected boolean test(String text) {
            try {
                byte[] codedString = this.encoder.encode(CharBuffer.wrap(text)).array();
                return codedString.length <= this.maxBytes;
            }
            catch (CharacterCodingException e) {
                return false;
            }
        }
    }
}

