/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.cli;

import com.beanit.iec61850bean.internal.cli.Action;
import com.beanit.iec61850bean.internal.cli.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;

public class ActionProcessor {
    private static final String SEPARATOR_LINE = "------------------------------------------------------";
    private final BufferedReader reader;
    private final ActionListener actionListener;
    private final Map<String, Action> actionMap = new LinkedHashMap<String, Action>();
    private final Action helpAction = new Action("h", "print help message");
    private final Action quitAction = new Action("q", "quit the application");
    private volatile boolean closed = false;

    public ActionProcessor(ActionListener actionListener) {
        this.reader = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        this.actionListener = actionListener;
    }

    public void addAction(Action action) {
        this.actionMap.put(action.getKey(), action);
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        this.actionMap.put(this.helpAction.getKey(), this.helpAction);
        this.actionMap.put(this.quitAction.getKey(), this.quitAction);
        this.printHelp();
        try {
            while (true) {
                String actionKey;
                if (this.closed) {
                    System.exit(1);
                    return;
                }
                System.out.println("\n** Enter action key: ");
                try {
                    actionKey = this.reader.readLine();
                }
                catch (IOException e) {
                    System.err.printf("%s. Application is being shut down.\n", e.getMessage());
                    System.exit(2);
                    this.close();
                    return;
                }
                if (this.closed) {
                    System.exit(1);
                    return;
                }
                if (this.actionMap.get(actionKey) == null) {
                    System.err.println("Illegal action key.\n");
                    this.printHelp();
                    continue;
                }
                if (actionKey.equals(this.helpAction.getKey())) {
                    this.printHelp();
                    continue;
                }
                if (actionKey.equals(this.quitAction.getKey())) {
                    this.actionListener.quit();
                    return;
                }
                this.actionListener.actionCalled(actionKey);
                continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.actionListener.quit();
            return;
        }
        finally {
            this.close();
        }
    }

    private void printHelp() {
        String message = " %s - %s\n";
        System.out.flush();
        System.out.println();
        System.out.println(SEPARATOR_LINE);
        for (Action action : this.actionMap.values()) {
            System.out.printf(" %s - %s\n", action.getKey(), action.getDescription());
        }
        System.out.println(SEPARATOR_LINE);
    }

    public void close() {
        this.closed = true;
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

