/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.cli;

import com.beanit.iec61850bean.internal.cli.CliParameterBuilder;
import com.beanit.iec61850bean.internal.cli.CliParseException;
import com.beanit.iec61850bean.internal.cli.ValueCliParameter;

public class IntCliParameter
extends ValueCliParameter {
    Integer value;
    private Integer defaultValue = null;

    IntCliParameter(CliParameterBuilder builder, String parameterName, int defaultValue) {
        super(builder, parameterName);
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    IntCliParameter(CliParameterBuilder builder, String parameterName) {
        super(builder, parameterName);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    int parse(String[] args, int i) throws CliParseException {
        this.selected = true;
        if (args.length < i + 2) {
            throw new CliParseException("Parameter " + this.name + " has no value.");
        }
        try {
            this.value = Integer.decode(args[i + 1]);
        }
        catch (Exception e) {
            throw new CliParseException("Parameter value " + args[i + 1] + " cannot be converted to int.");
        }
        return 2;
    }

    @Override
    void appendDescription(StringBuilder sb) {
        super.appendDescription(sb);
        if (this.defaultValue != null) {
            sb.append(" Default is ").append(this.defaultValue).append(".");
        }
    }
}

