/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.Data;
import com.beanit.iec61850bean.internal.mms.asn1.DataAccessError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AccessResult
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private DataAccessError failure = null;
    private Data success = null;

    public AccessResult() {
    }

    public AccessResult(byte[] code) {
        this.code = code;
    }

    public DataAccessError getFailure() {
        return this.failure;
    }

    public void setFailure(DataAccessError failure) {
        this.failure = failure;
    }

    public Data getSuccess() {
        return this.success;
    }

    public void setSuccess(Data success) {
        this.success = success;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.success != null) {
            return codeLength += this.success.encode(reverseOS);
        }
        if (this.failure != null) {
            codeLength += this.failure.encode(reverseOS, false);
            reverseOS.write(128);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 0)) {
            this.failure = new DataAccessError();
            return tlvByteCount += this.failure.decode(is, false);
        }
        this.success = new Data();
        int numDecodedBytes = this.success.decode(is, berTag);
        if (numDecodedBytes != 0) {
            return tlvByteCount + numDecodedBytes;
        }
        this.success = null;
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.failure != null) {
            sb.append("failure: ").append((Object)this.failure);
            return;
        }
        if (this.success != null) {
            sb.append("success: ");
            this.success.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

