/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.ConcludeRequestPDU;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedErrorPDU;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedRequestPDU;
import com.beanit.iec61850bean.internal.mms.asn1.ConfirmedResponsePDU;
import com.beanit.iec61850bean.internal.mms.asn1.InitiateErrorPDU;
import com.beanit.iec61850bean.internal.mms.asn1.InitiateRequestPDU;
import com.beanit.iec61850bean.internal.mms.asn1.InitiateResponsePDU;
import com.beanit.iec61850bean.internal.mms.asn1.RejectPDU;
import com.beanit.iec61850bean.internal.mms.asn1.UnconfirmedPDU;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class MMSpdu
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private ConfirmedRequestPDU confirmedRequestPDU = null;
    private ConfirmedResponsePDU confirmedResponsePDU = null;
    private ConfirmedErrorPDU confirmedErrorPDU = null;
    private UnconfirmedPDU unconfirmedPDU = null;
    private RejectPDU rejectPDU = null;
    private InitiateRequestPDU initiateRequestPDU = null;
    private InitiateResponsePDU initiateResponsePDU = null;
    private InitiateErrorPDU initiateErrorPDU = null;
    private ConcludeRequestPDU concludeRequestPDU = null;

    public MMSpdu() {
    }

    public MMSpdu(byte[] code) {
        this.code = code;
    }

    public ConfirmedRequestPDU getConfirmedRequestPDU() {
        return this.confirmedRequestPDU;
    }

    public void setConfirmedRequestPDU(ConfirmedRequestPDU confirmedRequestPDU) {
        this.confirmedRequestPDU = confirmedRequestPDU;
    }

    public ConfirmedResponsePDU getConfirmedResponsePDU() {
        return this.confirmedResponsePDU;
    }

    public void setConfirmedResponsePDU(ConfirmedResponsePDU confirmedResponsePDU) {
        this.confirmedResponsePDU = confirmedResponsePDU;
    }

    public ConfirmedErrorPDU getConfirmedErrorPDU() {
        return this.confirmedErrorPDU;
    }

    public void setConfirmedErrorPDU(ConfirmedErrorPDU confirmedErrorPDU) {
        this.confirmedErrorPDU = confirmedErrorPDU;
    }

    public UnconfirmedPDU getUnconfirmedPDU() {
        return this.unconfirmedPDU;
    }

    public void setUnconfirmedPDU(UnconfirmedPDU unconfirmedPDU) {
        this.unconfirmedPDU = unconfirmedPDU;
    }

    public RejectPDU getRejectPDU() {
        return this.rejectPDU;
    }

    public void setRejectPDU(RejectPDU rejectPDU) {
        this.rejectPDU = rejectPDU;
    }

    public InitiateRequestPDU getInitiateRequestPDU() {
        return this.initiateRequestPDU;
    }

    public void setInitiateRequestPDU(InitiateRequestPDU initiateRequestPDU) {
        this.initiateRequestPDU = initiateRequestPDU;
    }

    public InitiateResponsePDU getInitiateResponsePDU() {
        return this.initiateResponsePDU;
    }

    public void setInitiateResponsePDU(InitiateResponsePDU initiateResponsePDU) {
        this.initiateResponsePDU = initiateResponsePDU;
    }

    public InitiateErrorPDU getInitiateErrorPDU() {
        return this.initiateErrorPDU;
    }

    public void setInitiateErrorPDU(InitiateErrorPDU initiateErrorPDU) {
        this.initiateErrorPDU = initiateErrorPDU;
    }

    public ConcludeRequestPDU getConcludeRequestPDU() {
        return this.concludeRequestPDU;
    }

    public void setConcludeRequestPDU(ConcludeRequestPDU concludeRequestPDU) {
        this.concludeRequestPDU = concludeRequestPDU;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.concludeRequestPDU != null) {
            codeLength += this.concludeRequestPDU.encode(reverseOS, false);
            reverseOS.write(139);
            return ++codeLength;
        }
        if (this.initiateErrorPDU != null) {
            codeLength += this.initiateErrorPDU.encode(reverseOS, false);
            reverseOS.write(170);
            return ++codeLength;
        }
        if (this.initiateResponsePDU != null) {
            codeLength += this.initiateResponsePDU.encode(reverseOS, false);
            reverseOS.write(169);
            return ++codeLength;
        }
        if (this.initiateRequestPDU != null) {
            codeLength += this.initiateRequestPDU.encode(reverseOS, false);
            reverseOS.write(168);
            return ++codeLength;
        }
        if (this.rejectPDU != null) {
            codeLength += this.rejectPDU.encode(reverseOS, false);
            reverseOS.write(164);
            return ++codeLength;
        }
        if (this.unconfirmedPDU != null) {
            codeLength += this.unconfirmedPDU.encode(reverseOS, false);
            reverseOS.write(163);
            return ++codeLength;
        }
        if (this.confirmedErrorPDU != null) {
            codeLength += this.confirmedErrorPDU.encode(reverseOS, false);
            reverseOS.write(162);
            return ++codeLength;
        }
        if (this.confirmedResponsePDU != null) {
            codeLength += this.confirmedResponsePDU.encode(reverseOS, false);
            reverseOS.write(161);
            return ++codeLength;
        }
        if (this.confirmedRequestPDU != null) {
            codeLength += this.confirmedRequestPDU.encode(reverseOS, false);
            reverseOS.write(160);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 0)) {
            this.confirmedRequestPDU = new ConfirmedRequestPDU();
            return tlvByteCount += this.confirmedRequestPDU.decode(is, false);
        }
        if (berTag.equals(128, 32, 1)) {
            this.confirmedResponsePDU = new ConfirmedResponsePDU();
            return tlvByteCount += this.confirmedResponsePDU.decode(is, false);
        }
        if (berTag.equals(128, 32, 2)) {
            this.confirmedErrorPDU = new ConfirmedErrorPDU();
            return tlvByteCount += this.confirmedErrorPDU.decode(is, false);
        }
        if (berTag.equals(128, 32, 3)) {
            this.unconfirmedPDU = new UnconfirmedPDU();
            return tlvByteCount += this.unconfirmedPDU.decode(is, false);
        }
        if (berTag.equals(128, 32, 4)) {
            this.rejectPDU = new RejectPDU();
            return tlvByteCount += this.rejectPDU.decode(is, false);
        }
        if (berTag.equals(128, 32, 8)) {
            this.initiateRequestPDU = new InitiateRequestPDU();
            return tlvByteCount += this.initiateRequestPDU.decode(is, false);
        }
        if (berTag.equals(128, 32, 9)) {
            this.initiateResponsePDU = new InitiateResponsePDU();
            return tlvByteCount += this.initiateResponsePDU.decode(is, false);
        }
        if (berTag.equals(128, 32, 10)) {
            this.initiateErrorPDU = new InitiateErrorPDU();
            return tlvByteCount += this.initiateErrorPDU.decode(is, false);
        }
        if (berTag.equals(128, 0, 11)) {
            this.concludeRequestPDU = new ConcludeRequestPDU();
            return tlvByteCount += this.concludeRequestPDU.decode(is, false);
        }
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.confirmedRequestPDU != null) {
            sb.append("confirmedRequestPDU: ");
            this.confirmedRequestPDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.confirmedResponsePDU != null) {
            sb.append("confirmedResponsePDU: ");
            this.confirmedResponsePDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.confirmedErrorPDU != null) {
            sb.append("confirmedErrorPDU: ");
            this.confirmedErrorPDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.unconfirmedPDU != null) {
            sb.append("unconfirmedPDU: ");
            this.unconfirmedPDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.rejectPDU != null) {
            sb.append("rejectPDU: ");
            this.rejectPDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.initiateRequestPDU != null) {
            sb.append("initiateRequestPDU: ");
            this.initiateRequestPDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.initiateResponsePDU != null) {
            sb.append("initiateResponsePDU: ");
            this.initiateResponsePDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.initiateErrorPDU != null) {
            sb.append("initiateErrorPDU: ");
            this.initiateErrorPDU.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.concludeRequestPDU != null) {
            sb.append("concludeRequestPDU: ").append((Object)this.concludeRequestPDU);
            return;
        }
        sb.append("<none>");
    }
}

