/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.iec61850bean.internal.mms.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.iec61850bean.internal.mms.asn1.AccessResult;
import com.beanit.iec61850bean.internal.mms.asn1.VariableAccessSpecification;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReadResponse
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private VariableAccessSpecification variableAccessSpecification = null;
    private ListOfAccessResult listOfAccessResult = null;

    public ReadResponse() {
    }

    public ReadResponse(byte[] code) {
        this.code = code;
    }

    public VariableAccessSpecification getVariableAccessSpecification() {
        return this.variableAccessSpecification;
    }

    public void setVariableAccessSpecification(VariableAccessSpecification variableAccessSpecification) {
        this.variableAccessSpecification = variableAccessSpecification;
    }

    public ListOfAccessResult getListOfAccessResult() {
        return this.listOfAccessResult;
    }

    public void setListOfAccessResult(ListOfAccessResult listOfAccessResult) {
        this.listOfAccessResult = listOfAccessResult;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.listOfAccessResult.encode(reverseOS, false);
        reverseOS.write(161);
        ++codeLength;
        if (this.variableAccessSpecification != null) {
            int sublength = this.variableAccessSpecification.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(160);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 32, 0)) {
            vByteCount += length.decode(is);
            this.variableAccessSpecification = new VariableAccessSpecification();
            vByteCount += this.variableAccessSpecification.decode(is, null);
            vByteCount += length.readEocIfIndefinite(is);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            this.listOfAccessResult = new ListOfAccessResult();
            if (lengthVal >= 0 && (vByteCount += this.listOfAccessResult.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.variableAccessSpecification != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("variableAccessSpecification: ");
            this.variableAccessSpecification.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.listOfAccessResult != null) {
            sb.append("listOfAccessResult: ");
            this.listOfAccessResult.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("listOfAccessResult: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class ListOfAccessResult
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private List<AccessResult> seqOf = null;

        public ListOfAccessResult() {
            this.seqOf = new ArrayList<AccessResult>();
        }

        public ListOfAccessResult(byte[] code) {
            this.code = code;
        }

        public List<AccessResult> getAccessResult() {
            if (this.seqOf == null) {
                this.seqOf = new ArrayList<AccessResult>();
            }
            return this.seqOf;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                codeLength += this.seqOf.get(i).encode(reverseOS);
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int tlByteCount = 0;
            int vByteCount = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                tlByteCount += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            tlByteCount += length.decode(is);
            int lengthVal = length.val;
            while (vByteCount < lengthVal || lengthVal < 0) {
                vByteCount += berTag.decode(is);
                if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                    vByteCount += BerLength.readEocByte((InputStream)is);
                    break;
                }
                AccessResult element = new AccessResult();
                int numDecodedBytes = element.decode(is, berTag);
                if (numDecodedBytes == 0) {
                    throw new IOException("Tag did not match");
                }
                vByteCount += numDecodedBytes;
                this.seqOf.add(element);
            }
            if (lengthVal >= 0 && vByteCount != lengthVal) {
                throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + lengthVal + " but has " + vByteCount);
            }
            return tlByteCount + vByteCount;
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.seqOf == null) {
                sb.append("null");
            } else {
                Iterator<AccessResult> it = this.seqOf.iterator();
                if (it.hasNext()) {
                    it.next().appendAsString(sb, indentLevel + 1);
                    while (it.hasNext()) {
                        sb.append(",\n");
                        for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                            sb.append("\t");
                        }
                        it.next().appendAsString(sb, indentLevel + 1);
                    }
                }
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

