/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack;

import com.beanit.josistack.AcseAssociation;
import com.beanit.josistack.AcseAssociationListener;
import com.beanit.josistack.ClientAcseSap;
import com.beanit.jositransport.ServerTSap;
import com.beanit.jositransport.TConnection;
import com.beanit.jositransport.TConnectionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import javax.net.ServerSocketFactory;

public final class ServerAcseSap
implements TConnectionListener {
    public ServerTSap serverTSap = null;
    public byte[] pSelLocal = ClientAcseSap.P_SEL_DEFAULT;
    private AcseAssociationListener associationListener = null;

    public ServerAcseSap(int port, int backlog, InetAddress bindAddr, AcseAssociationListener associationListener) {
        this(port, backlog, bindAddr, associationListener, ServerSocketFactory.getDefault());
    }

    public ServerAcseSap(int port, int backlog, InetAddress bindAddr, AcseAssociationListener associationListener, ServerSocketFactory serverSocketFactory) {
        this.associationListener = associationListener;
        this.serverTSap = new ServerTSap(port, backlog, bindAddr, this, serverSocketFactory);
    }

    public void startListening() throws IOException {
        if (this.associationListener == null || this.serverTSap == null) {
            throw new IllegalStateException("AcseSAP is unable to listen because it was not initialized.");
        }
        this.serverTSap.startListening();
    }

    public void stopListening() {
        this.serverTSap.stopListening();
    }

    @Override
    public void serverStoppedListeningIndication(IOException e) {
        this.associationListener.serverStoppedListeningIndication(e);
    }

    @Override
    public void connectionIndication(TConnection tConnection) {
        try {
            AcseAssociation acseAssociation = new AcseAssociation(tConnection, this.pSelLocal);
            ByteBuffer asdu = ByteBuffer.allocate(1000);
            try {
                asdu = acseAssociation.listenForCn(asdu);
            }
            catch (IOException e) {
                tConnection.close();
                return;
            }
            catch (TimeoutException e) {
                tConnection.close();
                return;
            }
            this.associationListener.connectionIndication(acseAssociation, asdu);
        }
        catch (Exception e) {
            tConnection.close();
        }
    }
}

