/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerBitString;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.asn1bean.ber.types.string.BerGraphicString;
import com.beanit.josistack.internal.acse.asn1.Myexternal2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AuthenticationValue
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private BerGraphicString charstring = null;
    private BerBitString bitstring = null;
    private Myexternal2 external = null;

    public AuthenticationValue() {
    }

    public AuthenticationValue(byte[] code) {
        this.code = code;
    }

    public BerGraphicString getCharstring() {
        return this.charstring;
    }

    public void setCharstring(BerGraphicString charstring) {
        this.charstring = charstring;
    }

    public BerBitString getBitstring() {
        return this.bitstring;
    }

    public void setBitstring(BerBitString bitstring) {
        this.bitstring = bitstring;
    }

    public Myexternal2 getExternal() {
        return this.external;
    }

    public void setExternal(Myexternal2 external) {
        this.external = external;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            return this.code.length;
        }
        int codeLength = 0;
        if (this.external != null) {
            codeLength += this.external.encode(reverseOS, false);
            reverseOS.write(162);
            return ++codeLength;
        }
        if (this.bitstring != null) {
            codeLength += this.bitstring.encode(reverseOS, false);
            reverseOS.write(129);
            return ++codeLength;
        }
        if (this.charstring != null) {
            codeLength += this.charstring.encode(reverseOS, false);
            reverseOS.write(128);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        boolean tagWasPassed;
        int tlvByteCount = 0;
        boolean bl = tagWasPassed = berTag != null;
        if (berTag == null) {
            berTag = new BerTag();
            tlvByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 0, 0)) {
            this.charstring = new BerGraphicString();
            return tlvByteCount += this.charstring.decode(is, false);
        }
        if (berTag.equals(128, 0, 1)) {
            this.bitstring = new BerBitString();
            return tlvByteCount += this.bitstring.decode(is, false);
        }
        if (berTag.equals(128, 32, 2)) {
            this.external = new Myexternal2();
            return tlvByteCount += this.external.decode(is, false);
        }
        if (tagWasPassed) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.charstring != null) {
            sb.append("charstring: ").append(this.charstring);
            return;
        }
        if (this.bitstring != null) {
            sb.append("bitstring: ").append(this.bitstring);
            return;
        }
        if (this.external != null) {
            sb.append("external: ");
            this.external.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

