/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerAny;
import com.beanit.asn1bean.ber.types.BerBitString;
import com.beanit.asn1bean.ber.types.BerOctetString;
import com.beanit.asn1bean.ber.types.BerType;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextIdentifier;
import com.beanit.josistack.internal.presentation.asn1.TransferSyntaxName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class PDVList
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    private byte[] code = null;
    private TransferSyntaxName transferSyntaxName = null;
    private PresentationContextIdentifier presentationContextIdentifier = null;
    private PresentationDataValues presentationDataValues = null;

    public PDVList() {
    }

    public PDVList(byte[] code) {
        this.code = code;
    }

    public TransferSyntaxName getTransferSyntaxName() {
        return this.transferSyntaxName;
    }

    public void setTransferSyntaxName(TransferSyntaxName transferSyntaxName) {
        this.transferSyntaxName = transferSyntaxName;
    }

    public PresentationContextIdentifier getPresentationContextIdentifier() {
        return this.presentationContextIdentifier;
    }

    public void setPresentationContextIdentifier(PresentationContextIdentifier presentationContextIdentifier) {
        this.presentationContextIdentifier = presentationContextIdentifier;
    }

    public PresentationDataValues getPresentationDataValues() {
        return this.presentationDataValues;
    }

    public void setPresentationDataValues(PresentationDataValues presentationDataValues) {
        this.presentationDataValues = presentationDataValues;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.presentationDataValues.encode(reverseOS);
        codeLength += this.presentationContextIdentifier.encode(reverseOS, true);
        if (this.transferSyntaxName != null) {
            codeLength += this.transferSyntaxName.encode(reverseOS, true);
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        vByteCount += berTag.decode(is);
        if (berTag.equals((Object)TransferSyntaxName.tag)) {
            this.transferSyntaxName = new TransferSyntaxName();
            vByteCount += this.transferSyntaxName.decode(is, false);
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals((Object)PresentationContextIdentifier.tag)) {
            this.presentationContextIdentifier = new PresentationContextIdentifier();
            vByteCount += this.presentationContextIdentifier.decode(is, false);
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        this.presentationDataValues = new PresentationDataValues();
        int numDecodedBytes = this.presentationDataValues.decode(is, berTag);
        if (numDecodedBytes != 0) {
            if (lengthVal >= 0 && (vByteCount += numDecodedBytes) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        } else {
            throw new IOException("Tag does not match mandatory sequence component.");
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.transferSyntaxName != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("transferSyntaxName: ").append((Object)this.transferSyntaxName);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.presentationContextIdentifier != null) {
            sb.append("presentationContextIdentifier: ").append((Object)this.presentationContextIdentifier);
        } else {
            sb.append("presentationContextIdentifier: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.presentationDataValues != null) {
            sb.append("presentationDataValues: ");
            this.presentationDataValues.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("presentationDataValues: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class PresentationDataValues
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] code = null;
        private BerAny singleASN1Type = null;
        private BerOctetString octetAligned = null;
        private BerBitString arbitrary = null;

        public PresentationDataValues() {
        }

        public PresentationDataValues(byte[] code) {
            this.code = code;
        }

        public BerAny getSingleASN1Type() {
            return this.singleASN1Type;
        }

        public void setSingleASN1Type(BerAny singleASN1Type) {
            this.singleASN1Type = singleASN1Type;
        }

        public BerOctetString getOctetAligned() {
            return this.octetAligned;
        }

        public void setOctetAligned(BerOctetString octetAligned) {
            this.octetAligned = octetAligned;
        }

        public BerBitString getArbitrary() {
            return this.arbitrary;
        }

        public void setArbitrary(BerBitString arbitrary) {
            this.arbitrary = arbitrary;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                reverseOS.write(this.code);
                return this.code.length;
            }
            int codeLength = 0;
            if (this.arbitrary != null) {
                codeLength += this.arbitrary.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.octetAligned != null) {
                codeLength += this.octetAligned.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.singleASN1Type != null) {
                int sublength = this.singleASN1Type.encode(reverseOS);
                codeLength += sublength;
                codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
                reverseOS.write(160);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            boolean tagWasPassed;
            int tlvByteCount = 0;
            boolean bl = tagWasPassed = berTag != null;
            if (berTag == null) {
                berTag = new BerTag();
                tlvByteCount += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 0)) {
                BerLength length = new BerLength();
                tlvByteCount += length.decode(is);
                this.singleASN1Type = new BerAny();
                tlvByteCount += this.singleASN1Type.decode(is, null);
                return tlvByteCount += length.readEocIfIndefinite(is);
            }
            if (berTag.equals(128, 0, 1)) {
                this.octetAligned = new BerOctetString();
                return tlvByteCount += this.octetAligned.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.arbitrary = new BerBitString();
                return tlvByteCount += this.arbitrary.decode(is, false);
            }
            if (tagWasPassed) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.singleASN1Type != null) {
                sb.append("singleASN1Type: ").append(this.singleASN1Type);
                return;
            }
            if (this.octetAligned != null) {
                sb.append("octetAligned: ").append(this.octetAligned);
                return;
            }
            if (this.arbitrary != null) {
                sb.append("arbitrary: ").append(this.arbitrary);
                return;
            }
            sb.append("<none>");
        }
    }
}

