/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jositransport;

import com.beanit.iec61850bean.internal.NamedThreadFactory;
import com.beanit.jositransport.TConnection;
import com.beanit.jositransport.TConnectionListener;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

final class ServerThread
extends Thread {
    private final ServerSocket serverSocket;
    private final int maxTPduSizeParam;
    private final int messageTimeout;
    private final int messageFragmentTimeout;
    private final int maxConnections;
    private final TConnectionListener connectionListener;
    private boolean stopServer = false;
    private int numConnections = 0;

    ServerThread(ServerSocket socket, int maxTPduSizeParam, int maxConnections, int messageTimeout, int messageFragmentTimeout, TConnectionListener connectionListener) {
        this.serverSocket = socket;
        this.maxTPduSizeParam = maxTPduSizeParam;
        this.maxConnections = maxConnections;
        this.messageTimeout = messageTimeout;
        this.messageFragmentTimeout = messageFragmentTimeout;
        this.connectionListener = connectionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket clientSocket;
        ExecutorService executor = Executors.newCachedThreadPool(new NamedThreadFactory("iec61850bean-server"));
        try {
            clientSocket = null;
            while (true) {
                try {
                    clientSocket = this.serverSocket.accept();
                }
                catch (IOException e) {
                    if (!this.stopServer) {
                        this.connectionListener.serverStoppedListeningIndication(e);
                    }
                    executor.shutdown();
                    return;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            executor.shutdown();
            throw throwable;
        }
        {
            boolean startConnection = false;
            ServerThread serverThread = this;
            synchronized (serverThread) {
                if (this.numConnections < this.maxConnections) {
                    ++this.numConnections;
                    startConnection = true;
                }
            }
            if (!startConnection) continue;
            executor.execute(new ConnectionHandler(clientSocket, this));
            continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionClosedSignal() {
        ServerThread serverThread = this;
        synchronized (serverThread) {
            --this.numConnections;
        }
    }

    void stopServer() {
        this.stopServer = true;
        if (this.serverSocket.isBound()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public final class ConnectionHandler
    extends Thread {
        private final Socket socket;
        private final ServerThread serverThread;

        ConnectionHandler(Socket socket, ServerThread serverThread) {
            this.socket = socket;
            this.serverThread = serverThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TConnection tConnection;
            try {
                tConnection = new TConnection(this.socket, ServerThread.this.maxTPduSizeParam, ServerThread.this.messageTimeout, ServerThread.this.messageFragmentTimeout, this.serverThread);
            }
            catch (IOException e) {
                ServerThread serverThread = ServerThread.this;
                synchronized (serverThread) {
                    ServerThread.this.numConnections--;
                }
                return;
            }
            try {
                tConnection.listenForCR();
            }
            catch (IOException e) {
                tConnection.close();
                return;
            }
            ServerThread.this.connectionListener.connectionIndication(tConnection);
        }
    }
}

