/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jositransport;

import com.beanit.iec61850bean.internal.util.SequenceNumber;
import com.beanit.jositransport.ClientTSap;
import com.beanit.jositransport.ServerThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public final class TConnection {
    private static final SequenceNumber connectionCounter = new SequenceNumber(1, 1, 65519);
    private final Socket socket;
    private final DataOutputStream os;
    private final DataInputStream is;
    private final ServerThread serverThread;
    public byte[] tSelRemote = null;
    public byte[] tSelLocal = null;
    private int srcRef;
    private int dstRef;
    private int maxTPduSizeParam;
    private int maxTPduSize;
    private int messageTimeout;
    private int messageFragmentTimeout;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TConnection(Socket socket, int maxTPduSizeParam, int messageTimeout, int messageFragmentTimeout, ServerThread serverThread) throws IOException {
        if (maxTPduSizeParam < 7 || maxTPduSizeParam > 16) {
            throw new RuntimeException("maxTPduSizeParam is incorrect");
        }
        this.socket = socket;
        this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
        this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        SequenceNumber sequenceNumber = connectionCounter;
        synchronized (sequenceNumber) {
            this.srcRef = connectionCounter.getAndIncrement();
        }
        this.messageTimeout = messageTimeout;
        this.messageFragmentTimeout = messageFragmentTimeout;
        this.maxTPduSizeParam = maxTPduSizeParam;
        this.maxTPduSize = ClientTSap.getMaxTPDUSize(maxTPduSizeParam);
        this.serverThread = serverThread;
    }

    void listenForCR() throws IOException {
        this.socket.setSoTimeout(this.messageFragmentTimeout);
        if (this.is.read() != 3) {
            throw new IOException();
        }
        if (this.is.read() != 0) {
            throw new IOException();
        }
        this.is.readShort();
        int lengthIndicator = this.is.read() & 0xFF;
        if ((this.is.read() & 0xFF) != 224) {
            throw new IOException();
        }
        if (this.is.readShort() != 0) {
            throw new IOException();
        }
        this.dstRef = this.is.readShort() & 0xFFFF;
        if ((this.is.read() & 0xFF) != 0) {
            throw new IOException();
        }
        int variableBytesRead = 0;
        block5: while (lengthIndicator > 6 + variableBytesRead) {
            byte myByte = this.is.readByte();
            switch (myByte & 0xFF) {
                case 194: {
                    int i;
                    int parameterLength = this.is.readByte() & 0xFF;
                    if (this.tSelLocal == null) {
                        this.tSelLocal = new byte[parameterLength];
                        this.is.readFully(this.tSelLocal);
                    } else {
                        if (parameterLength != this.tSelLocal.length) {
                            throw new IOException("local T-SElECTOR is wrong.");
                        }
                        for (i = 0; i < parameterLength; ++i) {
                            if ((this.tSelLocal[i] & 0xFF) == this.is.read()) continue;
                            throw new IOException("local T-SElECTOR is wrong.");
                        }
                    }
                    variableBytesRead += 2 + parameterLength;
                    continue block5;
                }
                case 193: {
                    int i;
                    int parameterLength = this.is.readByte() & 0xFF;
                    if (this.tSelRemote == null) {
                        this.tSelRemote = new byte[parameterLength];
                        this.is.readFully(this.tSelRemote);
                    } else {
                        if (parameterLength != this.tSelRemote.length) {
                            throw new IOException("remote T-SElECTOR is wrong.");
                        }
                        for (i = 0; i < parameterLength; ++i) {
                            if ((this.tSelRemote[i] & 0xFF) == this.is.read()) continue;
                            throw new IOException("remote T-SElECTOR is wrong.");
                        }
                    }
                    variableBytesRead += 2 + parameterLength;
                    continue block5;
                }
                case 192: {
                    if ((this.is.readByte() & 0xFF) != 1) {
                        throw new IOException();
                    }
                    myByte = this.is.readByte();
                    int newMaxTPDUSizeParam = myByte & 0xFF;
                    if (newMaxTPDUSizeParam < 7 || newMaxTPDUSizeParam > 16) {
                        throw new IOException("maxTPDUSizeParam is out of bound");
                    }
                    if (newMaxTPDUSizeParam < this.maxTPduSizeParam) {
                        this.maxTPduSizeParam = newMaxTPDUSizeParam;
                        this.maxTPduSize = ClientTSap.getMaxTPDUSize(this.maxTPduSizeParam);
                    }
                    variableBytesRead += 3;
                    continue block5;
                }
            }
            throw new IOException();
        }
        this.os.write(3);
        this.os.write(0);
        int variableLength = 3;
        if (this.tSelLocal != null) {
            variableLength += 2 + this.tSelLocal.length;
        }
        if (this.tSelRemote != null) {
            variableLength += 2 + this.tSelRemote.length;
        }
        this.os.writeShort(11 + variableLength);
        this.os.write(6 + variableLength);
        this.os.write(208);
        this.os.writeShort(this.dstRef);
        this.os.writeShort(this.srcRef);
        this.os.write(0);
        if (this.tSelLocal != null) {
            this.os.write(194);
            this.os.write(this.tSelLocal.length);
            this.os.write(this.tSelLocal);
        }
        if (this.tSelRemote != null) {
            this.os.write(193);
            this.os.write(this.tSelRemote.length);
            this.os.write(this.tSelRemote);
        }
        this.os.write(192);
        this.os.write(1);
        this.os.write(this.maxTPduSizeParam);
        this.os.flush();
    }

    void startConnection() throws IOException {
        this.os.write(3);
        this.os.write(0);
        int variableLength = 3;
        if (this.tSelLocal != null) {
            variableLength += 2 + this.tSelLocal.length;
        }
        if (this.tSelRemote != null) {
            variableLength += 2 + this.tSelRemote.length;
        }
        this.os.writeShort(11 + variableLength);
        this.os.write(6 + variableLength);
        this.os.write(224);
        this.os.write(0);
        this.os.write(0);
        this.os.writeShort(this.srcRef);
        this.os.write(0);
        this.os.write(192);
        this.os.write(1);
        this.os.write(this.maxTPduSizeParam);
        if (this.tSelRemote != null) {
            this.os.write(194);
            this.os.write(this.tSelRemote.length);
            this.os.write(this.tSelRemote);
        }
        if (this.tSelLocal != null) {
            this.os.write(193);
            this.os.write(this.tSelLocal.length);
            this.os.write(this.tSelLocal);
        }
        this.os.flush();
        this.socket.setSoTimeout(this.messageTimeout);
        if (this.is.readByte() != 3) {
            throw new IOException();
        }
        if (this.is.readByte() != 0) {
            throw new IOException();
        }
        this.is.readShort();
        int lengthIndicator = this.is.readByte() & 0xFF;
        if ((this.is.readByte() & 0xFF) != 208) {
            throw new IOException();
        }
        this.is.readShort();
        this.dstRef = this.is.readShort() & 0xFFFF;
        if (this.is.readByte() != 0) {
            throw new IOException();
        }
        int variableBytesRead = 0;
        block5: while (lengthIndicator > 6 + variableBytesRead) {
            byte myByte = this.is.readByte();
            switch (myByte & 0xFF) {
                case 193: {
                    int i;
                    int parameterLength = this.is.readByte() & 0xFF;
                    if (this.tSelLocal == null) {
                        this.tSelLocal = new byte[parameterLength];
                        this.is.readFully(this.tSelLocal);
                    } else {
                        for (i = 0; i < parameterLength; ++i) {
                            this.is.read();
                        }
                    }
                    variableBytesRead += 2 + parameterLength;
                    continue block5;
                }
                case 194: {
                    int i;
                    int parameterLength = this.is.readByte() & 0xFF;
                    if (this.tSelRemote == null) {
                        this.tSelRemote = new byte[parameterLength];
                        this.is.readFully(this.tSelRemote);
                    } else {
                        for (i = 0; i < parameterLength; ++i) {
                            this.is.read();
                        }
                    }
                    variableBytesRead += 2 + parameterLength;
                    continue block5;
                }
                case 192: {
                    if (this.is.readByte() != 1) {
                        throw new IOException("maxTPduSizeParam size is not equal to 1");
                    }
                    myByte = this.is.readByte();
                    if ((myByte & 0xFF) < 7 || (myByte & 0xFF) > this.maxTPduSizeParam) {
                        throw new IOException("maxTPduSizeParam out of bound");
                    }
                    if ((myByte & 0xFF) < this.maxTPduSizeParam) {
                        this.maxTPduSizeParam = myByte & 0xFF;
                    }
                    variableBytesRead += 4;
                    continue block5;
                }
            }
            throw new IOException();
        }
    }

    public void send(List<byte[]> tsdus, List<Integer> offsets, List<Integer> lengths) throws IOException {
        int bytesLeft = 0;
        for (int length : lengths) {
            bytesLeft += length;
        }
        int tsduOffset = 0;
        int byteArrayListIndex = 0;
        boolean lastPacket = false;
        int maxTSDUSize = this.maxTPduSize - 3;
        while (bytesLeft > 0) {
            int numBytesToWrite;
            if (bytesLeft > maxTSDUSize) {
                numBytesToWrite = maxTSDUSize;
            } else {
                numBytesToWrite = bytesLeft;
                lastPacket = true;
            }
            this.os.write(3);
            this.os.write(0);
            this.os.writeShort(numBytesToWrite + 7);
            this.os.write(2);
            this.os.write(240);
            if (lastPacket) {
                this.os.write(128);
            } else {
                this.os.write(0);
            }
            bytesLeft -= numBytesToWrite;
            while (numBytesToWrite > 0) {
                byte[] tsdu = tsdus.get(byteArrayListIndex);
                int length = lengths.get(byteArrayListIndex);
                int offset = offsets.get(byteArrayListIndex);
                int tsduWriteLength = length - tsduOffset;
                if (numBytesToWrite > tsduWriteLength) {
                    this.os.write(tsdu, offset + tsduOffset, tsduWriteLength);
                    numBytesToWrite -= tsduWriteLength;
                    tsduOffset = 0;
                    ++byteArrayListIndex;
                    continue;
                }
                this.os.write(tsdu, offset + tsduOffset, numBytesToWrite);
                if (numBytesToWrite == tsduWriteLength) {
                    tsduOffset = 0;
                    ++byteArrayListIndex;
                } else {
                    tsduOffset += numBytesToWrite;
                }
                numBytesToWrite = 0;
            }
            this.os.flush();
        }
    }

    public void send(byte[] tsdu, int offset, int length) throws IOException {
        ArrayList<byte[]> tsdus = new ArrayList<byte[]>();
        tsdus.add(tsdu);
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        offsets.add(offset);
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        lengths.add(length);
        this.send(tsdus, offsets, lengths);
    }

    public int getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(int messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public int getMessageFragmentTimeout() {
        return this.messageFragmentTimeout;
    }

    public void setMessageFragmentTimeout(int messageFragmentTimeout) {
        this.messageFragmentTimeout = messageFragmentTimeout;
    }

    public void receive(ByteBuffer tSduBuffer) throws EOFException, SocketTimeoutException, IOException, TimeoutException {
        byte version;
        tSduBuffer.mark();
        int eot = 0;
        int li = 0;
        this.socket.setSoTimeout(this.messageTimeout);
        try {
            version = this.is.readByte();
        }
        catch (SocketTimeoutException e) {
            throw new TimeoutException();
        }
        this.socket.setSoTimeout(this.messageFragmentTimeout);
        do {
            if (version != 3) {
                throw new IOException("Syntax error at beginning of RFC1006 header: version not equal to 3");
            }
            if (this.is.readByte() != 0) {
                throw new IOException("Syntax errorat beginning of RFC1006 header: reserved not equal to 0");
            }
            int packetLength = this.is.readShort() & 0xFFFF;
            if (packetLength <= 7) {
                throw new IOException("Syntax error: packet length parameter < 7");
            }
            li = this.is.readByte() & 0xFF;
            int tPduCode = this.is.readByte() & 0xFF;
            if (tPduCode == 240) {
                if (li != 2) {
                    throw new IOException("Syntax error: LI field does not equal 2");
                }
                eot = this.is.readByte() & 0xFF;
                if (eot != 0 && eot != 128) {
                    throw new IOException("Syntax error: eot wrong");
                }
                if (packetLength - 7 > tSduBuffer.limit() - tSduBuffer.position()) {
                    throw new IOException("tSduBuffer size is too small to hold the complete TSDU");
                }
            } else {
                if (tPduCode == 128) {
                    if (li != 6) {
                        throw new IOException("Syntax error: LI field does not equal 6");
                    }
                    if (this.is.readShort() != this.srcRef) {
                        throw new IOException("Syntax error: srcRef wrong");
                    }
                    if (this.is.readShort() != this.dstRef) {
                        throw new IOException("Syntax error: dstRef wrong");
                    }
                    int reason = this.is.readByte() & 0xFF;
                    if (reason > 4) {
                        throw new IOException("Syntax error: reason out of bound");
                    }
                    throw new EOFException("Disconnect request. Reason:" + reason);
                }
                if (tPduCode == 112) {
                    throw new IOException("Got TPDU error (ER) message");
                }
                throw new IOException("Syntax error: unknown TPDU code");
            }
            this.is.readFully(tSduBuffer.array(), tSduBuffer.arrayOffset() + tSduBuffer.position(), packetLength - 7);
            tSduBuffer.position(tSduBuffer.position() + packetLength - 7);
            if (eot == 128) continue;
            version = this.is.readByte();
        } while (eot != 128);
        tSduBuffer.limit(tSduBuffer.position());
        tSduBuffer.reset();
    }

    public void disconnect() {
        try {
            this.os.write(3);
            this.os.write(0);
            this.os.writeShort(11);
            this.os.write(6);
            this.os.write(128);
            this.os.writeShort(this.dstRef);
            this.os.writeShort(this.srcRef);
            this.os.write(0);
            this.os.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            try {
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.serverThread != null) {
                this.serverThread.connectionClosedSignal();
            }
        }
    }
}

