/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jasn1.ber.types;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.internal.Util;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.jasn1.util.HexConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class BerAny
implements Serializable,
BerType {
    private static final long serialVersionUID = 1L;
    public byte[] value;

    public BerAny() {
    }

    public BerAny(byte[] value) {
        this.value = value;
    }

    @Override
    public int encode(OutputStream reverseOS) throws IOException {
        reverseOS.write(this.value);
        return this.value.length;
    }

    @Override
    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag tag) throws IOException {
        int tagLength;
        int decodedLength = 0;
        if (tag == null) {
            tag = new BerTag();
            tagLength = tag.decode(is);
            decodedLength += tagLength;
        } else {
            tagLength = tag.encode(new ReverseByteArrayOutputStream(10));
        }
        BerLength lengthField = new BerLength();
        int lengthLength = lengthField.decode(is);
        decodedLength += lengthLength + lengthField.val;
        this.value = new byte[tagLength + lengthLength + lengthField.val];
        Util.readFully(is, this.value, tagLength + lengthLength, lengthField.val);
        ReverseByteArrayOutputStream os = new ReverseByteArrayOutputStream(this.value, tagLength + lengthLength - 1);
        BerLength.encodeLength(os, lengthField.val);
        tag.encode(os);
        return decodedLength;
    }

    public String toString() {
        return HexConverter.toShortHexString(this.value);
    }
}

