/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack;

import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerAny;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerObjectIdentifier;
import com.beanit.jasn1.ber.types.string.BerGraphicString;
import com.beanit.josistack.ByteBufferInputStream;
import com.beanit.josistack.DecodingException;
import com.beanit.josistack.internal.acse.asn1.AAREApdu;
import com.beanit.josistack.internal.acse.asn1.AARQApdu;
import com.beanit.josistack.internal.acse.asn1.ACSEApdu;
import com.beanit.josistack.internal.acse.asn1.ACSERequirements;
import com.beanit.josistack.internal.acse.asn1.AEQualifier;
import com.beanit.josistack.internal.acse.asn1.AEQualifierForm2;
import com.beanit.josistack.internal.acse.asn1.APTitle;
import com.beanit.josistack.internal.acse.asn1.APTitleForm2;
import com.beanit.josistack.internal.acse.asn1.AssociateResult;
import com.beanit.josistack.internal.acse.asn1.AssociateSourceDiagnostic;
import com.beanit.josistack.internal.acse.asn1.AssociationInformation;
import com.beanit.josistack.internal.acse.asn1.AuthenticationValue;
import com.beanit.josistack.internal.acse.asn1.MechanismName;
import com.beanit.josistack.internal.acse.asn1.Myexternal;
import com.beanit.josistack.internal.presentation.asn1.CPAPPDU;
import com.beanit.josistack.internal.presentation.asn1.CPType;
import com.beanit.josistack.internal.presentation.asn1.CalledPresentationSelector;
import com.beanit.josistack.internal.presentation.asn1.CallingPresentationSelector;
import com.beanit.josistack.internal.presentation.asn1.FullyEncodedData;
import com.beanit.josistack.internal.presentation.asn1.ModeSelector;
import com.beanit.josistack.internal.presentation.asn1.PDVList;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextDefinitionList;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextDefinitionResultList;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextIdentifier;
import com.beanit.josistack.internal.presentation.asn1.RespondingPresentationSelector;
import com.beanit.josistack.internal.presentation.asn1.UserData;
import com.beanit.jositransport.ClientTSap;
import com.beanit.jositransport.TConnection;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;

public final class AcseAssociation {
    private static final PresentationContextDefinitionList context_list = new PresentationContextDefinitionList(new byte[]{35, 48, 15, 2, 1, 1, 6, 4, 82, 1, 0, 1, 48, 4, 6, 2, 81, 1, 48, 16, 2, 1, 3, 6, 5, 40, -54, 34, 2, 1, 48, 4, 6, 2, 81, 1});
    private static final PresentationContextIdentifier acsePresentationContextId = new PresentationContextIdentifier(new byte[]{1, 1});
    private static final ModeSelector normalModeSelector = new ModeSelector();
    private static final PresentationContextDefinitionResultList presentationResultList = new PresentationContextDefinitionResultList(new byte[]{18, 48, 7, -128, 1, 0, -127, 2, 81, 1, 48, 7, -128, 1, 0, -127, 2, 81, 1});
    private static final AssociateResult aareAccepted = new AssociateResult(new byte[]{1, 0});
    private static final AssociateSourceDiagnostic associateSourceDiagnostic = new AssociateSourceDiagnostic(new byte[]{-95, 3, 2, 1, 0});
    private static final BerObjectIdentifier application_context_name = new BerObjectIdentifier(new byte[]{5, 40, -54, 34, 2, 3});
    private static final BerObjectIdentifier directReference = new BerObjectIdentifier(new byte[]{2, 81, 1});
    private static final BerInteger indirectReference = new BerInteger(new byte[]{1, 3});
    private static final MechanismName default_mechanism_name = new MechanismName(new byte[]{3, 82, 3, 1});
    private final RespondingPresentationSelector pSelLocalBerOctetString;
    private boolean connected = false;
    private TConnection tConnection;
    private ByteBuffer associateResponseAPDU = null;

    AcseAssociation(TConnection tConnection, byte[] pSelLocal) {
        this.tConnection = tConnection;
        this.pSelLocalBerOctetString = new RespondingPresentationSelector(pSelLocal);
    }

    private static ByteBuffer decodePConResponse(ByteBuffer ppdu) throws IOException {
        CPAPPDU cpa_ppdu = new CPAPPDU();
        InputStream iStream = new ByteBufferInputStream(ppdu);
        cpa_ppdu.decode(iStream);
        iStream = new ByteArrayInputStream(cpa_ppdu.getNormalModeParameters().getUserData().getFullyEncodedData().getPDVList().get((int)0).getPresentationDataValues().getSingleASN1Type().value);
        ACSEApdu acseApdu = new ACSEApdu();
        acseApdu.decode(iStream, null);
        return ByteBuffer.wrap(acseApdu.getAare().getUserInformation().getMyexternal().get((int)0).getEncoding().getSingleASN1Type().value);
    }

    private static UserData getPresentationUserDataField(byte[] userDataBytes) {
        PDVList.PresentationDataValues presDataValues = new PDVList.PresentationDataValues();
        presDataValues.setSingleASN1Type(new BerAny(userDataBytes));
        PDVList pdvList = new PDVList();
        pdvList.setPresentationContextIdentifier(acsePresentationContextId);
        pdvList.setPresentationDataValues(presDataValues);
        FullyEncodedData fullyEncodedData = new FullyEncodedData();
        List<PDVList> pdvListList = fullyEncodedData.getPDVList();
        pdvListList.add(pdvList);
        UserData userData = new UserData();
        userData.setFullyEncodedData(fullyEncodedData);
        return userData;
    }

    public static String getSPDUTypeString(byte spduType) {
        switch (spduType) {
            case 0: {
                return "EXCEPTION REPORT (ER)";
            }
            case 1: {
                return "DATA TRANSFER (DT)";
            }
            case 2: {
                return "PLEASE TOKENS (PT)";
            }
            case 5: {
                return "EXPEDITED (EX)";
            }
            case 7: {
                return "PREPARE (PR)";
            }
            case 8: {
                return "NOT FINISHED (NF)";
            }
            case 9: {
                return "FINISH (FN)";
            }
            case 10: {
                return "DISCONNECT (DN)";
            }
            case 12: {
                return "REFUSE (RF)";
            }
            case 13: {
                return "CONNECT (CN)";
            }
            case 14: {
                return "ACCEPT (AC)";
            }
            case 15: {
                return "CONNECT DATA OVERFLOW (CDO)";
            }
            case 16: {
                return "OVERFLOW ACCEPT (OA)";
            }
            case 21: {
                return "GIVE TOKENS CONFIRM (GTC)";
            }
            case 22: {
                return "GIVE TOKENS ACK (GTA)";
            }
            case 25: {
                return "ABORT (AB)";
            }
            case 26: {
                return "ABORT ACCEPT (AA)";
            }
            case 29: {
                return "ACTIVITY RESUME (AR)";
            }
            case 33: {
                return "TYPED DATA (TD)";
            }
            case 34: {
                return "RESYNCHRONIZE ACK (RA)";
            }
            case 41: {
                return "MAJOR SYNC POINT (MAP)";
            }
            case 42: {
                return "MAJOR SYNC ACK (MAA)";
            }
            case 45: {
                return "ACTIVITY START (AS)";
            }
            case 48: {
                return "EXCEPTION DATA (ED)";
            }
            case 49: {
                return "MINOR SYNC POINT (MIP)";
            }
            case 50: {
                return "MINOR SYNC ACK (MIA)";
            }
            case 53: {
                return "RESYNCHRONIZE (RS)";
            }
            case 57: {
                return "ACTIVITY DISCARD (AD)";
            }
            case 58: {
                return "ACTIVITY DISCARD ACK (ADA)";
            }
            case 61: {
                return "CAPABILITY DATA (CD)";
            }
            case 62: {
                return "CAPABILITY DATA ACK (CDA)";
            }
            case 64: {
                return "UNIT DATA (UD)";
            }
        }
        return "<unknown SPDU type>";
    }

    public void accept(ByteBuffer payload) throws IOException {
        BerAny anyPayload = new BerAny(Arrays.copyOfRange(payload.array(), payload.position(), payload.limit()));
        Myexternal.Encoding encoding = new Myexternal.Encoding();
        encoding.setSingleASN1Type(anyPayload);
        Myexternal myExternal = new Myexternal();
        myExternal.setDirectReference(directReference);
        myExternal.setIndirectReference(indirectReference);
        myExternal.setEncoding(encoding);
        AssociationInformation userInformation = new AssociationInformation();
        List<Myexternal> externalList = userInformation.getMyexternal();
        externalList.add(myExternal);
        AAREApdu aare = new AAREApdu();
        aare.setApplicationContextName(application_context_name);
        aare.setResult(aareAccepted);
        aare.setResultSourceDiagnostic(associateSourceDiagnostic);
        aare.setUserInformation(userInformation);
        ACSEApdu acse = new ACSEApdu();
        acse.setAare(aare);
        ReverseByteArrayOutputStream reverseOStream = new ReverseByteArrayOutputStream(100, true);
        acse.encode((OutputStream)reverseOStream);
        UserData userData = AcseAssociation.getPresentationUserDataField(reverseOStream.getArray());
        CPAPPDU.NormalModeParameters normalModeParameters = new CPAPPDU.NormalModeParameters();
        normalModeParameters.setRespondingPresentationSelector(this.pSelLocalBerOctetString);
        normalModeParameters.setPresentationContextDefinitionResultList(presentationResultList);
        normalModeParameters.setUserData(userData);
        CPAPPDU cpaPPdu = new CPAPPDU();
        cpaPPdu.setModeSelector(normalModeSelector);
        cpaPPdu.setNormalModeParameters(normalModeParameters);
        reverseOStream.reset();
        cpaPPdu.encode((OutputStream)reverseOStream, true);
        LinkedList<byte[]> ssduList = new LinkedList<byte[]>();
        LinkedList<Integer> ssduOffsets = new LinkedList<Integer>();
        LinkedList<Integer> ssduLengths = new LinkedList<Integer>();
        ssduList.add(reverseOStream.buffer);
        ssduOffsets.add(reverseOStream.index + 1);
        ssduLengths.add(reverseOStream.buffer.length - (reverseOStream.index + 1));
        this.writeSessionAccept(ssduList, ssduOffsets, ssduLengths);
        this.connected = true;
    }

    private void writeSessionAccept(List<byte[]> ssdu, List<Integer> ssduOffsets, List<Integer> ssduLengths) throws IOException {
        byte[] sduAcceptHeader = new byte[20];
        int idx = 0;
        int ssduLength = 0;
        for (int ssduElementLength : ssduLengths) {
            ssduLength += ssduElementLength;
        }
        sduAcceptHeader[idx++] = 14;
        sduAcceptHeader[idx++] = (byte)(ssduLength + 18 & 0xFF);
        sduAcceptHeader[idx++] = 5;
        sduAcceptHeader[idx++] = 6;
        sduAcceptHeader[idx++] = 19;
        sduAcceptHeader[idx++] = 1;
        sduAcceptHeader[idx++] = 0;
        sduAcceptHeader[idx++] = 22;
        sduAcceptHeader[idx++] = 1;
        sduAcceptHeader[idx++] = 2;
        sduAcceptHeader[idx++] = 20;
        sduAcceptHeader[idx++] = 2;
        sduAcceptHeader[idx++] = 0;
        sduAcceptHeader[idx++] = 2;
        sduAcceptHeader[idx++] = 52;
        sduAcceptHeader[idx++] = 2;
        sduAcceptHeader[idx++] = 0;
        sduAcceptHeader[idx++] = 1;
        sduAcceptHeader[idx++] = -63;
        sduAcceptHeader[idx++] = (byte)ssduLength;
        ssdu.add(0, sduAcceptHeader);
        ssduOffsets.add(0, 0);
        ssduLengths.add(0, sduAcceptHeader.length);
        this.tConnection.send(ssdu, ssduOffsets, ssduLengths);
    }

    public ByteBuffer getAssociateResponseAPdu() {
        ByteBuffer returnBuffer = this.associateResponseAPDU;
        this.associateResponseAPDU = null;
        return returnBuffer;
    }

    void startAssociation(ByteBuffer payload, InetAddress address, int port, InetAddress localAddr, int localPort, String authenticationParameter, byte[] sSelRemote, byte[] sSelLocal, byte[] pSelRemote, ClientTSap tSAP, int[] apTitleCalled, int[] apTitleCalling, int aeQualifierCalled, int aeQualifierCalling) throws IOException {
        if (this.connected) {
            throw new IOException();
        }
        APTitle called_ap_title = new APTitle();
        called_ap_title.setApTitleForm2(new APTitleForm2(apTitleCalled));
        APTitle calling_ap_title = new APTitle();
        calling_ap_title.setApTitleForm2(new APTitleForm2(apTitleCalling));
        AEQualifier called_ae_qualifier = new AEQualifier();
        called_ae_qualifier.setAeQualifierForm2(new AEQualifierForm2(aeQualifierCalled));
        AEQualifier calling_ae_qualifier = new AEQualifier();
        calling_ae_qualifier.setAeQualifierForm2(new AEQualifierForm2(aeQualifierCalling));
        Myexternal.Encoding encoding = new Myexternal.Encoding();
        encoding.setSingleASN1Type(new BerAny(Arrays.copyOfRange(payload.array(), payload.position(), payload.limit())));
        Myexternal myExternal = new Myexternal();
        myExternal.setDirectReference(directReference);
        myExternal.setIndirectReference(indirectReference);
        myExternal.setEncoding(encoding);
        AssociationInformation userInformation = new AssociationInformation();
        List<Myexternal> externalList = userInformation.getMyexternal();
        externalList.add(myExternal);
        ACSERequirements sender_acse_requirements = null;
        MechanismName mechanism_name = null;
        AuthenticationValue authentication_value = null;
        if (authenticationParameter != null) {
            sender_acse_requirements = new ACSERequirements(new byte[]{2, 7, -128});
            mechanism_name = default_mechanism_name;
            authentication_value = new AuthenticationValue();
            authentication_value.setCharstring(new BerGraphicString(authenticationParameter.getBytes()));
        }
        AARQApdu aarq = new AARQApdu();
        aarq.setApplicationContextName(application_context_name);
        aarq.setCalledAPTitle(called_ap_title);
        aarq.setCalledAEQualifier(called_ae_qualifier);
        aarq.setCallingAPTitle(calling_ap_title);
        aarq.setCallingAEQualifier(calling_ae_qualifier);
        aarq.setSenderAcseRequirements(sender_acse_requirements);
        aarq.setMechanismName(mechanism_name);
        aarq.setCallingAuthenticationValue(authentication_value);
        aarq.setUserInformation(userInformation);
        ACSEApdu acse = new ACSEApdu();
        acse.setAarq(aarq);
        ReverseByteArrayOutputStream reverseOStream = new ReverseByteArrayOutputStream(200, true);
        acse.encode((OutputStream)reverseOStream);
        UserData userData = AcseAssociation.getPresentationUserDataField(reverseOStream.getArray());
        CPType.NormalModeParameters normalModeParameter = new CPType.NormalModeParameters();
        normalModeParameter.setCallingPresentationSelector(new CallingPresentationSelector(this.pSelLocalBerOctetString.value));
        normalModeParameter.setCalledPresentationSelector(new CalledPresentationSelector(pSelRemote));
        normalModeParameter.setPresentationContextDefinitionList(context_list);
        normalModeParameter.setUserData(userData);
        CPType cpType = new CPType();
        cpType.setModeSelector(normalModeSelector);
        cpType.setNormalModeParameters(normalModeParameter);
        reverseOStream.reset();
        cpType.encode((OutputStream)reverseOStream, true);
        LinkedList<byte[]> ssduList = new LinkedList<byte[]>();
        LinkedList<Integer> ssduOffsets = new LinkedList<Integer>();
        LinkedList<Integer> ssduLengths = new LinkedList<Integer>();
        ssduList.add(reverseOStream.buffer);
        ssduOffsets.add(reverseOStream.index + 1);
        ssduLengths.add(reverseOStream.buffer.length - (reverseOStream.index + 1));
        ByteBuffer res = null;
        res = this.startSConnection(ssduList, ssduOffsets, ssduLengths, address, port, localAddr, localPort, tSAP, sSelRemote, sSelLocal);
        this.associateResponseAPDU = AcseAssociation.decodePConResponse(res);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ByteBuffer startSConnection(List<byte[]> ssduList, List<Integer> ssduOffsets, List<Integer> ssduLengths, InetAddress address, int port, InetAddress localAddr, int localPort, ClientTSap tSAP, byte[] sSelRemote, byte[] sSelLocal) throws IOException {
        if (this.connected) {
            throw new IOException();
        }
        byte[] spduHeader = new byte[24];
        int idx = 0;
        int ssduLength = 0;
        for (int ssduElementLength : ssduLengths) {
            ssduLength += ssduElementLength;
        }
        spduHeader[idx++] = 13;
        spduHeader[idx++] = (byte)(ssduLength + 22 & 0xFF);
        spduHeader[idx++] = 5;
        spduHeader[idx++] = 6;
        spduHeader[idx++] = 19;
        spduHeader[idx++] = 1;
        spduHeader[idx++] = 0;
        spduHeader[idx++] = 22;
        spduHeader[idx++] = 1;
        spduHeader[idx++] = 2;
        spduHeader[idx++] = 20;
        spduHeader[idx++] = 2;
        spduHeader[idx++] = 0;
        spduHeader[idx++] = 2;
        spduHeader[idx++] = 51;
        spduHeader[idx++] = 2;
        spduHeader[idx++] = sSelRemote[0];
        spduHeader[idx++] = sSelRemote[1];
        spduHeader[idx++] = 52;
        spduHeader[idx++] = 2;
        spduHeader[idx++] = sSelLocal[0];
        spduHeader[idx++] = sSelLocal[1];
        spduHeader[idx++] = -63;
        spduHeader[idx++] = (byte)(ssduLength & 0xFF);
        ssduList.add(0, spduHeader);
        ssduOffsets.add(0, 0);
        ssduLengths.add(0, spduHeader.length);
        this.tConnection = tSAP.connectTo(address, port, localAddr, localPort);
        this.tConnection.send(ssduList, ssduOffsets, ssduLengths);
        ByteBuffer pduBuffer = ByteBuffer.allocate(500);
        try {
            this.tConnection.receive(pduBuffer);
        }
        catch (TimeoutException e) {
            throw new IOException("ResponseTimeout waiting for connection response.", e);
        }
        idx = 0;
        byte spduType = pduBuffer.get();
        if (spduType != 14) {
            throw new IOException("ISO 8327-1 header wrong SPDU type, expected ACCEPT (14), got " + AcseAssociation.getSPDUTypeString(spduType) + " (" + spduType + ")");
        }
        pduBuffer.get();
        block14: while (true) {
            int parameterType = pduBuffer.get() & 0xFF;
            int parameterLength = pduBuffer.get() & 0xFF;
            switch (parameterType) {
                case 5: {
                    byte ca_parameterType;
                    int bytesToRead = parameterLength;
                    block15: while (true) {
                        if (bytesToRead <= 0) continue block14;
                        ca_parameterType = pduBuffer.get();
                        pduBuffer.get();
                        bytesToRead -= 2;
                        switch (ca_parameterType & 0xFF) {
                            case 19: {
                                byte protocolOptions = pduBuffer.get();
                                if (protocolOptions != 0) {
                                    throw new IOException("SPDU Connect Accept Item/Protocol Options is " + protocolOptions + ", expected 0");
                                }
                                --bytesToRead;
                                continue block15;
                            }
                            case 22: {
                                byte versionNumber = pduBuffer.get();
                                if (versionNumber != 2) {
                                    throw new IOException("SPDU Connect Accept Item/Version Number is " + versionNumber + ", expected 2");
                                }
                                --bytesToRead;
                                continue block15;
                            }
                        }
                        break;
                    }
                    throw new IOException("SPDU Connect Accept Item: parameter not implemented: " + ca_parameterType);
                }
                case 20: {
                    long sessionRequirement = this.extractInteger(pduBuffer, parameterLength);
                    if (sessionRequirement == 2L) continue block14;
                    throw new IOException("SPDU header parameter 'Session Requirement (20)' is " + sessionRequirement + ", expected 2");
                }
                case 51: {
                    long css = this.extractInteger(pduBuffer, parameterLength);
                    if (css == 1L) continue block14;
                    throw new IOException("SPDU header parameter 'Calling Session Selector (51)' is " + css + ", expected 1");
                }
                case 52: {
                    long calledSessionSelector = this.extractInteger(pduBuffer, parameterLength);
                    if (calledSessionSelector != 1L) throw new IOException("SPDU header parameter 'Called Session Selector (52)' is " + calledSessionSelector + ", expected 1");
                    continue block14;
                }
                case 193: {
                    break block14;
                }
                default: {
                    throw new IOException("SPDU header parameter type " + parameterType + " not implemented");
                }
            }
            break;
        }
        this.connected = true;
        return pduBuffer;
    }

    public void send(ByteBuffer payload) throws IOException {
        ArrayList<byte[]> ssduList = new ArrayList<byte[]>();
        LinkedList<Integer> ssduOffsets = new LinkedList<Integer>();
        LinkedList<Integer> ssduLengths = new LinkedList<Integer>();
        this.encodePresentationLayer(payload, ssduList, ssduOffsets, ssduLengths);
        this.encodeSessionLayer(ssduList, ssduOffsets, ssduLengths);
        this.tConnection.send(ssduList, ssduOffsets, ssduLengths);
    }

    private void encodePresentationLayer(ByteBuffer payload, List<byte[]> ssduList, List<Integer> ssduOffsets, List<Integer> ssduLengths) throws IOException {
        PDVList pdv_list = new PDVList();
        pdv_list.setPresentationContextIdentifier(new PresentationContextIdentifier(3L));
        PDVList.PresentationDataValues presentationDataValues = new PDVList.PresentationDataValues();
        presentationDataValues.setSingleASN1Type(new BerAny(Arrays.copyOfRange(payload.array(), payload.position(), payload.limit())));
        pdv_list.setPresentationDataValues(presentationDataValues);
        FullyEncodedData fully_encoded_data = new FullyEncodedData();
        List<PDVList> pdv_list_list = fully_encoded_data.getPDVList();
        pdv_list_list.add(pdv_list);
        UserData user_data = new UserData();
        user_data.setFullyEncodedData(fully_encoded_data);
        ReverseByteArrayOutputStream reverseOStream = new ReverseByteArrayOutputStream(200, true);
        user_data.encode((OutputStream)reverseOStream);
        ssduList.add(reverseOStream.buffer);
        ssduOffsets.add(reverseOStream.index + 1);
        ssduLengths.add(reverseOStream.buffer.length - (reverseOStream.index + 1));
    }

    private void encodeSessionLayer(List<byte[]> ssduList, List<Integer> ssduOffsets, List<Integer> ssduLengths) throws IOException {
        byte[] spduHeader = new byte[]{1, 0, 1, 0};
        ssduList.add(0, spduHeader);
        ssduOffsets.add(0, 0);
        ssduLengths.add(0, spduHeader.length);
    }

    public byte[] receive(ByteBuffer pduBuffer) throws DecodingException, IOException, TimeoutException {
        if (!this.connected) {
            throw new IllegalStateException("ACSE Association not connected");
        }
        this.tConnection.receive(pduBuffer);
        this.decodeSessionLayer(pduBuffer);
        return this.decodePresentationLayer(pduBuffer);
    }

    private byte[] decodePresentationLayer(ByteBuffer pduBuffer) throws DecodingException {
        UserData user_data = new UserData();
        try {
            user_data.decode(new ByteBufferInputStream(pduBuffer), null);
        }
        catch (IOException e) {
            throw new DecodingException("error decoding PPDU header", e);
        }
        return user_data.getFullyEncodedData().getPDVList().get((int)0).getPresentationDataValues().getSingleASN1Type().value;
    }

    private void decodeSessionLayer(ByteBuffer pduBuffer) throws EOFException, DecodingException {
        byte firstByte = pduBuffer.get();
        if (firstByte == 25) {
            throw new EOFException("Received an ABORT SPDU");
        }
        if (firstByte != 1) {
            throw new DecodingException("SPDU header syntax errror: first SPDU type not 1");
        }
        if (pduBuffer.get() != 0) {
            throw new DecodingException("SPDU header syntax errror: first SPDU type length not 0");
        }
        if (pduBuffer.get() != 1) {
            throw new DecodingException("SPDU header syntax errror: second SPDU type not 1");
        }
        if (pduBuffer.get() != 0) {
            throw new DecodingException("SPDU header syntax errror: second SPDU type length not 0");
        }
    }

    public void disconnect() {
        this.connected = false;
        if (this.tConnection != null) {
            this.tConnection.disconnect();
        }
    }

    public void close() {
        this.connected = false;
        if (this.tConnection != null) {
            this.tConnection.close();
        }
    }

    private long extractInteger(ByteBuffer buffer, int size) throws IOException {
        switch (size) {
            case 1: {
                return buffer.get();
            }
            case 2: {
                return buffer.getShort();
            }
            case 4: {
                return buffer.getInt();
            }
            case 8: {
                return buffer.getLong();
            }
        }
        throw new IOException("invalid length for reading numeric value");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ByteBuffer listenForCn(ByteBuffer pduBuffer) throws IOException, TimeoutException {
        if (this.connected) {
            throw new IllegalStateException("ACSE Association is already connected");
        }
        this.tConnection.receive(pduBuffer);
        byte spduType = pduBuffer.get();
        if (spduType != 13) {
            throw new IOException("ISO 8327-1 header wrong SPDU type, expected CONNECT (13), got " + AcseAssociation.getSPDUTypeString(spduType) + " (" + spduType + ")");
        }
        pduBuffer.get();
        block11: while (true) {
            int parameter = pduBuffer.get() & 0xFF;
            int parameterLength = pduBuffer.get() & 0xFF;
            switch (parameter) {
                case 5: {
                    byte by;
                    int bytesToRead = parameterLength;
                    block12: while (true) {
                        if (bytesToRead <= 0) continue block11;
                        by = pduBuffer.get();
                        pduBuffer.get();
                        bytesToRead -= 2;
                        switch (by & 0xFF) {
                            case 19: {
                                byte protocolOptions = pduBuffer.get();
                                if (protocolOptions != 0) {
                                    throw new IOException("SPDU Connect Accept Item/Protocol Options is " + protocolOptions + ", expected 0");
                                }
                                --bytesToRead;
                                continue block12;
                            }
                            case 22: {
                                byte versionNumber = pduBuffer.get();
                                if (versionNumber != 2) {
                                    throw new IOException("SPDU Connect Accept Item/Version Number is " + versionNumber + ", expected 2");
                                }
                                --bytesToRead;
                                continue block12;
                            }
                        }
                        break;
                    }
                    throw new IOException("SPDU Connect Accept Item: parameter not implemented: " + by);
                }
                case 20: {
                    long l = this.extractInteger(pduBuffer, parameterLength);
                    if (l == 2L) continue block11;
                    throw new IOException("SPDU header parameter 'Session Requirement (20)' is " + l + ", expected 2");
                }
                case 51: {
                    this.extractInteger(pduBuffer, parameterLength);
                    continue block11;
                }
                case 52: {
                    long calledSessionSelector = this.extractInteger(pduBuffer, parameterLength);
                    if (calledSessionSelector != 1L) throw new IOException("SPDU header parameter 'Called Session Selector (52)' is " + calledSessionSelector + ", expected 1");
                    continue block11;
                }
                case 193: {
                    break block11;
                }
                default: {
                    throw new IOException("SPDU header parameter type " + parameter + " not implemented");
                }
            }
            break;
        }
        CPType cpType = new CPType();
        ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(pduBuffer);
        cpType.decode(byteBufferInputStream, true);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cpType.getNormalModeParameters().getUserData().getFullyEncodedData().getPDVList().get((int)0).getPresentationDataValues().getSingleASN1Type().value);
        ACSEApdu acseApdu = new ACSEApdu();
        acseApdu.decode(byteArrayInputStream, null);
        return ByteBuffer.wrap(acseApdu.getAarq().getUserInformation().getMyexternal().get((int)0).getEncoding().getSingleASN1Type().value);
    }

    public int getMessageTimeout() {
        return this.tConnection.getMessageTimeout();
    }

    public void setMessageTimeout(int i) {
        this.tConnection.setMessageTimeout(i);
    }

    static {
        normalModeSelector.setModeValue(new BerInteger(BigInteger.ONE));
    }
}

