/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.josistack.internal.acse.asn1.AAREApdu;
import com.beanit.josistack.internal.acse.asn1.AARQApdu;
import com.beanit.josistack.internal.acse.asn1.RLREApdu;
import com.beanit.josistack.internal.acse.asn1.RLRQApdu;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ACSEApdu
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private AARQApdu aarq = null;
    private AAREApdu aare = null;
    private RLRQApdu rlrq = null;
    private RLREApdu rlre = null;

    public ACSEApdu() {
    }

    public ACSEApdu(byte[] code) {
        this.code = code;
    }

    public AARQApdu getAarq() {
        return this.aarq;
    }

    public void setAarq(AARQApdu aarq) {
        this.aarq = aarq;
    }

    public AAREApdu getAare() {
        return this.aare;
    }

    public void setAare(AAREApdu aare) {
        this.aare = aare;
    }

    public RLRQApdu getRlrq() {
        return this.rlrq;
    }

    public void setRlrq(RLRQApdu rlrq) {
        this.rlrq = rlrq;
    }

    public RLREApdu getRlre() {
        return this.rlre;
    }

    public void setRlre(RLREApdu rlre) {
        this.rlre = rlre;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.rlre != null) {
            return codeLength += this.rlre.encode(reverseOS, true);
        }
        if (this.rlrq != null) {
            return codeLength += this.rlrq.encode(reverseOS, true);
        }
        if (this.aare != null) {
            return codeLength += this.aare.encode(reverseOS, true);
        }
        if (this.aarq != null) {
            return codeLength += this.aarq.encode(reverseOS, true);
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        int codeLength = 0;
        BerTag passedTag = berTag;
        if (berTag == null) {
            berTag = new BerTag();
            codeLength += berTag.decode(is);
        }
        if (berTag.equals((Object)AARQApdu.tag)) {
            this.aarq = new AARQApdu();
            return codeLength += this.aarq.decode(is, false);
        }
        if (berTag.equals((Object)AAREApdu.tag)) {
            this.aare = new AAREApdu();
            return codeLength += this.aare.decode(is, false);
        }
        if (berTag.equals((Object)RLRQApdu.tag)) {
            this.rlrq = new RLRQApdu();
            return codeLength += this.rlrq.decode(is, false);
        }
        if (berTag.equals((Object)RLREApdu.tag)) {
            this.rlre = new RLREApdu();
            return codeLength += this.rlre.decode(is, false);
        }
        if (passedTag != null) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.aarq != null) {
            sb.append("aarq: ");
            this.aarq.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.aare != null) {
            sb.append("aare: ");
            this.aare.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.rlrq != null) {
            sb.append("rlrq: ");
            this.rlrq.appendAsString(sb, indentLevel + 1);
            return;
        }
        if (this.rlre != null) {
            sb.append("rlre: ");
            this.rlre.appendAsString(sb, indentLevel + 1);
            return;
        }
        sb.append("<none>");
    }
}

