/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.josistack.internal.acse.asn1.ApplicationContextName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ApplicationContextNameList
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private List<ApplicationContextName> seqOf = null;

    public ApplicationContextNameList() {
        this.seqOf = new ArrayList<ApplicationContextName>();
    }

    public ApplicationContextNameList(byte[] code) {
        this.code = code;
    }

    public List<ApplicationContextName> getApplicationContextName() {
        if (this.seqOf == null) {
            this.seqOf = new ArrayList<ApplicationContextName>();
        }
        return this.seqOf;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        for (int i = this.seqOf.size() - 1; i >= 0; --i) {
            codeLength += this.seqOf.get(i).encode(reverseOS, true);
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        while (subCodeLength < totalLength) {
            ApplicationContextName element = new ApplicationContextName();
            subCodeLength += element.decode(is, true);
            this.seqOf.add(element);
        }
        if (subCodeLength != totalLength) {
            throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + totalLength + " but has " + subCodeLength);
        }
        return codeLength += subCodeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.seqOf == null) {
            sb.append("null");
        } else {
            Iterator<ApplicationContextName> it = this.seqOf.iterator();
            if (it.hasNext()) {
                sb.append((Object)it.next());
                while (it.hasNext()) {
                    sb.append(",\n");
                    for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                        sb.append("\t");
                    }
                    sb.append((Object)it.next());
                }
            }
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

