/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class AssociateSourceDiagnostic
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private BerInteger acseServiceUser = null;
    private BerInteger acseServiceProvider = null;

    public AssociateSourceDiagnostic() {
    }

    public AssociateSourceDiagnostic(byte[] code) {
        this.code = code;
    }

    public BerInteger getAcseServiceUser() {
        return this.acseServiceUser;
    }

    public void setAcseServiceUser(BerInteger acseServiceUser) {
        this.acseServiceUser = acseServiceUser;
    }

    public BerInteger getAcseServiceProvider() {
        return this.acseServiceProvider;
    }

    public void setAcseServiceProvider(BerInteger acseServiceProvider) {
        this.acseServiceProvider = acseServiceProvider;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.acseServiceProvider != null) {
            int sublength = this.acseServiceProvider.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(162);
            return ++codeLength;
        }
        if (this.acseServiceUser != null) {
            int sublength = this.acseServiceUser.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(161);
            return ++codeLength;
        }
        throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, null);
    }

    public int decode(InputStream is, BerTag berTag) throws IOException {
        int codeLength = 0;
        BerTag passedTag = berTag;
        if (berTag == null) {
            berTag = new BerTag();
            codeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 1)) {
            codeLength += BerLength.skip((InputStream)is);
            this.acseServiceUser = new BerInteger();
            return codeLength += this.acseServiceUser.decode(is, true);
        }
        if (berTag.equals(128, 32, 2)) {
            codeLength += BerLength.skip((InputStream)is);
            this.acseServiceProvider = new BerInteger();
            return codeLength += this.acseServiceProvider.decode(is, true);
        }
        if (passedTag != null) {
            return 0;
        }
        throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        if (this.acseServiceUser != null) {
            sb.append("acseServiceUser: ").append(this.acseServiceUser);
            return;
        }
        if (this.acseServiceProvider != null) {
            sb.append("acseServiceProvider: ").append(this.acseServiceProvider);
            return;
        }
        sb.append("<none>");
    }
}

