/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerAny;
import com.beanit.jasn1.ber.types.BerBitString;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerObjectIdentifier;
import com.beanit.jasn1.ber.types.BerOctetString;
import com.beanit.jasn1.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class Myexternal2
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 8);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private BerObjectIdentifier directReference = null;
    private BerInteger indirectReference = null;
    private Encoding encoding = null;

    public Myexternal2() {
    }

    public Myexternal2(byte[] code) {
        this.code = code;
    }

    public BerObjectIdentifier getDirectReference() {
        return this.directReference;
    }

    public void setDirectReference(BerObjectIdentifier directReference) {
        this.directReference = directReference;
    }

    public BerInteger getIndirectReference() {
        return this.indirectReference;
    }

    public void setIndirectReference(BerInteger indirectReference) {
        this.indirectReference = indirectReference;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        codeLength += this.encoding.encode(reverseOS);
        if (this.indirectReference != null) {
            codeLength += this.indirectReference.encode(reverseOS, true);
        }
        if (this.directReference != null) {
            codeLength += this.directReference.encode(reverseOS, true);
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        subCodeLength += berTag.decode(is);
        if (berTag.equals((Object)BerObjectIdentifier.tag)) {
            this.directReference = new BerObjectIdentifier();
            subCodeLength += this.directReference.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals((Object)BerInteger.tag)) {
            this.indirectReference = new BerInteger();
            subCodeLength += this.indirectReference.decode(is, false);
            subCodeLength += berTag.decode(is);
        }
        this.encoding = new Encoding();
        if ((subCodeLength += this.encoding.decode(is, berTag)) == totalLength) {
            return codeLength;
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.directReference != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("directReference: ").append(this.directReference);
            firstSelectedElement = false;
        }
        if (this.indirectReference != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("indirectReference: ").append(this.indirectReference);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.encoding != null) {
            sb.append("encoding: ");
            this.encoding.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("encoding: <empty-required-field>");
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class Encoding
    implements BerType,
    Serializable {
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private BerAny singleASN1Type = null;
        private BerOctetString octetAligned = null;
        private BerBitString arbitrary = null;

        public Encoding() {
        }

        public Encoding(byte[] code) {
            this.code = code;
        }

        public BerAny getSingleASN1Type() {
            return this.singleASN1Type;
        }

        public void setSingleASN1Type(BerAny singleASN1Type) {
            this.singleASN1Type = singleASN1Type;
        }

        public BerOctetString getOctetAligned() {
            return this.octetAligned;
        }

        public void setOctetAligned(BerOctetString octetAligned) {
            this.octetAligned = octetAligned;
        }

        public BerBitString getArbitrary() {
            return this.arbitrary;
        }

        public void setArbitrary(BerBitString arbitrary) {
            this.arbitrary = arbitrary;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.arbitrary != null) {
                codeLength += this.arbitrary.encode(reverseOS, false);
                reverseOS.write(130);
                return ++codeLength;
            }
            if (this.octetAligned != null) {
                codeLength += this.octetAligned.encode(reverseOS, false);
                reverseOS.write(129);
                return ++codeLength;
            }
            if (this.singleASN1Type != null) {
                int sublength = this.singleASN1Type.encode(reverseOS);
                codeLength += sublength;
                codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
                reverseOS.write(160);
                return ++codeLength;
            }
            throw new IOException("Error encoding CHOICE: No element of CHOICE was selected.");
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, null);
        }

        public int decode(InputStream is, BerTag berTag) throws IOException {
            int codeLength = 0;
            BerTag passedTag = berTag;
            if (berTag == null) {
                berTag = new BerTag();
                codeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 0)) {
                codeLength += BerLength.skip((InputStream)is);
                this.singleASN1Type = new BerAny();
                return codeLength += this.singleASN1Type.decode(is, null);
            }
            if (berTag.equals(128, 0, 1)) {
                this.octetAligned = new BerOctetString();
                return codeLength += this.octetAligned.decode(is, false);
            }
            if (berTag.equals(128, 0, 2)) {
                this.arbitrary = new BerBitString();
                return codeLength += this.arbitrary.decode(is, false);
            }
            if (passedTag != null) {
                return 0;
            }
            throw new IOException("Error decoding CHOICE: Tag " + berTag + " matched to no item.");
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            if (this.singleASN1Type != null) {
                sb.append("singleASN1Type: ").append(this.singleASN1Type);
                return;
            }
            if (this.octetAligned != null) {
                sb.append("octetAligned: ").append(this.octetAligned);
                return;
            }
            if (this.arbitrary != null) {
                sb.append("arbitrary: ").append(this.arbitrary);
                return;
            }
            sb.append("<none>");
        }
    }
}

