/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.acse.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.josistack.internal.acse.asn1.AssociationInformation;
import com.beanit.josistack.internal.acse.asn1.ReleaseRequestReason;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class RLRQApdu
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(64, 32, 2);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private ReleaseRequestReason reason = null;
    private AssociationInformation userInformation = null;

    public RLRQApdu() {
    }

    public RLRQApdu(byte[] code) {
        this.code = code;
    }

    public ReleaseRequestReason getReason() {
        return this.reason;
    }

    public void setReason(ReleaseRequestReason reason) {
        this.reason = reason;
    }

    public AssociationInformation getUserInformation() {
        return this.userInformation;
    }

    public void setUserInformation(AssociationInformation userInformation) {
        this.userInformation = userInformation;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.userInformation != null) {
            codeLength += this.userInformation.encode(reverseOS, false);
            reverseOS.write(190);
            ++codeLength;
        }
        if (this.reason != null) {
            codeLength += this.reason.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        codeLength += totalLength;
        if (totalLength == 0) {
            return codeLength;
        }
        subCodeLength += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.reason = new ReleaseRequestReason();
            if ((subCodeLength += this.reason.decode(is, false)) == totalLength) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 30)) {
            this.userInformation = new AssociationInformation();
            if ((subCodeLength += this.userInformation.decode(is, false)) == totalLength) {
                return codeLength;
            }
        }
        throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.reason != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("reason: ").append((Object)this.reason);
            firstSelectedElement = false;
        }
        if (this.userInformation != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("userInformation: ");
            this.userInformation.appendAsString(sb, indentLevel + 1);
            firstSelectedElement = false;
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

