/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.josistack.internal.presentation.asn1.ModeSelector;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextDefinitionResultList;
import com.beanit.josistack.internal.presentation.asn1.PresentationRequirements;
import com.beanit.josistack.internal.presentation.asn1.ProtocolVersion;
import com.beanit.josistack.internal.presentation.asn1.RespondingPresentationSelector;
import com.beanit.josistack.internal.presentation.asn1.UserData;
import com.beanit.josistack.internal.presentation.asn1.UserSessionRequirements;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class CPAPPDU
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 17);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private ModeSelector modeSelector = null;
    private NormalModeParameters normalModeParameters = null;

    public CPAPPDU() {
    }

    public CPAPPDU(byte[] code) {
        this.code = code;
    }

    public ModeSelector getModeSelector() {
        return this.modeSelector;
    }

    public void setModeSelector(ModeSelector modeSelector) {
        this.modeSelector = modeSelector;
    }

    public NormalModeParameters getNormalModeParameters() {
        return this.normalModeParameters;
    }

    public void setNormalModeParameters(NormalModeParameters normalModeParameters) {
        this.normalModeParameters = normalModeParameters;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.normalModeParameters != null) {
            codeLength += this.normalModeParameters.encode(reverseOS, false);
            reverseOS.write(162);
            ++codeLength;
        }
        codeLength += this.modeSelector.encode(reverseOS, false);
        reverseOS.write(160);
        ++codeLength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        while (subCodeLength < totalLength) {
            subCodeLength += berTag.decode(is);
            if (berTag.equals(128, 32, 0)) {
                this.modeSelector = new ModeSelector();
                subCodeLength += this.modeSelector.decode(is, false);
                continue;
            }
            if (!berTag.equals(128, 32, 2)) continue;
            this.normalModeParameters = new NormalModeParameters();
            subCodeLength += this.normalModeParameters.decode(is, false);
        }
        if (subCodeLength != totalLength) {
            throw new IOException("Length of set does not match length tag, length tag: " + totalLength + ", actual set length: " + subCodeLength);
        }
        return codeLength += subCodeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        sb.append("\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.modeSelector != null) {
            sb.append("modeSelector: ");
            this.modeSelector.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("modeSelector: <empty-required-field>");
        }
        if (this.normalModeParameters != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("normalModeParameters: ");
            this.normalModeParameters.appendAsString(sb, indentLevel + 1);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class NormalModeParameters
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private ProtocolVersion protocolVersion = null;
        private RespondingPresentationSelector respondingPresentationSelector = null;
        private PresentationContextDefinitionResultList presentationContextDefinitionResultList = null;
        private PresentationRequirements presentationRequirements = null;
        private UserSessionRequirements userSessionRequirements = null;
        private UserData userData = null;

        public NormalModeParameters() {
        }

        public NormalModeParameters(byte[] code) {
            this.code = code;
        }

        public ProtocolVersion getProtocolVersion() {
            return this.protocolVersion;
        }

        public void setProtocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
        }

        public RespondingPresentationSelector getRespondingPresentationSelector() {
            return this.respondingPresentationSelector;
        }

        public void setRespondingPresentationSelector(RespondingPresentationSelector respondingPresentationSelector) {
            this.respondingPresentationSelector = respondingPresentationSelector;
        }

        public PresentationContextDefinitionResultList getPresentationContextDefinitionResultList() {
            return this.presentationContextDefinitionResultList;
        }

        public void setPresentationContextDefinitionResultList(PresentationContextDefinitionResultList presentationContextDefinitionResultList) {
            this.presentationContextDefinitionResultList = presentationContextDefinitionResultList;
        }

        public PresentationRequirements getPresentationRequirements() {
            return this.presentationRequirements;
        }

        public void setPresentationRequirements(PresentationRequirements presentationRequirements) {
            this.presentationRequirements = presentationRequirements;
        }

        public UserSessionRequirements getUserSessionRequirements() {
            return this.userSessionRequirements;
        }

        public void setUserSessionRequirements(UserSessionRequirements userSessionRequirements) {
            this.userSessionRequirements = userSessionRequirements;
        }

        public UserData getUserData() {
            return this.userData;
        }

        public void setUserData(UserData userData) {
            this.userData = userData;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            if (this.userData != null) {
                codeLength += this.userData.encode(reverseOS);
            }
            if (this.userSessionRequirements != null) {
                codeLength += this.userSessionRequirements.encode(reverseOS, false);
                reverseOS.write(137);
                ++codeLength;
            }
            if (this.presentationRequirements != null) {
                codeLength += this.presentationRequirements.encode(reverseOS, false);
                reverseOS.write(136);
                ++codeLength;
            }
            if (this.presentationContextDefinitionResultList != null) {
                codeLength += this.presentationContextDefinitionResultList.encode(reverseOS, false);
                reverseOS.write(165);
                ++codeLength;
            }
            if (this.respondingPresentationSelector != null) {
                codeLength += this.respondingPresentationSelector.encode(reverseOS, false);
                reverseOS.write(131);
                ++codeLength;
            }
            if (this.protocolVersion != null) {
                codeLength += this.protocolVersion.encode(reverseOS, false);
                reverseOS.write(128);
                ++codeLength;
            }
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int codeLength = 0;
            int subCodeLength = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                codeLength += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            codeLength += length.decode(is);
            int totalLength = length.val;
            codeLength += totalLength;
            if (totalLength == 0) {
                return codeLength;
            }
            subCodeLength += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.protocolVersion = new ProtocolVersion();
                if ((subCodeLength += this.protocolVersion.decode(is, false)) == totalLength) {
                    return codeLength;
                }
                subCodeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 3)) {
                this.respondingPresentationSelector = new RespondingPresentationSelector();
                if ((subCodeLength += this.respondingPresentationSelector.decode(is, false)) == totalLength) {
                    return codeLength;
                }
                subCodeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 32, 5)) {
                this.presentationContextDefinitionResultList = new PresentationContextDefinitionResultList();
                if ((subCodeLength += this.presentationContextDefinitionResultList.decode(is, false)) == totalLength) {
                    return codeLength;
                }
                subCodeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 8)) {
                this.presentationRequirements = new PresentationRequirements();
                if ((subCodeLength += this.presentationRequirements.decode(is, false)) == totalLength) {
                    return codeLength;
                }
                subCodeLength += berTag.decode(is);
            }
            if (berTag.equals(128, 0, 9)) {
                this.userSessionRequirements = new UserSessionRequirements();
                if ((subCodeLength += this.userSessionRequirements.decode(is, false)) == totalLength) {
                    return codeLength;
                }
                subCodeLength += berTag.decode(is);
            }
            this.userData = new UserData();
            int choiceDecodeLength = this.userData.decode(is, berTag);
            if ((subCodeLength += choiceDecodeLength) == totalLength) {
                return codeLength;
            }
            throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            boolean firstSelectedElement = true;
            if (this.protocolVersion != null) {
                sb.append("\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("protocolVersion: ").append((Object)this.protocolVersion);
                firstSelectedElement = false;
            }
            if (this.respondingPresentationSelector != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("respondingPresentationSelector: ").append((Object)this.respondingPresentationSelector);
                firstSelectedElement = false;
            }
            if (this.presentationContextDefinitionResultList != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("presentationContextDefinitionResultList: ");
                this.presentationContextDefinitionResultList.appendAsString(sb, indentLevel + 1);
                firstSelectedElement = false;
            }
            if (this.presentationRequirements != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("presentationRequirements: ").append((Object)this.presentationRequirements);
                firstSelectedElement = false;
            }
            if (this.userSessionRequirements != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("userSessionRequirements: ").append((Object)this.userSessionRequirements);
                firstSelectedElement = false;
            }
            if (this.userData != null) {
                if (!firstSelectedElement) {
                    sb.append(",\n");
                }
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                sb.append("userData: ");
                this.userData.appendAsString(sb, indentLevel + 1);
                firstSelectedElement = false;
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }
    }
}

