/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.josistack.internal.presentation.asn1;

import com.beanit.jasn1.ber.BerLength;
import com.beanit.jasn1.ber.BerTag;
import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerType;
import com.beanit.josistack.internal.presentation.asn1.AbstractSyntaxName;
import com.beanit.josistack.internal.presentation.asn1.PresentationContextIdentifier;
import com.beanit.josistack.internal.presentation.asn1.TransferSyntaxName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ContextList
implements BerType,
Serializable {
    public static final BerTag tag = new BerTag(0, 32, 16);
    private static final long serialVersionUID = 1L;
    public byte[] code = null;
    private List<SEQUENCE> seqOf = null;

    public ContextList() {
        this.seqOf = new ArrayList<SEQUENCE>();
    }

    public ContextList(byte[] code) {
        this.code = code;
    }

    public List<SEQUENCE> getSEQUENCE() {
        if (this.seqOf == null) {
            this.seqOf = new ArrayList<SEQUENCE>();
        }
        return this.seqOf;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                reverseOS.write(this.code[i]);
            }
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        for (int i = this.seqOf.size() - 1; i >= 0; --i) {
            codeLength += this.seqOf.get(i).encode(reverseOS, true);
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int codeLength = 0;
        int subCodeLength = 0;
        if (withTag) {
            codeLength += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        codeLength += length.decode(is);
        int totalLength = length.val;
        while (subCodeLength < totalLength) {
            SEQUENCE element = new SEQUENCE();
            subCodeLength += element.decode(is, true);
            this.seqOf.add(element);
        }
        if (subCodeLength != totalLength) {
            throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + totalLength + " but has " + subCodeLength);
        }
        return codeLength += subCodeLength;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.seqOf == null) {
            sb.append("null");
        } else {
            Iterator<SEQUENCE> it = this.seqOf.iterator();
            if (it.hasNext()) {
                it.next().appendAsString(sb, indentLevel + 1);
                while (it.hasNext()) {
                    sb.append(",\n");
                    for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                        sb.append("\t");
                    }
                    it.next().appendAsString(sb, indentLevel + 1);
                }
            }
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }

    public static class SEQUENCE
    implements BerType,
    Serializable {
        public static final BerTag tag = new BerTag(0, 32, 16);
        private static final long serialVersionUID = 1L;
        public byte[] code = null;
        private PresentationContextIdentifier presentationContextIdentifier = null;
        private AbstractSyntaxName abstractSyntaxName = null;
        private TransferSyntaxNameList transferSyntaxNameList = null;

        public SEQUENCE() {
        }

        public SEQUENCE(byte[] code) {
            this.code = code;
        }

        public PresentationContextIdentifier getPresentationContextIdentifier() {
            return this.presentationContextIdentifier;
        }

        public void setPresentationContextIdentifier(PresentationContextIdentifier presentationContextIdentifier) {
            this.presentationContextIdentifier = presentationContextIdentifier;
        }

        public AbstractSyntaxName getAbstractSyntaxName() {
            return this.abstractSyntaxName;
        }

        public void setAbstractSyntaxName(AbstractSyntaxName abstractSyntaxName) {
            this.abstractSyntaxName = abstractSyntaxName;
        }

        public TransferSyntaxNameList getTransferSyntaxNameList() {
            return this.transferSyntaxNameList;
        }

        public void setTransferSyntaxNameList(TransferSyntaxNameList transferSyntaxNameList) {
            this.transferSyntaxNameList = transferSyntaxNameList;
        }

        public int encode(OutputStream reverseOS) throws IOException {
            return this.encode(reverseOS, true);
        }

        public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
            if (this.code != null) {
                for (int i = this.code.length - 1; i >= 0; --i) {
                    reverseOS.write(this.code[i]);
                }
                if (withTag) {
                    return tag.encode(reverseOS) + this.code.length;
                }
                return this.code.length;
            }
            int codeLength = 0;
            codeLength += this.transferSyntaxNameList.encode(reverseOS, true);
            codeLength += this.abstractSyntaxName.encode(reverseOS, true);
            codeLength += this.presentationContextIdentifier.encode(reverseOS, true);
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
            if (withTag) {
                codeLength += tag.encode(reverseOS);
            }
            return codeLength;
        }

        public int decode(InputStream is) throws IOException {
            return this.decode(is, true);
        }

        public int decode(InputStream is, boolean withTag) throws IOException {
            int codeLength = 0;
            int subCodeLength = 0;
            BerTag berTag = new BerTag();
            if (withTag) {
                codeLength += tag.decodeAndCheck(is);
            }
            BerLength length = new BerLength();
            codeLength += length.decode(is);
            int totalLength = length.val;
            codeLength += totalLength;
            subCodeLength += berTag.decode(is);
            if (berTag.equals((Object)PresentationContextIdentifier.tag)) {
                this.presentationContextIdentifier = new PresentationContextIdentifier();
                subCodeLength += this.presentationContextIdentifier.decode(is, false);
                subCodeLength += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match the mandatory sequence element tag.");
            }
            if (berTag.equals((Object)AbstractSyntaxName.tag)) {
                this.abstractSyntaxName = new AbstractSyntaxName();
                subCodeLength += this.abstractSyntaxName.decode(is, false);
                subCodeLength += berTag.decode(is);
            } else {
                throw new IOException("Tag does not match the mandatory sequence element tag.");
            }
            if (berTag.equals((Object)TransferSyntaxNameList.tag)) {
                this.transferSyntaxNameList = new TransferSyntaxNameList();
                if ((subCodeLength += this.transferSyntaxNameList.decode(is, false)) == totalLength) {
                    return codeLength;
                }
            }
            throw new IOException("Unexpected end of sequence, length tag: " + totalLength + ", actual sequence length: " + subCodeLength);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode((OutputStream)reverseOS, false);
            this.code = reverseOS.getArray();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.appendAsString(sb, 0);
            return sb.toString();
        }

        public void appendAsString(StringBuilder sb, int indentLevel) {
            int i;
            sb.append("{");
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.presentationContextIdentifier != null) {
                sb.append("presentationContextIdentifier: ").append((Object)this.presentationContextIdentifier);
            } else {
                sb.append("presentationContextIdentifier: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.abstractSyntaxName != null) {
                sb.append("abstractSyntaxName: ").append((Object)this.abstractSyntaxName);
            } else {
                sb.append("abstractSyntaxName: <empty-required-field>");
            }
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            if (this.transferSyntaxNameList != null) {
                sb.append("transferSyntaxNameList: ");
                this.transferSyntaxNameList.appendAsString(sb, indentLevel + 1);
            } else {
                sb.append("transferSyntaxNameList: <empty-required-field>");
            }
            sb.append("\n");
            for (i = 0; i < indentLevel; ++i) {
                sb.append("\t");
            }
            sb.append("}");
        }

        public static class TransferSyntaxNameList
        implements BerType,
        Serializable {
            public static final BerTag tag = new BerTag(0, 32, 16);
            private static final long serialVersionUID = 1L;
            public byte[] code = null;
            private List<TransferSyntaxName> seqOf = null;

            public TransferSyntaxNameList() {
                this.seqOf = new ArrayList<TransferSyntaxName>();
            }

            public TransferSyntaxNameList(byte[] code) {
                this.code = code;
            }

            public List<TransferSyntaxName> getTransferSyntaxName() {
                if (this.seqOf == null) {
                    this.seqOf = new ArrayList<TransferSyntaxName>();
                }
                return this.seqOf;
            }

            public int encode(OutputStream reverseOS) throws IOException {
                return this.encode(reverseOS, true);
            }

            public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
                if (this.code != null) {
                    for (int i = this.code.length - 1; i >= 0; --i) {
                        reverseOS.write(this.code[i]);
                    }
                    if (withTag) {
                        return tag.encode(reverseOS) + this.code.length;
                    }
                    return this.code.length;
                }
                int codeLength = 0;
                for (int i = this.seqOf.size() - 1; i >= 0; --i) {
                    codeLength += this.seqOf.get(i).encode(reverseOS, true);
                }
                codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
                if (withTag) {
                    codeLength += tag.encode(reverseOS);
                }
                return codeLength;
            }

            public int decode(InputStream is) throws IOException {
                return this.decode(is, true);
            }

            public int decode(InputStream is, boolean withTag) throws IOException {
                int codeLength = 0;
                int subCodeLength = 0;
                if (withTag) {
                    codeLength += tag.decodeAndCheck(is);
                }
                BerLength length = new BerLength();
                codeLength += length.decode(is);
                int totalLength = length.val;
                while (subCodeLength < totalLength) {
                    TransferSyntaxName element = new TransferSyntaxName();
                    subCodeLength += element.decode(is, true);
                    this.seqOf.add(element);
                }
                if (subCodeLength != totalLength) {
                    throw new IOException("Decoded SequenceOf or SetOf has wrong length. Expected " + totalLength + " but has " + subCodeLength);
                }
                return codeLength += subCodeLength;
            }

            public void encodeAndSave(int encodingSizeGuess) throws IOException {
                ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
                this.encode((OutputStream)reverseOS, false);
                this.code = reverseOS.getArray();
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.appendAsString(sb, 0);
                return sb.toString();
            }

            public void appendAsString(StringBuilder sb, int indentLevel) {
                int i;
                sb.append("{\n");
                for (i = 0; i < indentLevel + 1; ++i) {
                    sb.append("\t");
                }
                if (this.seqOf == null) {
                    sb.append("null");
                } else {
                    Iterator<TransferSyntaxName> it = this.seqOf.iterator();
                    if (it.hasNext()) {
                        sb.append((Object)it.next());
                        while (it.hasNext()) {
                            sb.append(",\n");
                            for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                                sb.append("\t");
                            }
                            sb.append((Object)it.next());
                        }
                    }
                }
                sb.append("\n");
                for (i = 0; i < indentLevel; ++i) {
                    sb.append("\t");
                }
                sb.append("}");
            }
        }
    }
}

