/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.jositransport;

import com.beanit.jositransport.ServerThread;
import com.beanit.jositransport.TConnectionListener;
import java.io.IOException;
import java.net.InetAddress;
import javax.net.ServerSocketFactory;

public class ServerTSap {
    private final int port;
    private final InetAddress bindAddr;
    private final int backlog;
    private final TConnectionListener connectionListener;
    private final ServerSocketFactory serverSocketFactory;
    private ServerThread serverThread;
    private boolean started = false;
    private int maxTPDUSizeParam = 16;
    private int maxConnections = 100;
    private int messageTimeout = 0;
    private int messageFragmentTimeout = 60000;

    public ServerTSap(int port, TConnectionListener conListener) {
        this(port, 0, null, conListener, ServerSocketFactory.getDefault());
    }

    public ServerTSap(int port, int backlog, InetAddress bindAddr, TConnectionListener conListener) {
        this(port, backlog, bindAddr, conListener, ServerSocketFactory.getDefault());
    }

    public ServerTSap(int port, int backlog, InetAddress bindAddr, TConnectionListener connectionListener, ServerSocketFactory serverSocketFactory) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port number is out of bound");
        }
        this.port = port;
        this.backlog = backlog;
        this.bindAddr = bindAddr;
        this.connectionListener = connectionListener;
        this.serverSocketFactory = serverSocketFactory;
    }

    public static int getMaxTPDUSize(int maxTPDUSizeParam) {
        if (maxTPDUSizeParam < 7 || maxTPDUSizeParam > 16) {
            throw new IllegalArgumentException("maxTPDUSizeParam is out of bound");
        }
        if (maxTPDUSizeParam == 16) {
            return 65531;
        }
        return (int)Math.pow(2.0, maxTPDUSizeParam);
    }

    public void startListening() throws IOException {
        this.started = true;
        this.serverThread = new ServerThread(this.serverSocketFactory.createServerSocket(this.port, this.backlog, this.bindAddr), this.maxTPDUSizeParam, this.maxConnections, this.messageTimeout, this.messageFragmentTimeout, this.connectionListener);
        this.serverThread.start();
    }

    public void stopListening() {
        if (this.serverThread != null) {
            this.serverThread.stopServer();
        }
        this.serverThread = null;
        this.started = false;
    }

    public void setMaxConnections(int maxConnections) {
        if (this.started) {
            throw new RuntimeException("Trying to set parameter although server has started.");
        }
        if (maxConnections < 0) {
            throw new IllegalArgumentException("maxConnections is out of bound");
        }
        this.maxConnections = maxConnections;
    }

    public void setMessageTimeout(int messageTimeout) {
        if (this.started) {
            throw new RuntimeException("Message timeout may not be set while the server SAP ist listening.");
        }
        this.messageTimeout = messageTimeout;
    }

    public void setMessageFragmentTimeout(int messageFragmentTimeout) {
        if (this.started) {
            throw new RuntimeException("Message fragment timeout may not be set while the server SAP ist listening.");
        }
        this.messageFragmentTimeout = messageFragmentTimeout;
    }

    public int getMaxTPDUSizeParam() {
        return this.maxTPDUSizeParam;
    }

    public void setMaxTPDUSizeParam(int maxTPduSizeParam) {
        if (this.started) {
            throw new RuntimeException("Trying to set parameter although server has started.");
        }
        if (maxTPduSizeParam < 7 || maxTPduSizeParam > 16) {
            throw new IllegalArgumentException("maxTPDUSizeParam is out of bound");
        }
        this.maxTPDUSizeParam = maxTPduSizeParam;
    }

    TConnectionListener getConnectionListener() {
        return this.connectionListener;
    }
}

