/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.FcModelNode;
import com.beanit.openiec61850.ModelNode;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;
import com.beanit.openiec61850.internal.mms.asn1.TypeSpecification;
import com.beanit.openiec61850.internal.mms.asn1.Unsigned32;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class Array
extends FcModelNode {
    private final List<ModelNode> items;

    public Array(ObjectReference objectReference, Fc fc, List<FcModelNode> children) {
        this.objectReference = objectReference;
        this.fc = fc;
        this.items = new ArrayList<ModelNode>(children.size());
        for (ModelNode modelNode : children) {
            this.items.add(modelNode);
            modelNode.setParent(this);
        }
    }

    @Override
    public Collection<ModelNode> getChildren() {
        return new ArrayList<ModelNode>(this.items);
    }

    @Override
    public Iterator<ModelNode> iterator() {
        return this.items.iterator();
    }

    @Override
    public ModelNode getChild(String childName, Fc fc) {
        return this.items.get(Integer.parseInt(childName));
    }

    public ModelNode getChild(int index) {
        return this.items.get(index);
    }

    @Override
    public ModelNode copy() {
        ArrayList<FcModelNode> itemsCopy = new ArrayList<FcModelNode>(this.items.size());
        for (ModelNode item : this.items) {
            itemsCopy.add((FcModelNode)item.copy());
        }
        return new Array(this.objectReference, this.fc, itemsCopy);
    }

    @Override
    public List<BasicDataAttribute> getBasicDataAttributes() {
        LinkedList<BasicDataAttribute> subBasicDataAttributes = new LinkedList<BasicDataAttribute>();
        for (ModelNode item : this.items) {
            subBasicDataAttributes.addAll(item.getBasicDataAttributes());
        }
        return subBasicDataAttributes;
    }

    public int size() {
        return this.items.size();
    }

    @Override
    Data getMmsDataObj() {
        Data.Array dataArray = new Data.Array();
        List<Data> arrayDataList = dataArray.getData();
        for (ModelNode modelNode : this.items) {
            Data mmsArrayItem = modelNode.getMmsDataObj();
            if (mmsArrayItem == null) {
                throw new IllegalArgumentException("Unable to convert Child: " + modelNode.objectReference + " to MMS Data Object.");
            }
            arrayDataList.add(mmsArrayItem);
        }
        if (arrayDataList.size() == 0) {
            throw new IllegalArgumentException("Converting ModelNode: " + this.objectReference + " to MMS Data Object resulted in Sequence of size zero.");
        }
        Data data = new Data();
        data.setArray(dataArray);
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getArray() == null) {
            throw new ServiceError(10, "expected type: array");
        }
        if (data.getArray().getData().size() != this.items.size()) {
            throw new ServiceError(10, "expected type: array with " + this.children.size() + " elements");
        }
        Iterator<Data> iterator = data.getArray().getData().iterator();
        for (ModelNode child : this.items) {
            child.setValueFromMmsDataObj(iterator.next());
        }
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeSpecification elementType = new TypeSpecification();
        elementType.setTypeDescription(this.items.get(0).getMmsTypeSpec());
        TypeDescription.Array array = new TypeDescription.Array();
        array.setNumberOfElements(new Unsigned32(this.items.size()));
        array.setElementType(elementType);
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setArray(array);
        return typeDescription;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReference().toString()).append(" [").append((Object)this.fc).append("]");
        for (ModelNode childNode : this.items) {
            sb.append("\n");
            sb.append(childNode.toString());
        }
        return sb.toString();
    }
}

