/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.jasn1.ber.types.BerBitString;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.HexConverter;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.Integer32;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;

public abstract class BdaBitString
extends BasicDataAttribute {
    final int maxNumBits;
    volatile byte[] value;

    public BdaBitString(ObjectReference objectReference, Fc fc, String sAddr, int maxNumBits, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.maxNumBits = maxNumBits;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value.length != (this.maxNumBits - 1) / 8 + 1) {
            throw new IllegalArgumentException("value does not have correct length.");
        }
        this.value = value;
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaBitString)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public int getMaxNumBits() {
        return this.maxNumBits;
    }

    @Override
    public void setDefault() {
        this.value = new byte[(this.maxNumBits - 1) / 8 + 1];
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setBitString(new BerBitString(this.value, this.maxNumBits));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getBitString() == null) {
            throw new ServiceError(10, "expected type: bit_string");
        }
        if (data.getBitString().numBits > this.maxNumBits) {
            throw new ServiceError(10, this.objectReference + ": bit_string is bigger than type's size: " + data.getBitString().numBits + ">" + this.maxNumBits);
        }
        this.value = data.getBitString().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setBitString(new Integer32(this.maxNumBits * -1));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + HexConverter.toHexString(this.value);
    }

    @Override
    public String getValueString() {
        return HexConverter.toHexString(this.value);
    }
}

