/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.BerBoolean;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.TimeOfDay;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;

public final class BdaEntryTime
extends BasicDataAttribute {
    private volatile byte[] value;

    public BdaEntryTime(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.ENTRY_TIME;
        this.setDefault();
    }

    public void setTimestamp(long timestamp) {
        long msSince1984 = timestamp - 441763200000L;
        int days = (int)(msSince1984 / 86400000L);
        int ms = (int)(msSince1984 % 86400000L);
        this.value = new byte[]{(byte)(ms >> 24), (byte)(ms >> 16), (byte)(ms >> 8), (byte)ms, (byte)(days >> 8), (byte)days};
    }

    public long getTimestampValue() {
        if (this.value.length != 6) {
            return -1L;
        }
        return (((long)this.value[0] & 0xFFL) << 24) + (((long)this.value[1] & 0xFFL) << 16) + (((long)this.value[2] & 0xFFL) << 8) + ((long)this.value[3] & 0xFFL) + ((((long)this.value[4] & 0xFFL) << 8) + ((long)this.value[5] & 0xFFL)) * 86400000L + 441763200000L;
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaEntryTime)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public void setDefault() {
        this.value = new byte[6];
    }

    @Override
    public BdaEntryTime copy() {
        BdaEntryTime copy = new BdaEntryTime(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        if (this.value == null) {
            return null;
        }
        Data data = new Data();
        data.setBinaryTime(new TimeOfDay(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getBinaryTime() == null) {
            throw new ServiceError(10, "expected type: binary_time/EntryTime");
        }
        this.value = data.getBinaryTime().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setBinaryTime(new BerBoolean(true));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.getTimestampValue();
    }

    @Override
    public String getValueString() {
        return "" + this.getTimestampValue();
    }
}

