/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;
import com.beanit.openiec61850.internal.mms.asn1.Unsigned8;

public final class BdaInt64
extends BasicDataAttribute {
    private volatile long value;

    public BdaInt64(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.INT64;
        this.setDefault();
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        this.value = ((BdaInt64)bda).getValue();
    }

    public long getValue() {
        return this.value;
    }

    public void setValue(long value) {
        this.value = value;
    }

    @Override
    public void setDefault() {
        this.value = 0L;
    }

    @Override
    public BdaInt64 copy() {
        BdaInt64 copy = new BdaInt64(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        copy.setValue(this.value);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setInteger(new BerInteger(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getInteger() == null) {
            throw new ServiceError(10, "expected type: integer");
        }
        this.value = data.getInteger().value.longValue();
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setInteger(new Unsigned8(64L));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.value;
    }
}

