/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;
import com.beanit.openiec61850.internal.mms.asn1.Unsigned8;

public final class BdaInt8U
extends BasicDataAttribute {
    private volatile short value;

    public BdaInt8U(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.INT8U;
        this.setDefault();
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        this.value = ((BdaInt8U)bda).getValue();
    }

    public short getValue() {
        return this.value;
    }

    public void setValue(short value) {
        this.value = value;
    }

    @Override
    public void setDefault() {
        this.value = 0;
    }

    @Override
    public BdaInt8U copy() {
        BdaInt8U copy = new BdaInt8U(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        copy.setValue(this.value);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setUnsigned(new BerInteger((long)this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getUnsigned() == null) {
            throw new ServiceError(10, "expected type: unsigned");
        }
        this.value = data.getUnsigned().value.shortValue();
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setUnsigned(new Unsigned8(8L));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + this.value;
    }
}

