/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.jasn1.ber.types.BerOctetString;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.Integer32;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;
import java.util.Arrays;

public final class BdaOctetString
extends BasicDataAttribute {
    private final int maxLength;
    private volatile byte[] value;

    public BdaOctetString(ObjectReference objectReference, Fc fc, String sAddr, int maxLength, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.OCTET_STRING;
        this.maxLength = maxLength;
        this.setDefault();
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value != null && value.length > this.maxLength) {
            throw new IllegalArgumentException("OCTET_STRING value size exceeds maxLength of " + this.maxLength);
        }
        this.value = value;
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaOctetString)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setDefault() {
        this.value = new byte[0];
    }

    @Override
    public BdaOctetString copy() {
        BdaOctetString copy = new BdaOctetString(this.objectReference, this.fc, this.sAddr, this.maxLength, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setOctetString(new BerOctetString(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getOctetString() == null) {
            throw new ServiceError(10, "expected type: octet_string");
        }
        this.value = data.getOctetString().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setOctetString(new Integer32(this.maxLength * -1));
        return typeDescription;
    }

    @Override
    public String toString() {
        return this.getReference().toString() + ": " + Arrays.toString(this.value);
    }
}

