/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.BdaBitString;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;

public final class BdaOptFlds
extends BdaBitString {
    public BdaOptFlds(ObjectReference objectReference, Fc fc) {
        super(objectReference, fc, null, 10, false, false);
        this.basicType = BdaType.OPTFLDS;
        this.setDefault();
    }

    @Override
    public void setDefault() {
        this.value = new byte[]{2, 0};
    }

    @Override
    public BdaOptFlds copy() {
        BdaOptFlds copy = new BdaOptFlds(this.objectReference, this.fc);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    public boolean isSequenceNumber() {
        return (this.value[0] & 0x40) == 64;
    }

    public void setSequenceNumber(boolean sequenceNumber) {
        this.value[0] = sequenceNumber ? (byte)(this.value[0] | 0x40) : (byte)(this.value[0] & 0xBF);
    }

    public boolean isReportTimestamp() {
        return (this.value[0] & 0x20) == 32;
    }

    public void setReportTimestamp(boolean reportTimestamp) {
        this.value[0] = reportTimestamp ? (byte)(this.value[0] | 0x20) : (byte)(this.value[0] & 0x2F);
    }

    public boolean isReasonForInclusion() {
        return (this.value[0] & 0x10) == 16;
    }

    public void setReasonForInclusion(boolean reasonForInclusion) {
        this.value[0] = reasonForInclusion ? (byte)(this.value[0] | 0x10) : (byte)(this.value[0] & 0xEF);
    }

    public boolean isDataSetName() {
        return (this.value[0] & 8) == 8;
    }

    public void setDataSetName(boolean dataSetName) {
        this.value[0] = dataSetName ? (byte)(this.value[0] | 8) : (byte)(this.value[0] & 0xF7);
    }

    public boolean isDataReference() {
        return (this.value[0] & 4) == 4;
    }

    public void setDataReference(boolean dataReference) {
        this.value[0] = dataReference ? (byte)(this.value[0] | 4) : (byte)(this.value[0] & 0xFB);
    }

    public boolean isBufferOverflow() {
        return (this.value[0] & 2) == 2;
    }

    public void setBufferOverflow(boolean bufferOverflow) {
        this.value[0] = bufferOverflow ? (byte)(this.value[0] | 2) : (byte)(this.value[0] & 0xFD);
    }

    public boolean isEntryId() {
        return (this.value[0] & 1) == 1;
    }

    public void setEntryId(boolean entryId) {
        this.value[0] = entryId ? (byte)(this.value[0] | 1) : (byte)(this.value[0] & 0xFE);
    }

    public boolean isConfigRevision() {
        return (this.value[1] & 0x80) == 128;
    }

    public void setConfigRevision(boolean configRevision) {
        this.value[1] = configRevision ? (byte)(this.value[1] | 0x80) : (byte)(this.value[1] & 0x7F);
    }

    public boolean isSegmentation() {
        return (this.value[1] & 0x40) == 64;
    }

    public void setSegmentation(boolean segmentation) {
        this.value[1] = segmentation ? (byte)(this.value[1] | 0x40) : (byte)(this.value[1] & 0xBF);
    }
}

