/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.BdaBitString;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;
import java.util.ArrayList;

public final class BdaQuality
extends BdaBitString {
    public BdaQuality(ObjectReference objectReference, Fc fc, String sAddr, boolean qchg) {
        super(objectReference, fc, sAddr, 13, false, false);
        this.qchg = qchg;
        this.basicType = BdaType.QUALITY;
        if (qchg) {
            this.chgRcbs = new ArrayList();
        }
        this.setDefault();
    }

    @Override
    public void setDefault() {
        this.value = new byte[]{0, 0};
    }

    @Override
    public BdaQuality copy() {
        BdaQuality copy = new BdaQuality(this.objectReference, this.fc, this.sAddr, this.qchg);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    public Validity getValidity() {
        if ((this.value[0] & 0xC0) == 192) {
            return Validity.QUESTIONABLE;
        }
        if ((this.value[0] & 0x80) == 128) {
            return Validity.RESERVED;
        }
        if ((this.value[0] & 0x40) == 64) {
            return Validity.INVALID;
        }
        return Validity.GOOD;
    }

    public void setValidity(Validity validity) {
        if (validity == Validity.QUESTIONABLE) {
            this.value[0] = (byte)(this.value[0] | 0xC0);
        } else if (validity == Validity.RESERVED) {
            this.value[0] = (byte)(this.value[0] | 0x80);
            this.value[0] = (byte)(this.value[0] & 0xBF);
        } else if (validity == Validity.INVALID) {
            this.value[0] = (byte)(this.value[0] & 0x7F);
            this.value[0] = (byte)(this.value[0] | 0x40);
        } else {
            this.value[0] = (byte)(this.value[0] & 3);
        }
    }

    public boolean isOverflow() {
        return (this.value[0] & 0x20) == 32;
    }

    public void setOverflow(boolean overflow) {
        this.value[0] = overflow ? (byte)(this.value[0] | 0x20) : (byte)(this.value[0] & 0xDF);
    }

    public boolean isOutOfRange() {
        return (this.value[0] & 0x10) == 16;
    }

    public void setOutOfRange(boolean outOfRange) {
        this.value[0] = outOfRange ? (byte)(this.value[0] | 0x10) : (byte)(this.value[0] & 0xEF);
    }

    public boolean isBadReference() {
        return (this.value[0] & 8) == 8;
    }

    public void setBadReference(boolean badReference) {
        this.value[0] = badReference ? (byte)(this.value[0] | 8) : (byte)(this.value[0] & 0xF7);
    }

    public boolean isOscillatory() {
        return (this.value[0] & 4) == 4;
    }

    public void setOscillatory(boolean oscillatory) {
        this.value[0] = oscillatory ? (byte)(this.value[0] | 4) : (byte)(this.value[0] & 0xFB);
    }

    public boolean isFailure() {
        return (this.value[0] & 2) == 2;
    }

    public void setFailure(boolean failure) {
        this.value[0] = failure ? (byte)(this.value[0] | 2) : (byte)(this.value[0] & 0xFD);
    }

    public boolean isOldData() {
        return (this.value[0] & 1) == 1;
    }

    public void setOldData(boolean oldData) {
        this.value[0] = oldData ? (byte)(this.value[0] | 1) : (byte)(this.value[0] & 0xFE);
    }

    public boolean isInconsistent() {
        return (this.value[1] & 0x80) == 128;
    }

    public void setInconsistent(boolean inconsistent) {
        this.value[1] = inconsistent ? (byte)(this.value[0] | 0x80) : (byte)(this.value[0] & 0x7F);
    }

    public boolean isInaccurate() {
        return (this.value[1] & 0x40) == 64;
    }

    public void setInaccurate(boolean inaccurate) {
        this.value[1] = inaccurate ? (byte)(this.value[0] | 0x40) : (byte)(this.value[0] & 0xBF);
    }

    public boolean isSubstituted() {
        return (this.value[1] & 0x20) == 32;
    }

    public void setSubstituted(boolean substituted) {
        this.value[1] = substituted ? (byte)(this.value[0] | 0x20) : (byte)(this.value[0] & 0xDF);
    }

    public boolean isTest() {
        return (this.value[1] & 0x10) == 16;
    }

    public void setTest(boolean test) {
        this.value[1] = test ? (byte)(this.value[0] | 0x10) : (byte)(this.value[0] & 0xEF);
    }

    public boolean isOperatorBlocked() {
        return (this.value[1] & 8) == 8;
    }

    public void setOperatorBlocked(boolean operatorBlocked) {
        this.value[1] = operatorBlocked ? (byte)(this.value[0] | 8) : (byte)(this.value[0] & 0xF7);
    }

    @Override
    public String getValueString() {
        return this.getValidity().toString();
    }

    public static enum Validity {
        GOOD(0),
        INVALID(1),
        RESERVED(2),
        QUESTIONABLE(3);

        private final int value;

        private Validity(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return this.value;
        }
    }
}

