/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.BdaBitString;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;

public final class BdaTapCommand
extends BdaBitString {
    public BdaTapCommand(ObjectReference objectReference, Fc fc, String sAddr, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, 2, dchg, dupd);
        this.basicType = BdaType.TAP_COMMAND;
        this.setDefault();
    }

    @Override
    public void setDefault() {
        this.value = new byte[]{0};
    }

    @Override
    public BdaTapCommand copy() {
        BdaTapCommand copy = new BdaTapCommand(this.objectReference, this.fc, this.sAddr, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    public TapCommand getTapCommand() {
        if ((this.value[0] & 0xC0) == 192) {
            return TapCommand.RESERVED;
        }
        if ((this.value[0] & 0x80) == 128) {
            return TapCommand.HIGHER;
        }
        if ((this.value[0] & 0x40) == 64) {
            return TapCommand.LOWER;
        }
        return TapCommand.STOP;
    }

    public void setTapCommand(TapCommand tapCommand) {
        this.value[0] = tapCommand == TapCommand.RESERVED ? -64 : (tapCommand == TapCommand.HIGHER ? -128 : (tapCommand == TapCommand.LOWER ? 64 : 0));
    }

    public static enum TapCommand {
        STOP(0),
        LOWER(1),
        HIGHER(2),
        RESERVED(3);

        private final int value;

        private TapCommand(int value) {
            this.value = value;
        }

        public int getIntValue() {
            return this.value;
        }
    }
}

