/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.BdaBitString;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;

public final class BdaTriggerConditions
extends BdaBitString {
    public BdaTriggerConditions(ObjectReference objectReference, Fc fc) {
        super(objectReference, fc, null, 6, false, false);
        this.basicType = BdaType.TRIGGER_CONDITIONS;
        this.setDefault();
    }

    @Override
    public void setDefault() {
        this.value = new byte[]{4};
    }

    @Override
    public BdaTriggerConditions copy() {
        BdaTriggerConditions copy = new BdaTriggerConditions(this.objectReference, this.fc);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    public boolean isDataChange() {
        return (this.value[0] & 0x40) == 64;
    }

    public void setDataChange(boolean dataChange) {
        this.value[0] = dataChange ? (byte)(this.value[0] | 0x40) : (byte)(this.value[0] & 0xBF);
    }

    public boolean isQualityChange() {
        return (this.value[0] & 0x20) == 32;
    }

    public void setQualityChange(boolean qualityChange) {
        this.value[0] = qualityChange ? (byte)(this.value[0] | 0x20) : (byte)(this.value[0] & 0xDF);
    }

    public boolean isDataUpdate() {
        return (this.value[0] & 0x10) == 16;
    }

    public void setDataUpdate(boolean dataUpdate) {
        this.value[0] = dataUpdate ? (byte)(this.value[0] | 0x10) : (byte)(this.value[0] & 0xEF);
    }

    public boolean isIntegrity() {
        return (this.value[0] & 8) == 8;
    }

    public void setIntegrity(boolean integrity) {
        this.value[0] = integrity ? (byte)(this.value[0] | 8) : (byte)(this.value[0] & 0xF7);
    }

    public boolean isGeneralInterrogation() {
        return (this.value[0] & 4) == 4;
    }

    public void setGeneralInterrogation(boolean generalInterrogation) {
        this.value[0] = generalInterrogation ? (byte)(this.value[0] | 4) : (byte)(this.value[0] & 0xFB);
    }

    @Override
    public String toString() {
        return super.toString() + ", data change: " + this.isDataChange() + ", data update: " + this.isDataUpdate() + ", quality change:" + this.isQualityChange() + ", integrity period: " + this.isIntegrity() + ", GI: " + this.isGeneralInterrogation();
    }
}

