/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaType;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.Integer32;
import com.beanit.openiec61850.internal.mms.asn1.MMSString;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;

public final class BdaUnicodeString
extends BasicDataAttribute {
    private final int maxLength;
    private byte[] value;

    public BdaUnicodeString(ObjectReference objectReference, Fc fc, String sAddr, int maxLength, boolean dchg, boolean dupd) {
        super(objectReference, fc, sAddr, dchg, dupd);
        this.basicType = BdaType.UNICODE_STRING;
        this.maxLength = maxLength;
        this.setDefault();
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value == null || value.length > this.maxLength) {
            throw new IllegalArgumentException("Value was null or UNICODE_STRING value size exceeds maxLength of " + this.maxLength);
        }
        this.value = value;
    }

    @Override
    public void setValueFrom(BasicDataAttribute bda) {
        byte[] srcValue = ((BdaUnicodeString)bda).getValue();
        if (this.value.length != srcValue.length) {
            this.value = new byte[srcValue.length];
        }
        System.arraycopy(srcValue, 0, this.value, 0, srcValue.length);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setDefault() {
        this.value = new byte[0];
    }

    @Override
    public BdaUnicodeString copy() {
        BdaUnicodeString copy = new BdaUnicodeString(this.objectReference, this.fc, this.sAddr, this.maxLength, this.dchg, this.dupd);
        byte[] valueCopy = new byte[this.value.length];
        System.arraycopy(this.value, 0, valueCopy, 0, this.value.length);
        copy.setValue(valueCopy);
        copy.mirror = this.mirror == null ? this : this.mirror;
        return copy;
    }

    @Override
    Data getMmsDataObj() {
        Data data = new Data();
        data.setMMSString(new MMSString(this.value));
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getMMSString() == null) {
            throw new ServiceError(10, "expected type: mms_string/unicode_string");
        }
        this.value = data.getMMSString().value;
    }

    @Override
    TypeDescription getMmsTypeSpec() {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setMMSString(new Integer32(this.maxLength * -1));
        return typeDescription;
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return this.getReference().toString() + ": null";
        }
        return this.getReference().toString() + ": " + new String(this.value);
    }
}

