/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.josistack.ClientAcseSap;
import com.beanit.openiec61850.ClientAssociation;
import com.beanit.openiec61850.ClientEventListener;
import java.io.IOException;
import java.net.InetAddress;
import javax.net.SocketFactory;

public final class ClientSap {
    static final int MINIMUM_MMS_PDU_SIZE = 64;
    private static final int MAXIMUM_MMS_PDU_SIZE = 65000;
    private static final byte[] DEFAULT_TSEL_LOCAL = new byte[]{0, 0};
    private static final byte[] DEFAULT_TSEL_REMOTE = new byte[]{0, 1};
    private static final int DEFAUTL_TPDU_SIZE_PARAMETER = 10;
    private final int proposedMaxServOutstandingCalling = 5;
    private final int proposedMaxServOutstandingCalled = 5;
    private final int proposedDataStructureNestingLevel = 10;
    private final ClientAcseSap acseSap;
    private int proposedMaxMmsPduSize = 65000;
    private byte[] servicesSupportedCalling = new byte[]{-18, 28, 0, 0, 4, 8, 0, 0, 121, -17, 24};
    private int messageFragmentTimeout = 10000;
    private int responseTimeout = 20000;

    public ClientSap() {
        this.acseSap = new ClientAcseSap();
        this.acseSap.tSap.tSelLocal = DEFAULT_TSEL_LOCAL;
        this.acseSap.tSap.tSelRemote = DEFAULT_TSEL_REMOTE;
        this.acseSap.tSap.setMaxTPDUSizeParam(10);
    }

    public ClientSap(SocketFactory socketFactory) {
        this.acseSap = new ClientAcseSap(socketFactory);
        this.acseSap.tSap.tSelLocal = DEFAULT_TSEL_LOCAL;
        this.acseSap.tSap.tSelRemote = DEFAULT_TSEL_REMOTE;
        this.acseSap.tSap.setMaxTPDUSizeParam(10);
    }

    public int getMaxMmsPduSize() {
        return this.proposedMaxMmsPduSize;
    }

    public void setMaxMmsPduSize(int size) {
        if (size < 64 || size > 65000) {
            throw new IllegalArgumentException("maximum size is out of bound");
        }
        this.proposedMaxMmsPduSize = size;
    }

    public byte[] getServicesSupportedCalling() {
        return this.servicesSupportedCalling;
    }

    public void setServicesSupportedCalling(byte[] services) {
        if (services.length != 11) {
            throw new IllegalArgumentException("The services parameter needs to be of lenth 11");
        }
        this.servicesSupportedCalling = services;
    }

    public void setSSelRemote(byte[] sSelRemote) {
        this.acseSap.sSelRemote = sSelRemote;
    }

    public void setSSelLocal(byte[] sSelLocal) {
        this.acseSap.sSelLocal = sSelLocal;
    }

    public void setPSelRemote(byte[] pSelRemote) {
        this.acseSap.pSelRemote = pSelRemote;
    }

    public void setPSelLocal(byte[] pSelLocal) {
        this.acseSap.pSelLocal = pSelLocal;
    }

    public void setTSelRemote(byte[] tSelRemote) {
        this.acseSap.tSap.tSelRemote = tSelRemote;
    }

    public void setTSelLocal(byte[] tSelLocal) {
        this.acseSap.tSap.tSelLocal = tSelLocal;
    }

    public void setMaxTPduSizeParameter(int maxTPduSizeParam) {
        this.acseSap.tSap.setMaxTPDUSizeParam(maxTPduSizeParam);
    }

    public void setApTitleCalled(int[] title) {
        this.acseSap.setApTitleCalled(title);
    }

    public void setApTitleCalling(int[] title) {
        this.acseSap.setApTitleCalling(title);
    }

    public void setAeQualifierCalled(int qualifier) {
        this.acseSap.setAeQualifierCalled(qualifier);
    }

    public void setAeQualifierCalling(int qualifier) {
        this.acseSap.setAeQualifierCalling(qualifier);
    }

    public void setResponseTimeout(int timeout) {
        this.responseTimeout = timeout;
    }

    public void setMessageFragmentTimeout(int timeout) {
        this.messageFragmentTimeout = timeout;
    }

    public ClientAssociation associate(InetAddress address, int port, String authenticationParameter, ClientEventListener reportListener) throws IOException {
        return this.associate(address, port, authenticationParameter, null, -1, reportListener);
    }

    public ClientAssociation associate(InetAddress address, int port, String authenticationParameter, InetAddress localAddr, int localPort, ClientEventListener reportListener) throws IOException {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port");
        }
        if (address == null) {
            throw new IllegalArgumentException("address may not be null");
        }
        if (this.acseSap.sSelRemote == null) {
            throw new IllegalArgumentException("sSelRemote may not be null");
        }
        if (this.acseSap.sSelRemote.length != 2) {
            throw new IllegalArgumentException("sSelRemote lenght must be two");
        }
        if (this.acseSap.sSelLocal == null) {
            throw new IllegalArgumentException("sSelLocal may not be null");
        }
        if (this.acseSap.sSelLocal.length != 2) {
            throw new IllegalArgumentException("sSelLocal lenght must be two");
        }
        ClientAssociation clientAssociation = new ClientAssociation(address, port, localAddr, localPort, authenticationParameter, this.acseSap, this.proposedMaxMmsPduSize, 5, 5, 10, this.servicesSupportedCalling, this.responseTimeout, this.messageFragmentTimeout, reportListener);
        return clientAssociation;
    }
}

