/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.FcModelNode;
import com.beanit.openiec61850.ModelNode;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public final class ConstructedDataAttribute
extends FcModelNode {
    public ConstructedDataAttribute(ObjectReference objectReference, Fc fc, List<FcModelNode> children) {
        this.objectReference = objectReference;
        this.fc = fc;
        this.children = new LinkedHashMap((int)((double)children.size() / 0.75 + 1.0));
        for (ModelNode modelNode : children) {
            this.children.put(modelNode.getName(), modelNode);
            modelNode.setParent(this);
        }
    }

    @Override
    public ConstructedDataAttribute copy() {
        ArrayList<FcModelNode> subDataAttributesCopy = new ArrayList<FcModelNode>();
        for (ModelNode subDA : this.children.values()) {
            subDataAttributesCopy.add((FcModelNode)subDA.copy());
        }
        return new ConstructedDataAttribute(this.getReference(), this.fc, subDataAttributesCopy);
    }

    @Override
    Data getMmsDataObj() {
        Data.Structure structure = new Data.Structure();
        List<Data> seq = structure.getData();
        for (ModelNode modelNode : this.getChildren()) {
            Data child = modelNode.getMmsDataObj();
            if (child == null) {
                throw new IllegalArgumentException("Unable to convert Child: " + modelNode.objectReference + " to MMS Data Object.");
            }
            seq.add(child);
        }
        if (seq.size() == 0) {
            throw new IllegalArgumentException("Converting ModelNode: " + this.objectReference + " to MMS Data Object resulted in Sequence of size zero.");
        }
        Data data = new Data();
        data.setStructure(structure);
        return data;
    }

    @Override
    void setValueFromMmsDataObj(Data data) throws ServiceError {
        if (data.getStructure() == null) {
            throw new ServiceError(10, "expected type: structure");
        }
        if (data.getStructure().getData().size() != this.children.size()) {
            throw new ServiceError(10, "expected type: structure with " + this.children.size() + " elements");
        }
        Iterator<Data> iterator = data.getStructure().getData().iterator();
        for (ModelNode child : this.children.values()) {
            child.setValueFromMmsDataObj(iterator.next());
        }
    }
}

