/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.Array;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaBoolean;
import com.beanit.openiec61850.BdaCheck;
import com.beanit.openiec61850.BdaDoubleBitPos;
import com.beanit.openiec61850.BdaEntryTime;
import com.beanit.openiec61850.BdaFloat32;
import com.beanit.openiec61850.BdaFloat64;
import com.beanit.openiec61850.BdaInt128;
import com.beanit.openiec61850.BdaInt16;
import com.beanit.openiec61850.BdaInt16U;
import com.beanit.openiec61850.BdaInt32;
import com.beanit.openiec61850.BdaInt32U;
import com.beanit.openiec61850.BdaInt64;
import com.beanit.openiec61850.BdaInt8;
import com.beanit.openiec61850.BdaInt8U;
import com.beanit.openiec61850.BdaOctetString;
import com.beanit.openiec61850.BdaOptFlds;
import com.beanit.openiec61850.BdaQuality;
import com.beanit.openiec61850.BdaTapCommand;
import com.beanit.openiec61850.BdaTimestamp;
import com.beanit.openiec61850.BdaTriggerConditions;
import com.beanit.openiec61850.BdaUnicodeString;
import com.beanit.openiec61850.BdaVisibleString;
import com.beanit.openiec61850.Brcb;
import com.beanit.openiec61850.ConstructedDataAttribute;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.FcDataObject;
import com.beanit.openiec61850.FcModelNode;
import com.beanit.openiec61850.LogicalNode;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.ServiceError;
import com.beanit.openiec61850.Urcb;
import com.beanit.openiec61850.internal.mms.asn1.ConfirmedServiceResponse;
import com.beanit.openiec61850.internal.mms.asn1.GetVariableAccessAttributesResponse;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;
import com.beanit.openiec61850.internal.mms.asn1.TypeSpecification;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

final class DataDefinitionResParser {
    DataDefinitionResParser() {
    }

    static LogicalNode parseGetDataDefinitionResponse(ConfirmedServiceResponse confirmedServiceResponse, ObjectReference lnRef) throws ServiceError {
        if (confirmedServiceResponse.getGetVariableAccessAttributes() == null) {
            throw new ServiceError(11, "decodeGetDataDefinitionResponse: Error decoding GetDataDefinitionResponsePdu");
        }
        GetVariableAccessAttributesResponse varAccAttrs = confirmedServiceResponse.getGetVariableAccessAttributes();
        TypeDescription typeSpec = varAccAttrs.getTypeDescription();
        if (typeSpec.getStructure() == null) {
            throw new ServiceError(11, "decodeGetDataDefinitionResponse: Error decoding GetDataDefinitionResponsePdu");
        }
        TypeDescription.Structure.Components structure = typeSpec.getStructure().getComponents();
        LinkedList<FcDataObject> fcDataObjects = new LinkedList<FcDataObject>();
        for (TypeDescription.Structure.Components.SEQUENCE fcComponent : structure.getSEQUENCE()) {
            if (fcComponent.getComponentName() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            if (fcComponent.getComponentType().getTypeDescription().getStructure() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            String fcString = fcComponent.getComponentName().toString();
            if (fcString.equals("LG") || fcString.equals("GO") || fcString.equals("GS") || fcString.equals("MS") || fcString.equals("US")) continue;
            Fc fc = Fc.fromString(fcComponent.getComponentName().toString());
            TypeDescription.Structure.Components subStructure = fcComponent.getComponentType().getTypeDescription().getStructure().getComponents();
            fcDataObjects.addAll(DataDefinitionResParser.getFcDataObjectsFromSubStructure(lnRef, fc, subStructure));
        }
        LogicalNode ln = new LogicalNode(lnRef, fcDataObjects);
        return ln;
    }

    private static List<FcDataObject> getFcDataObjectsFromSubStructure(ObjectReference lnRef, Fc fc, TypeDescription.Structure.Components components) throws ServiceError {
        List<TypeDescription.Structure.Components.SEQUENCE> structComponents = components.getSEQUENCE();
        ArrayList<FcDataObject> dataObjects = new ArrayList<FcDataObject>(structComponents.size());
        for (TypeDescription.Structure.Components.SEQUENCE doComp : structComponents) {
            if (doComp.getComponentName() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            if (doComp.getComponentType().getTypeDescription() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            ObjectReference doRef = new ObjectReference(lnRef + "." + doComp.getComponentName().toString());
            List<FcModelNode> children = DataDefinitionResParser.getDoSubModelNodesFromSubStructure(doRef, fc, doComp.getComponentType().getTypeDescription().getStructure().getComponents());
            if (fc == Fc.RP) {
                dataObjects.add(new Urcb(doRef, children));
                continue;
            }
            if (fc == Fc.BR) {
                dataObjects.add(new Brcb(doRef, children));
                continue;
            }
            dataObjects.add(new FcDataObject(doRef, fc, children));
        }
        return dataObjects;
    }

    private static List<FcModelNode> getDoSubModelNodesFromSubStructure(ObjectReference parentRef, Fc fc, TypeDescription.Structure.Components structure) throws ServiceError {
        List<TypeDescription.Structure.Components.SEQUENCE> structComponents = structure.getSEQUENCE();
        ArrayList<FcModelNode> dataObjects = new ArrayList<FcModelNode>(structComponents.size());
        for (TypeDescription.Structure.Components.SEQUENCE component : structComponents) {
            if (component.getComponentName() == null) {
                throw new ServiceError(5, "Error decoding GetDataDefinitionResponsePdu");
            }
            String childName = component.getComponentName().toString();
            dataObjects.add(DataDefinitionResParser.getModelNodesFromTypeSpecification(new ObjectReference(parentRef + "." + childName), fc, component.getComponentType()));
        }
        return dataObjects;
    }

    private static FcModelNode getModelNodesFromTypeSpecification(ObjectReference ref, Fc fc, TypeSpecification mmsTypeSpec) throws ServiceError {
        if (mmsTypeSpec.getTypeDescription().getArray() != null) {
            int numArrayElements = mmsTypeSpec.getTypeDescription().getArray().getNumberOfElements().intValue();
            ArrayList<FcModelNode> arrayChildren = new ArrayList<FcModelNode>(numArrayElements);
            for (int i = 0; i < numArrayElements; ++i) {
                arrayChildren.add(DataDefinitionResParser.getModelNodesFromTypeSpecification(new ObjectReference(ref + "(" + i + ")"), fc, mmsTypeSpec.getTypeDescription().getArray().getElementType()));
            }
            return new Array(ref, fc, arrayChildren);
        }
        if (mmsTypeSpec.getTypeDescription().getStructure() != null) {
            List<FcModelNode> children = DataDefinitionResParser.getDoSubModelNodesFromSubStructure(ref, fc, mmsTypeSpec.getTypeDescription().getStructure().getComponents());
            return new ConstructedDataAttribute(ref, fc, children);
        }
        BasicDataAttribute bt = DataDefinitionResParser.convertMmsBasicTypeSpec(ref, fc, mmsTypeSpec.getTypeDescription());
        if (bt == null) {
            throw new ServiceError(5, "decodeGetDataDefinitionResponse: Unknown data type received " + ref);
        }
        return bt;
    }

    private static BasicDataAttribute convertMmsBasicTypeSpec(ObjectReference ref, Fc fc, TypeDescription mmsTypeSpec) throws ServiceError {
        if (mmsTypeSpec.getBool() != null) {
            return new BdaBoolean(ref, fc, null, false, false);
        }
        if (mmsTypeSpec.getBitString() != null) {
            int bitStringMaxLength = Math.abs(mmsTypeSpec.getBitString().intValue());
            if (bitStringMaxLength == 13) {
                return new BdaQuality(ref, fc, null, false);
            }
            if (bitStringMaxLength == 10) {
                return new BdaOptFlds(ref, fc);
            }
            if (bitStringMaxLength == 6) {
                return new BdaTriggerConditions(ref, fc);
            }
            if (bitStringMaxLength == 2) {
                if (fc == Fc.CO) {
                    if (ref.getName().charAt(1) == 't') {
                        return new BdaTapCommand(ref, fc, null, false, false);
                    }
                    return new BdaCheck(ref);
                }
                return new BdaDoubleBitPos(ref, fc, null, false, false);
            }
            return null;
        }
        if (mmsTypeSpec.getInteger() != null) {
            switch (mmsTypeSpec.getInteger().intValue()) {
                case 8: {
                    return new BdaInt8(ref, fc, null, false, false);
                }
                case 16: {
                    return new BdaInt16(ref, fc, null, false, false);
                }
                case 32: {
                    return new BdaInt32(ref, fc, null, false, false);
                }
                case 64: {
                    return new BdaInt64(ref, fc, null, false, false);
                }
                case 128: {
                    return new BdaInt128(ref, fc, null, false, false);
                }
            }
        } else if (mmsTypeSpec.getUnsigned() != null) {
            switch (mmsTypeSpec.getUnsigned().intValue()) {
                case 8: {
                    return new BdaInt8U(ref, fc, null, false, false);
                }
                case 16: {
                    return new BdaInt16U(ref, fc, null, false, false);
                }
                case 32: {
                    return new BdaInt32U(ref, fc, null, false, false);
                }
            }
        } else {
            if (mmsTypeSpec.getFloatingPoint() != null) {
                int floatSize = mmsTypeSpec.getFloatingPoint().getFormatWidth().intValue();
                if (floatSize == 32) {
                    return new BdaFloat32(ref, fc, null, false, false);
                }
                if (floatSize == 64) {
                    return new BdaFloat64(ref, fc, null, false, false);
                }
                throw new ServiceError(5, "FLOAT of size: " + floatSize + " is not supported.");
            }
            if (mmsTypeSpec.getOctetString() != null) {
                int stringSize = mmsTypeSpec.getOctetString().intValue();
                if (stringSize > 255 || stringSize < -255) {
                    throw new ServiceError(5, "OCTET_STRING of size: " + stringSize + " is not supported.");
                }
                return new BdaOctetString(ref, fc, null, Math.abs(stringSize), false, false);
            }
            if (mmsTypeSpec.getVisibleString() != null) {
                int stringSize = mmsTypeSpec.getVisibleString().intValue();
                if (stringSize > 255 || stringSize < -255) {
                    throw new ServiceError(5, "VISIBLE_STRING of size: " + stringSize + " is not supported.");
                }
                return new BdaVisibleString(ref, fc, null, Math.abs(stringSize), false, false);
            }
            if (mmsTypeSpec.getMMSString() != null) {
                int stringSize = mmsTypeSpec.getMMSString().intValue();
                if (stringSize > 255 || stringSize < -255) {
                    throw new ServiceError(5, "UNICODE_STRING of size: " + stringSize + " is not supported.");
                }
                return new BdaUnicodeString(ref, fc, null, Math.abs(stringSize), false, false);
            }
            if (mmsTypeSpec.getUtcTime() != null) {
                return new BdaTimestamp(ref, fc, null, false, false);
            }
            if (mmsTypeSpec.getBinaryTime() != null) {
                return new BdaEntryTime(ref, fc, null, false, false);
            }
        }
        return null;
    }
}

