/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.openiec61850.Array;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaBoolean;
import com.beanit.openiec61850.BdaCheck;
import com.beanit.openiec61850.BdaDoubleBitPos;
import com.beanit.openiec61850.BdaEntryTime;
import com.beanit.openiec61850.BdaFloat32;
import com.beanit.openiec61850.BdaFloat64;
import com.beanit.openiec61850.BdaInt128;
import com.beanit.openiec61850.BdaInt16;
import com.beanit.openiec61850.BdaInt16U;
import com.beanit.openiec61850.BdaInt32;
import com.beanit.openiec61850.BdaInt32U;
import com.beanit.openiec61850.BdaInt64;
import com.beanit.openiec61850.BdaInt8;
import com.beanit.openiec61850.BdaInt8U;
import com.beanit.openiec61850.BdaOctetString;
import com.beanit.openiec61850.BdaOptFlds;
import com.beanit.openiec61850.BdaQuality;
import com.beanit.openiec61850.BdaTapCommand;
import com.beanit.openiec61850.BdaTimestamp;
import com.beanit.openiec61850.BdaTriggerConditions;
import com.beanit.openiec61850.BdaUnicodeString;
import com.beanit.openiec61850.BdaVisibleString;
import com.beanit.openiec61850.Brcb;
import com.beanit.openiec61850.ConstructedDataAttribute;
import com.beanit.openiec61850.DataSet;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.FcDataObject;
import com.beanit.openiec61850.FcModelNode;
import com.beanit.openiec61850.LogicalDevice;
import com.beanit.openiec61850.LogicalNode;
import com.beanit.openiec61850.ModelNode;
import com.beanit.openiec61850.ObjectReference;
import com.beanit.openiec61850.Rcb;
import com.beanit.openiec61850.SclParseException;
import com.beanit.openiec61850.ServerModel;
import com.beanit.openiec61850.ServerSap;
import com.beanit.openiec61850.Urcb;
import com.beanit.openiec61850.internal.scl.AbstractDataAttribute;
import com.beanit.openiec61850.internal.scl.Bda;
import com.beanit.openiec61850.internal.scl.Da;
import com.beanit.openiec61850.internal.scl.DaType;
import com.beanit.openiec61850.internal.scl.Do;
import com.beanit.openiec61850.internal.scl.DoType;
import com.beanit.openiec61850.internal.scl.EnumType;
import com.beanit.openiec61850.internal.scl.EnumVal;
import com.beanit.openiec61850.internal.scl.LnSubDef;
import com.beanit.openiec61850.internal.scl.LnType;
import com.beanit.openiec61850.internal.scl.Sdo;
import com.beanit.openiec61850.internal.scl.TypeDefinitions;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SclParser {
    private final Map<String, DataSet> dataSetsMap = new HashMap<String, DataSet>();
    private final List<LnSubDef> dataSetDefs = new ArrayList<LnSubDef>();
    private TypeDefinitions typeDefinitions;
    private Document doc;
    private String iedName;
    private List<ServerModel> serverModels = new ArrayList<ServerModel>();
    private boolean useResvTmsAttributes = false;

    private SclParser() {
    }

    public static List<ServerModel> parse(InputStream is) throws SclParseException {
        SclParser sclParser = new SclParser();
        sclParser.parseStream(is);
        return sclParser.serverModels;
    }

    public static List<ServerModel> parse(String sclFilePath) throws SclParseException {
        try {
            return SclParser.parse(new FileInputStream(sclFilePath));
        }
        catch (FileNotFoundException e) {
            throw new SclParseException(e);
        }
    }

    private void parseStream(InputStream icdFileStream) throws SclParseException {
        this.typeDefinitions = new TypeDefinitions();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        try {
            this.doc = factory.newDocumentBuilder().parse(icdFileStream);
        }
        catch (Exception e) {
            throw new SclParseException(e);
        }
        Element rootNode = this.doc.getDocumentElement();
        if (!"SCL".equals(rootNode.getNodeName())) {
            throw new SclParseException("Root node in SCL file is not of type \"SCL\"");
        }
        this.readTypeDefinitions();
        NodeList iedList = this.doc.getElementsByTagName("IED");
        if (iedList.getLength() == 0) {
            throw new SclParseException("No IED section found!");
        }
        for (int z = 0; z < iedList.getLength(); ++z) {
            Node iedNode = iedList.item(z);
            this.useResvTmsAttributes = false;
            Node nameAttribute = iedNode.getAttributes().getNamedItem("name");
            this.iedName = nameAttribute.getNodeValue();
            if (this.iedName == null || this.iedName.length() == 0) {
                throw new SclParseException("IED must have a name!");
            }
            NodeList iedElements = iedNode.getChildNodes();
            for (int i = 0; i < iedElements.getLength(); ++i) {
                Node element = iedElements.item(i);
                String nodeName = element.getNodeName();
                if ("AccessPoint".equals(nodeName)) {
                    ServerSap serverSap = this.createAccessPoint(element);
                    if (serverSap == null) continue;
                    this.serverModels.add(serverSap.serverModel);
                    continue;
                }
                if (!"Services".equals(nodeName)) continue;
                NodeList servicesElements = element.getChildNodes();
                for (int j = 0; j < servicesElements.getLength(); ++j) {
                    Node resvTmsAttribute;
                    if (!"ReportSettings".equals(servicesElements.item(j).getNodeName()) || (resvTmsAttribute = servicesElements.item(j).getAttributes().getNamedItem("resvTms")) == null) continue;
                    this.useResvTmsAttributes = resvTmsAttribute.getNodeValue().equalsIgnoreCase("true");
                }
            }
        }
    }

    private void readTypeDefinitions() throws SclParseException {
        NodeList dttSections = this.doc.getElementsByTagName("DataTypeTemplates");
        if (dttSections.getLength() != 1) {
            throw new SclParseException("Only one DataTypeSection allowed");
        }
        Node dtt = dttSections.item(0);
        NodeList dataTypes = dtt.getChildNodes();
        for (int i = 0; i < dataTypes.getLength(); ++i) {
            Node element = dataTypes.item(i);
            String nodeName = element.getNodeName();
            if (nodeName.equals("LNodeType")) {
                this.typeDefinitions.putLNodeType(new LnType(element));
                continue;
            }
            if (nodeName.equals("DOType")) {
                this.typeDefinitions.putDOType(new DoType(element));
                continue;
            }
            if (nodeName.equals("DAType")) {
                this.typeDefinitions.putDAType(new DaType(element));
                continue;
            }
            if (!nodeName.equals("EnumType")) continue;
            this.typeDefinitions.putEnumType(new EnumType(element));
        }
    }

    private ServerSap createAccessPoint(Node iedServer) throws SclParseException {
        ServerSap serverSap = null;
        NodeList elements = iedServer.getChildNodes();
        for (int i = 0; i < elements.getLength(); ++i) {
            Node element = elements.item(i);
            if (!element.getNodeName().equals("Server")) continue;
            ServerModel server = this.createServerModel(element);
            Node namedItem = iedServer.getAttributes().getNamedItem("name");
            if (namedItem == null) {
                throw new SclParseException("AccessPoint has no name attribute!");
            }
            String name = namedItem.getNodeValue();
            serverSap = new ServerSap(102, 0, null, server, null);
            break;
        }
        return serverSap;
    }

    private ServerModel createServerModel(Node serverXMLNode) throws SclParseException {
        NodeList elements = serverXMLNode.getChildNodes();
        ArrayList<LogicalDevice> logicalDevices = new ArrayList<LogicalDevice>(elements.getLength());
        for (int i = 0; i < elements.getLength(); ++i) {
            Node element = elements.item(i);
            if (!element.getNodeName().equals("LDevice")) continue;
            logicalDevices.add(this.createNewLDevice(element));
        }
        ServerModel serverModel = new ServerModel(logicalDevices, null);
        for (LnSubDef dataSetDef : this.dataSetDefs) {
            DataSet dataSet = this.createDataSet(serverModel, dataSetDef.logicalNode, dataSetDef.defXmlNode);
            this.dataSetsMap.put(dataSet.getReferenceStr(), dataSet);
        }
        serverModel.addDataSets(this.dataSetsMap.values());
        return serverModel;
    }

    private LogicalDevice createNewLDevice(Node ldXmlNode) throws SclParseException {
        String inst = null;
        String ldName = null;
        NamedNodeMap attributes = ldXmlNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("inst")) {
                inst = node.getNodeValue();
                continue;
            }
            if (!nodeName.equals("ldName")) continue;
            ldName = node.getNodeValue();
        }
        if (inst == null) {
            throw new SclParseException("Required attribute \"inst\" in logical device not found!");
        }
        NodeList elements = ldXmlNode.getChildNodes();
        ArrayList<LogicalNode> logicalNodes = new ArrayList<LogicalNode>();
        String ref = ldName != null && ldName.length() != 0 ? ldName : this.iedName + inst;
        for (int i = 0; i < elements.getLength(); ++i) {
            Node element = elements.item(i);
            if (!element.getNodeName().equals("LN") && !element.getNodeName().equals("LN0")) continue;
            logicalNodes.add(this.createNewLogicalNode(element, ref));
        }
        LogicalDevice lDevice = new LogicalDevice(new ObjectReference(ref), logicalNodes);
        return lDevice;
    }

    private LogicalNode createNewLogicalNode(Node lnXmlNode, String parentRef) throws SclParseException {
        String inst = null;
        String lnClass = null;
        String lnType = null;
        String prefix = "";
        NamedNodeMap attributes = lnXmlNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            String nodeName = node.getNodeName();
            if (nodeName.equals("inst")) {
                inst = node.getNodeValue();
                continue;
            }
            if (nodeName.equals("lnType")) {
                lnType = node.getNodeValue();
                continue;
            }
            if (nodeName.equals("lnClass")) {
                lnClass = node.getNodeValue();
                continue;
            }
            if (!nodeName.equals("prefix")) continue;
            prefix = node.getNodeValue();
        }
        if (inst == null) {
            throw new SclParseException("Required attribute \"inst\" not found!");
        }
        if (lnType == null) {
            throw new SclParseException("Required attribute \"lnType\" not found!");
        }
        if (lnClass == null) {
            throw new SclParseException("Required attribute \"lnClass\" not found!");
        }
        String ref = parentRef + '/' + prefix + lnClass + inst;
        LnType lnTypeDef = this.typeDefinitions.getLNodeType(lnType);
        ArrayList<FcDataObject> dataObjects = new ArrayList<FcDataObject>();
        if (lnTypeDef == null) {
            throw new SclParseException("LNType " + lnType + " not defined!");
        }
        for (Do dobject : lnTypeDef.dos) {
            Node doiNodeFound = null;
            for (int i = 0; i < lnXmlNode.getChildNodes().getLength(); ++i) {
                NamedNodeMap doiAttributes;
                Node nameAttribute;
                Node childNode = lnXmlNode.getChildNodes().item(i);
                if (!"DOI".equals(childNode.getNodeName()) || (nameAttribute = (doiAttributes = childNode.getAttributes()).getNamedItem("name")) == null || !nameAttribute.getNodeValue().equals(dobject.getName())) continue;
                doiNodeFound = childNode;
            }
            dataObjects.addAll(this.createFcDataObjects(dobject.getName(), ref, dobject.getType(), doiNodeFound));
        }
        for (int i = 0; i < lnXmlNode.getChildNodes().getLength(); ++i) {
            Node childNode = lnXmlNode.getChildNodes().item(i);
            if (!"ReportControl".equals(childNode.getNodeName())) continue;
            dataObjects.addAll(this.createReportControlBlocks(childNode, ref));
        }
        LogicalNode lNode = new LogicalNode(new ObjectReference(ref), dataObjects);
        for (int i = 0; i < lnXmlNode.getChildNodes().getLength(); ++i) {
            Node childNode = lnXmlNode.getChildNodes().item(i);
            if (!"DataSet".equals(childNode.getNodeName())) continue;
            this.dataSetDefs.add(new LnSubDef(childNode, lNode));
        }
        return lNode;
    }

    private DataSet createDataSet(ServerModel serverModel, LogicalNode lNode, Node dsXmlNode) throws SclParseException {
        Node nameAttribute = dsXmlNode.getAttributes().getNamedItem("name");
        if (nameAttribute == null) {
            throw new SclParseException("DataSet must have a name");
        }
        String name = nameAttribute.getNodeValue();
        ArrayList<FcModelNode> dsMembers = new ArrayList<FcModelNode>();
        for (int i = 0; i < dsXmlNode.getChildNodes().getLength(); ++i) {
            String objectReference;
            Node fcdaXmlNode = dsXmlNode.getChildNodes().item(i);
            if (!"FCDA".equals(fcdaXmlNode.getNodeName())) continue;
            String ldInst = null;
            String prefix = "";
            String lnClass = null;
            String lnInst = "";
            String doName = "";
            String daName = "";
            Fc fc = null;
            NamedNodeMap attributes = fcdaXmlNode.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node node = attributes.item(j);
                String nodeName = node.getNodeName();
                if (nodeName.equals("ldInst")) {
                    ldInst = node.getNodeValue();
                    continue;
                }
                if (nodeName.equals("lnInst")) {
                    lnInst = node.getNodeValue();
                    continue;
                }
                if (nodeName.equals("lnClass")) {
                    lnClass = node.getNodeValue();
                    continue;
                }
                if (nodeName.equals("prefix")) {
                    prefix = node.getNodeValue();
                    continue;
                }
                if (nodeName.equals("doName")) {
                    doName = node.getNodeValue();
                    continue;
                }
                if (nodeName.equals("daName")) {
                    if (node.getNodeValue().isEmpty()) continue;
                    daName = "." + node.getNodeValue();
                    continue;
                }
                if (!nodeName.equals("fc") || (fc = Fc.fromString(node.getNodeValue())) != null) continue;
                throw new SclParseException("FCDA contains invalid FC: " + node.getNodeValue());
            }
            if (ldInst == null) {
                throw new SclParseException("Required attribute \"ldInst\" not found in FCDA: " + nameAttribute + "!");
            }
            if (lnClass == null) {
                throw new SclParseException("Required attribute \"lnClass\" not found in FCDA!");
            }
            if (fc == null) {
                throw new SclParseException("Required attribute \"fc\" not found in FCDA!");
            }
            if (!doName.isEmpty()) {
                objectReference = this.iedName + ldInst + "/" + prefix + lnClass + lnInst + "." + doName + daName;
                ModelNode fcdaNode = serverModel.findModelNode(objectReference, fc);
                if (fcdaNode == null) {
                    throw new SclParseException("Specified FCDA: " + objectReference + " in DataSet: " + nameAttribute + " not found in Model.");
                }
                dsMembers.add((FcModelNode)fcdaNode);
                continue;
            }
            objectReference = this.iedName + ldInst + "/" + prefix + lnClass + lnInst;
            ModelNode logicalNode = serverModel.findModelNode(objectReference, null);
            if (logicalNode == null) {
                throw new SclParseException("Specified FCDA: " + objectReference + " in DataSet: " + nameAttribute + " not found in Model.");
            }
            List<FcDataObject> fcDataObjects = ((LogicalNode)logicalNode).getChildren(fc);
            for (FcDataObject dataObj : fcDataObjects) {
                dsMembers.add(dataObj);
            }
        }
        DataSet dataSet = new DataSet(lNode.getReference().toString() + '.' + name, dsMembers, false);
        return dataSet;
    }

    private List<Rcb> createReportControlBlocks(Node xmlNode, String parentRef) throws SclParseException {
        Node nameAttribute;
        Fc fc = Fc.RP;
        NamedNodeMap rcbNodeAttributes = xmlNode.getAttributes();
        Node attribute = rcbNodeAttributes.getNamedItem("buffered");
        if (attribute != null && "true".equalsIgnoreCase(attribute.getNodeValue())) {
            fc = Fc.BR;
        }
        if ((nameAttribute = rcbNodeAttributes.getNamedItem("name")) == null) {
            throw new SclParseException("Report Control Block has no name attribute.");
        }
        int maxInstances = 1;
        for (int i = 0; i < xmlNode.getChildNodes().getLength(); ++i) {
            Node rptEnabledMaxAttr;
            Node childNode = xmlNode.getChildNodes().item(i);
            if (!"RptEnabled".equals(childNode.getNodeName()) || (rptEnabledMaxAttr = childNode.getAttributes().getNamedItem("max")) == null || (maxInstances = Integer.parseInt(rptEnabledMaxAttr.getNodeValue())) >= 1 && maxInstances <= 99) continue;
            throw new SclParseException("Report Control Block max instances should be between 1 and 99 but is: " + maxInstances);
        }
        ArrayList<Rcb> rcbInstances = new ArrayList<Rcb>(maxInstances);
        for (int z = 1; z <= maxInstances; ++z) {
            ObjectReference reportObjRef = maxInstances == 1 ? new ObjectReference(parentRef + "." + nameAttribute.getNodeValue()) : new ObjectReference(parentRef + "." + nameAttribute.getNodeValue() + String.format("%02d", z));
            BdaTriggerConditions trigOps = new BdaTriggerConditions(new ObjectReference(reportObjRef + ".TrgOps"), fc);
            BdaOptFlds optFields = new BdaOptFlds(new ObjectReference(reportObjRef + ".OptFlds"), fc);
            for (int i = 0; i < xmlNode.getChildNodes().getLength(); ++i) {
                Node rptEnabledMaxAttr;
                String nodeName;
                Node node;
                int j;
                NamedNodeMap attributes;
                Node childNode = xmlNode.getChildNodes().item(i);
                if (childNode.getNodeName().equals("TrgOps")) {
                    attributes = childNode.getAttributes();
                    if (attributes == null) continue;
                    for (j = 0; j < attributes.getLength(); ++j) {
                        node = attributes.item(j);
                        nodeName = node.getNodeName();
                        if ("dchg".equals(nodeName)) {
                            trigOps.setDataChange(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if ("qchg".equals(nodeName)) {
                            trigOps.setQualityChange(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if ("dupd".equals(nodeName)) {
                            trigOps.setDataUpdate(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if ("period".equals(nodeName)) {
                            trigOps.setIntegrity(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if (!"gi".equals(nodeName)) continue;
                        trigOps.setGeneralInterrogation(node.getNodeValue().equalsIgnoreCase("true"));
                    }
                    continue;
                }
                if ("OptFields".equals(childNode.getNodeName())) {
                    attributes = childNode.getAttributes();
                    if (attributes == null) continue;
                    for (j = 0; j < attributes.getLength(); ++j) {
                        node = attributes.item(j);
                        nodeName = node.getNodeName();
                        if ("seqNum".equals(nodeName)) {
                            optFields.setSequenceNumber(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if ("timeStamp".equals(nodeName)) {
                            optFields.setReportTimestamp(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if ("reasonCode".equals(nodeName)) {
                            optFields.setReasonForInclusion(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if ("dataSet".equals(nodeName)) {
                            optFields.setDataSetName(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if (nodeName.equals("bufOvfl")) {
                            optFields.setBufferOverflow(node.getNodeValue().equalsIgnoreCase("true"));
                            continue;
                        }
                        if (!nodeName.equals("entryID")) continue;
                        optFields.setEntryId(node.getNodeValue().equalsIgnoreCase("true"));
                    }
                    continue;
                }
                if (!"RptEnabled".equals(childNode.getNodeName()) || (rptEnabledMaxAttr = childNode.getAttributes().getNamedItem("max")) == null || (maxInstances = Integer.parseInt(rptEnabledMaxAttr.getNodeValue())) >= 1 && maxInstances <= 99) continue;
                throw new SclParseException("Report Control Block max instances should be between 1 and 99 but is: " + maxInstances);
            }
            if (fc == Fc.RP) {
                optFields.setEntryId(false);
                optFields.setBufferOverflow(false);
            }
            ArrayList<FcModelNode> children = new ArrayList<FcModelNode>();
            BdaVisibleString rptId = new BdaVisibleString(new ObjectReference(reportObjRef.toString() + ".RptID"), fc, "", 129, false, false);
            attribute = rcbNodeAttributes.getNamedItem("rptID");
            if (attribute != null) {
                rptId.setValue(attribute.getNodeValue().getBytes());
            } else {
                rptId.setValue(reportObjRef.toString());
            }
            children.add(rptId);
            children.add(new BdaBoolean(new ObjectReference(reportObjRef.toString() + ".RptEna"), fc, "", false, false));
            if (fc == Fc.RP) {
                children.add(new BdaBoolean(new ObjectReference(reportObjRef.toString() + ".Resv"), fc, "", false, false));
            }
            BdaVisibleString datSet = new BdaVisibleString(new ObjectReference(reportObjRef.toString() + ".DatSet"), fc, "", 129, false, false);
            attribute = xmlNode.getAttributes().getNamedItem("datSet");
            if (attribute != null) {
                String nodeValue = attribute.getNodeValue();
                String dataSetName = parentRef + "$" + nodeValue;
                datSet.setValue(dataSetName.getBytes());
            }
            children.add(datSet);
            BdaInt32U confRef = new BdaInt32U(new ObjectReference(reportObjRef.toString() + ".ConfRev"), fc, "", false, false);
            attribute = xmlNode.getAttributes().getNamedItem("confRev");
            if (attribute == null) {
                throw new SclParseException("Report Control Block does not contain mandatory attribute confRev");
            }
            confRef.setValue(Long.parseLong(attribute.getNodeValue()));
            children.add(confRef);
            children.add(optFields);
            BdaInt32U bufTm = new BdaInt32U(new ObjectReference(reportObjRef.toString() + ".BufTm"), fc, "", false, false);
            attribute = xmlNode.getAttributes().getNamedItem("bufTime");
            if (attribute != null) {
                bufTm.setValue(Long.parseLong(attribute.getNodeValue()));
            }
            children.add(bufTm);
            children.add(new BdaInt8U(new ObjectReference(reportObjRef.toString() + ".SqNum"), fc, "", false, false));
            children.add(trigOps);
            BdaInt32U intgPd = new BdaInt32U(new ObjectReference(reportObjRef.toString() + ".IntgPd"), fc, "", false, false);
            attribute = xmlNode.getAttributes().getNamedItem("intgPd");
            if (attribute != null) {
                intgPd.setValue(Long.parseLong(attribute.getNodeValue()));
            }
            children.add(intgPd);
            children.add(new BdaBoolean(new ObjectReference(reportObjRef.toString() + ".GI"), fc, "", false, false));
            Rcb rcb = null;
            if (fc == Fc.BR) {
                children.add(new BdaBoolean(new ObjectReference(reportObjRef.toString() + ".PurgeBuf"), fc, "", false, false));
                children.add(new BdaOctetString(new ObjectReference(reportObjRef.toString() + ".EntryID"), fc, "", 8, false, false));
                children.add(new BdaEntryTime(new ObjectReference(reportObjRef.toString() + ".TimeOfEntry"), fc, "", false, false));
                if (this.useResvTmsAttributes) {
                    children.add(new BdaInt16(new ObjectReference(reportObjRef.toString() + ".ResvTms"), fc, "", false, false));
                }
                children.add(new BdaOctetString(new ObjectReference(reportObjRef.toString() + ".Owner"), fc, "", 64, false, false));
                rcb = new Brcb(reportObjRef, children);
            } else {
                children.add(new BdaOctetString(new ObjectReference(reportObjRef.toString() + ".Owner"), fc, "", 64, false, false));
                rcb = new Urcb(reportObjRef, children);
            }
            rcbInstances.add(rcb);
        }
        return rcbInstances;
    }

    private List<FcDataObject> createFcDataObjects(String name, String parentRef, String doTypeID, Node doiNode) throws SclParseException {
        DoType doType = this.typeDefinitions.getDOType(doTypeID);
        if (doType == null) {
            throw new SclParseException("DO type " + doTypeID + " not defined!");
        }
        String ref = parentRef + '.' + name;
        ArrayList<FcModelNode> childNodes = new ArrayList<FcModelNode>();
        for (Da da : doType.das) {
            Node node = this.findINode(doiNode, da.getName());
            if (da.getCount() >= 1) {
                childNodes.add(this.createArrayOfDataAttributes(ref + '.' + da.getName(), da, node));
                continue;
            }
            childNodes.add(this.createDataAttribute(ref + '.' + da.getName(), da.getFc(), da, node, false, false, false));
        }
        for (Sdo sdo : doType.sdos) {
            Node node = this.findINode(doiNode, sdo.getName());
            childNodes.addAll(this.createFcDataObjects(sdo.getName(), ref, sdo.getType(), node));
        }
        LinkedHashMap subFCDataMap = new LinkedHashMap();
        for (Fc fc : Fc.values()) {
            subFCDataMap.put(fc, new LinkedList());
        }
        for (ModelNode modelNode : childNodes) {
            ((List)subFCDataMap.get((Object)((FcModelNode)modelNode).getFc())).add((FcModelNode)modelNode);
        }
        LinkedList<FcDataObject> linkedList = new LinkedList<FcDataObject>();
        ObjectReference objectReference = new ObjectReference(ref);
        for (Fc fc : Fc.values()) {
            if (((List)subFCDataMap.get((Object)fc)).size() <= 0) continue;
            linkedList.add(new FcDataObject(objectReference, fc, (List)subFCDataMap.get((Object)fc)));
        }
        return linkedList;
    }

    private Node findINode(Node iNode, String dattrName) {
        if (iNode == null) {
            return null;
        }
        for (int i = 0; i < iNode.getChildNodes().getLength(); ++i) {
            Node nameAttribute;
            Node childNode = iNode.getChildNodes().item(i);
            if (childNode.getAttributes() == null || (nameAttribute = childNode.getAttributes().getNamedItem("name")) == null || !nameAttribute.getNodeValue().equals(dattrName)) continue;
            return childNode;
        }
        return null;
    }

    private Array createArrayOfDataAttributes(String ref, Da dataAttribute, Node iXmlNode) throws SclParseException {
        Fc fc = dataAttribute.getFc();
        int size = dataAttribute.getCount();
        ArrayList<FcModelNode> arrayItems = new ArrayList<FcModelNode>();
        for (int i = 0; i < size; ++i) {
            arrayItems.add(this.createDataAttribute(ref + '(' + i + ')', fc, dataAttribute, iXmlNode, dataAttribute.isDchg(), dataAttribute.isDupd(), dataAttribute.isQchg()));
        }
        return new Array(new ObjectReference(ref), fc, arrayItems);
    }

    private FcModelNode createDataAttribute(String ref, Fc fc, AbstractDataAttribute dattr, Node iXmlNode, boolean dchg, boolean dupd, boolean qchg) throws SclParseException {
        BasicDataAttribute bda;
        String bType;
        if (dattr instanceof Da) {
            Da dataAttribute = (Da)dattr;
            dchg = dataAttribute.isDchg();
            dupd = dataAttribute.isDupd();
            qchg = dataAttribute.isQchg();
        }
        if ((bType = dattr.getbType()).equals("Struct")) {
            DaType datype = this.typeDefinitions.getDaType(dattr.getType());
            if (datype == null) {
                throw new SclParseException("DAType " + dattr.getbType() + " not declared!");
            }
            ArrayList<FcModelNode> subDataAttributes = new ArrayList<FcModelNode>();
            for (Bda bda2 : datype.bdas) {
                Node iNodeFound = this.findINode(iXmlNode, bda2.getName());
                subDataAttributes.add(this.createDataAttribute(ref + '.' + bda2.getName(), fc, bda2, iNodeFound, dchg, dupd, qchg));
            }
            return new ConstructedDataAttribute(new ObjectReference(ref), fc, subDataAttributes);
        }
        String val = null;
        String sAddr = null;
        if (iXmlNode != null) {
            NamedNodeMap attributeMap = iXmlNode.getAttributes();
            Node sAddrAttribute = attributeMap.getNamedItem("sAddr");
            if (sAddrAttribute != null) {
                sAddr = sAddrAttribute.getNodeValue();
            }
            NodeList elements = iXmlNode.getChildNodes();
            for (int i = 0; i < elements.getLength(); ++i) {
                Node node = elements.item(i);
                if (!node.getNodeName().equals("Val")) continue;
                val = node.getTextContent();
            }
            if (val == null) {
                val = dattr.value;
            }
        }
        if (bType.equals("BOOLEAN")) {
            bda = new BdaBoolean(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                if (val.equalsIgnoreCase("true") || val.equals("1")) {
                    ((BdaBoolean)bda).setValue(true);
                } else if (val.equalsIgnoreCase("false") || val.equals("0")) {
                    ((BdaBoolean)bda).setValue(false);
                } else {
                    throw new SclParseException("invalid boolean configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT8")) {
            bda = new BdaInt8(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt8)bda).setValue(Byte.parseByte(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT8 configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT16")) {
            bda = new BdaInt16(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt16)bda).setValue(Short.parseShort(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT16 configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT32")) {
            bda = new BdaInt32(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt32)bda).setValue(Integer.parseInt(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT32 configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT64")) {
            bda = new BdaInt64(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt64)bda).setValue(Long.parseLong(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT64 configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT128")) {
            bda = new BdaInt128(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt128)bda).setValue(Long.parseLong(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT128 configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT8U")) {
            bda = new BdaInt8U(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt8U)bda).setValue(Short.parseShort(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT8U configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT16U")) {
            bda = new BdaInt16U(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt16U)bda).setValue(Integer.parseInt(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT16U configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("INT32U")) {
            bda = new BdaInt32U(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaInt32U)bda).setValue(Long.parseLong(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid INT32U configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("FLOAT32")) {
            bda = new BdaFloat32(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaFloat32)bda).setFloat(Float.valueOf(Float.parseFloat(val)));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid FLOAT32 configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.equals("FLOAT64")) {
            bda = new BdaFloat64(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                try {
                    ((BdaFloat64)bda).setDouble(Double.parseDouble(val));
                }
                catch (NumberFormatException e) {
                    throw new SclParseException("invalid FLOAT64 configured value: " + val);
                }
            }
            return bda;
        }
        if (bType.startsWith("VisString")) {
            bda = new BdaVisibleString(new ObjectReference(ref), fc, sAddr, Integer.parseInt(dattr.getbType().substring(9)), dchg, dupd);
            if (val != null) {
                ((BdaVisibleString)bda).setValue(val.getBytes());
            }
            return bda;
        }
        if (bType.startsWith("Unicode")) {
            bda = new BdaUnicodeString(new ObjectReference(ref), fc, sAddr, Integer.parseInt(dattr.getbType().substring(7)), dchg, dupd);
            if (val != null) {
                ((BdaUnicodeString)bda).setValue(val.getBytes());
            }
            return bda;
        }
        if (bType.startsWith("Octet")) {
            bda = new BdaOctetString(new ObjectReference(ref), fc, sAddr, Integer.parseInt(dattr.getbType().substring(5)), dchg, dupd);
            if (val != null) {
                // empty if block
            }
            return bda;
        }
        if (bType.equals("Quality")) {
            return new BdaQuality(new ObjectReference(ref), fc, sAddr, qchg);
        }
        if (bType.equals("Check")) {
            return new BdaCheck(new ObjectReference(ref));
        }
        if (bType.equals("Dbpos")) {
            return new BdaDoubleBitPos(new ObjectReference(ref), fc, sAddr, dchg, dupd);
        }
        if (bType.equals("Tcmd")) {
            return new BdaTapCommand(new ObjectReference(ref), fc, sAddr, dchg, dupd);
        }
        if (bType.equals("OptFlds")) {
            return new BdaOptFlds(new ObjectReference(ref), fc);
        }
        if (bType.equals("TrgOps")) {
            return new BdaTriggerConditions(new ObjectReference(ref), fc);
        }
        if (bType.equals("EntryID")) {
            return new BdaOctetString(new ObjectReference(ref), fc, sAddr, 8, dchg, dupd);
        }
        if (bType.equals("EntryTime")) {
            return new BdaEntryTime(new ObjectReference(ref), fc, sAddr, dchg, dupd);
        }
        if (bType.equals("PhyComAddr")) {
            return new BdaOctetString(new ObjectReference(ref), fc, sAddr, 6, dchg, dupd);
        }
        if (bType.equals("Timestamp")) {
            bda = new BdaTimestamp(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                throw new SclParseException("parsing configured value for TIMESTAMP is not supported yet.");
            }
            return bda;
        }
        if (bType.equals("Enum")) {
            BasicDataAttribute bda3;
            String type = dattr.getType();
            if (type == null) {
                throw new SclParseException("The exact type of the enumeration is not set.");
            }
            EnumType enumType = this.typeDefinitions.getEnumType(type);
            if (enumType == null) {
                throw new SclParseException("Definition of enum type: " + type + " not found.");
            }
            if (enumType.max > 127 || enumType.min < -128) {
                bda3 = new BdaInt16(new ObjectReference(ref), fc, sAddr, dchg, dupd);
                if (val != null) {
                    for (EnumVal enumVal : enumType.getValues()) {
                        if (!val.equals(enumVal.getId())) continue;
                        ((BdaInt16)bda3).setValue((short)enumVal.getOrd());
                        return bda3;
                    }
                    throw new SclParseException("unknown enum value: " + val);
                }
                return bda3;
            }
            bda3 = new BdaInt8(new ObjectReference(ref), fc, sAddr, dchg, dupd);
            if (val != null) {
                for (EnumVal enumVal : enumType.getValues()) {
                    if (!val.equals(enumVal.getId())) continue;
                    ((BdaInt8)bda3).setValue((byte)enumVal.getOrd());
                    return bda3;
                }
                throw new SclParseException("unknown enum value: " + val);
            }
            return bda3;
        }
        if (bType.equals("ObjRef")) {
            bda = new BdaVisibleString(new ObjectReference(ref), fc, sAddr, 129, dchg, dupd);
            if (val != null) {
                ((BdaVisibleString)bda).setValue(val.getBytes());
            }
            return bda;
        }
        throw new SclParseException("Invalid bType: " + bType);
    }
}

