/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.jasn1.ber.ReverseByteArrayOutputStream;
import com.beanit.jasn1.ber.types.BerInteger;
import com.beanit.jasn1.ber.types.BerNull;
import com.beanit.jasn1.ber.types.string.BerVisibleString;
import com.beanit.josistack.AcseAssociation;
import com.beanit.josistack.ByteBufferInputStream;
import com.beanit.josistack.DecodingException;
import com.beanit.openiec61850.Array;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.BdaBoolean;
import com.beanit.openiec61850.BdaInt8;
import com.beanit.openiec61850.BdaOptFlds;
import com.beanit.openiec61850.BdaTriggerConditions;
import com.beanit.openiec61850.BdaVisibleString;
import com.beanit.openiec61850.DataSet;
import com.beanit.openiec61850.Fc;
import com.beanit.openiec61850.FcDataObject;
import com.beanit.openiec61850.FcModelNode;
import com.beanit.openiec61850.LogicalDevice;
import com.beanit.openiec61850.LogicalNode;
import com.beanit.openiec61850.ModelNode;
import com.beanit.openiec61850.Rcb;
import com.beanit.openiec61850.ServerModel;
import com.beanit.openiec61850.ServerSap;
import com.beanit.openiec61850.Urcb;
import com.beanit.openiec61850.internal.BerBoolean;
import com.beanit.openiec61850.internal.NamedDefaultThreadFactory;
import com.beanit.openiec61850.internal.mms.asn1.AccessResult;
import com.beanit.openiec61850.internal.mms.asn1.ConfirmedErrorPDU;
import com.beanit.openiec61850.internal.mms.asn1.ConfirmedRequestPDU;
import com.beanit.openiec61850.internal.mms.asn1.ConfirmedResponsePDU;
import com.beanit.openiec61850.internal.mms.asn1.ConfirmedServiceRequest;
import com.beanit.openiec61850.internal.mms.asn1.ConfirmedServiceResponse;
import com.beanit.openiec61850.internal.mms.asn1.Data;
import com.beanit.openiec61850.internal.mms.asn1.DataAccessError;
import com.beanit.openiec61850.internal.mms.asn1.DefineNamedVariableListRequest;
import com.beanit.openiec61850.internal.mms.asn1.DefineNamedVariableListResponse;
import com.beanit.openiec61850.internal.mms.asn1.DeleteNamedVariableListRequest;
import com.beanit.openiec61850.internal.mms.asn1.DeleteNamedVariableListResponse;
import com.beanit.openiec61850.internal.mms.asn1.GetNameListRequest;
import com.beanit.openiec61850.internal.mms.asn1.GetNameListResponse;
import com.beanit.openiec61850.internal.mms.asn1.GetNamedVariableListAttributesResponse;
import com.beanit.openiec61850.internal.mms.asn1.GetVariableAccessAttributesRequest;
import com.beanit.openiec61850.internal.mms.asn1.GetVariableAccessAttributesResponse;
import com.beanit.openiec61850.internal.mms.asn1.Identifier;
import com.beanit.openiec61850.internal.mms.asn1.InitiateRequestPDU;
import com.beanit.openiec61850.internal.mms.asn1.InitiateResponsePDU;
import com.beanit.openiec61850.internal.mms.asn1.Integer16;
import com.beanit.openiec61850.internal.mms.asn1.Integer32;
import com.beanit.openiec61850.internal.mms.asn1.Integer8;
import com.beanit.openiec61850.internal.mms.asn1.MMSpdu;
import com.beanit.openiec61850.internal.mms.asn1.ObjectName;
import com.beanit.openiec61850.internal.mms.asn1.ParameterSupportOptions;
import com.beanit.openiec61850.internal.mms.asn1.ReadRequest;
import com.beanit.openiec61850.internal.mms.asn1.ReadResponse;
import com.beanit.openiec61850.internal.mms.asn1.ServiceError;
import com.beanit.openiec61850.internal.mms.asn1.ServiceSupportOptions;
import com.beanit.openiec61850.internal.mms.asn1.TypeDescription;
import com.beanit.openiec61850.internal.mms.asn1.TypeSpecification;
import com.beanit.openiec61850.internal.mms.asn1.Unsigned32;
import com.beanit.openiec61850.internal.mms.asn1.VariableAccessSpecification;
import com.beanit.openiec61850.internal.mms.asn1.VariableDefs;
import com.beanit.openiec61850.internal.mms.asn1.WriteRequest;
import com.beanit.openiec61850.internal.mms.asn1.WriteResponse;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ServerAssociation {
    private static final Logger logger = LoggerFactory.getLogger(ServerAssociation.class);
    private static final WriteResponse.CHOICE writeSuccess = new WriteResponse.CHOICE();
    private static String[] mmsFcs = new String[]{"MX", "ST", "CO", "CF", "DC", "SP", "SG", "RP", "LG", "BR", "GO", "GS", "SV", "SE", "EX", "SR", "OR", "BL"};
    final ServerModel serverModel;
    private final ServerSap serverSap;
    private final ReverseByteArrayOutputStream reverseOStream = new ReverseByteArrayOutputStream(500, true);
    ScheduledExecutorService executor = null;
    HashMap<String, DataSet> nonPersistentDataSets = new HashMap();
    List<FcModelNode> selects = new ArrayList<FcModelNode>();
    List<Urcb> rsvdURCBs = new ArrayList<Urcb>();
    private AcseAssociation acseAssociation = null;
    private int negotiatedMaxPduSize;
    private ByteBuffer pduBuffer;
    private boolean insertRef;
    private String continueAfter;

    public ServerAssociation(ServerSap serverSap) {
        this.serverSap = serverSap;
        this.serverModel = serverSap.serverModel;
        this.executor = Executors.newScheduledThreadPool(2, new NamedDefaultThreadFactory("openiec61850-server-connection"));
    }

    private static void insertMmsRef(ModelNode node, List<String> mmsRefs, String parentRef) {
        String ref = parentRef + '$' + node.getName();
        mmsRefs.add(ref);
        if (!(node instanceof Array)) {
            for (ModelNode childNode : node) {
                ServerAssociation.insertMmsRef(childNode, mmsRefs, ref);
            }
        }
    }

    private static String convertToDataSetReference(ObjectName mmsObjectName) {
        if (mmsObjectName.getDomainSpecific() != null) {
            return mmsObjectName.getDomainSpecific().getDomainID().toString() + "/" + mmsObjectName.getDomainSpecific().getItemID().toString().replace('$', '.');
        }
        if (mmsObjectName.getAaSpecific() != null) {
            return mmsObjectName.getAaSpecific().toString();
        }
        return null;
    }

    public void handleNewAssociation(AcseAssociation acseAssociation, ByteBuffer associationRequest) {
        this.acseAssociation = acseAssociation;
        try {
            this.associate(acseAssociation, associationRequest);
        }
        catch (IOException e) {
            logger.warn("Error during association build up", (Throwable)e);
            return;
        }
        this.handleConnection();
    }

    private void associate(AcseAssociation acseAssociation, ByteBuffer associationRequest) throws IOException {
        MMSpdu mmsPdu = new MMSpdu();
        mmsPdu.decode(new ByteBufferInputStream(associationRequest), null);
        MMSpdu initiateResponseMmsPdu = this.constructAssociationResponsePdu(mmsPdu.getInitiateRequestPDU());
        initiateResponseMmsPdu.encode((OutputStream)this.reverseOStream);
        acseAssociation.accept(this.reverseOStream.getByteBuffer());
    }

    private MMSpdu constructAssociationResponsePdu(InitiateRequestPDU associationRequestMMSpdu) {
        int proposedDataStructureNestingLevel;
        int proposedMaxServOutstandingCalled;
        int negotiatedMaxServOutstandingCalled;
        int proposedMaxServOutstandingCalling;
        int negotiatedMaxServOutstandingCalling;
        int proposedMaxMmsPduSize;
        this.negotiatedMaxPduSize = this.serverSap.getMaxMmsPduSize();
        if (associationRequestMMSpdu.getLocalDetailCalling() != null && this.negotiatedMaxPduSize > (proposedMaxMmsPduSize = associationRequestMMSpdu.getLocalDetailCalling().intValue()) && proposedMaxMmsPduSize >= 64) {
            this.negotiatedMaxPduSize = proposedMaxMmsPduSize;
        }
        if ((negotiatedMaxServOutstandingCalling = this.serverSap.getProposedMaxServOutstandingCalling()) > (proposedMaxServOutstandingCalling = associationRequestMMSpdu.getProposedMaxServOutstandingCalling().intValue()) && proposedMaxServOutstandingCalling > 0) {
            negotiatedMaxServOutstandingCalling = proposedMaxServOutstandingCalling;
        }
        if ((negotiatedMaxServOutstandingCalled = this.serverSap.getProposedMaxServOutstandingCalled()) > (proposedMaxServOutstandingCalled = associationRequestMMSpdu.getProposedMaxServOutstandingCalled().intValue()) && proposedMaxServOutstandingCalled > 0) {
            negotiatedMaxServOutstandingCalled = proposedMaxServOutstandingCalled;
        }
        int negotiatedDataStructureNestingLevel = this.serverSap.getProposedDataStructureNestingLevel();
        if (associationRequestMMSpdu.getProposedDataStructureNestingLevel() != null && negotiatedDataStructureNestingLevel > (proposedDataStructureNestingLevel = associationRequestMMSpdu.getProposedDataStructureNestingLevel().intValue())) {
            negotiatedDataStructureNestingLevel = proposedDataStructureNestingLevel;
        }
        this.pduBuffer = ByteBuffer.allocate(this.negotiatedMaxPduSize + 500);
        byte[] negotiatedParameterCbbBitString = this.serverSap.cbbBitString;
        byte[] servicesSupportedCalledBitString = this.serverSap.servicesSupportedCalled;
        InitiateResponsePDU.InitResponseDetail initRespDetail = new InitiateResponsePDU.InitResponseDetail();
        initRespDetail.setNegotiatedVersionNumber(new Integer16(1L));
        initRespDetail.setNegotiatedParameterCBB(new ParameterSupportOptions(negotiatedParameterCbbBitString, negotiatedParameterCbbBitString.length * 8 - 5));
        initRespDetail.setServicesSupportedCalled(new ServiceSupportOptions(servicesSupportedCalledBitString, servicesSupportedCalledBitString.length * 8 - 3));
        InitiateResponsePDU initRespPdu = new InitiateResponsePDU();
        initRespPdu.setLocalDetailCalled(new Integer32(this.negotiatedMaxPduSize));
        initRespPdu.setNegotiatedMaxServOutstandingCalling(new Integer16(negotiatedMaxServOutstandingCalling));
        initRespPdu.setNegotiatedMaxServOutstandingCalled(new Integer16(negotiatedMaxServOutstandingCalled));
        initRespPdu.setNegotiatedDataStructureNestingLevel(new Integer8(negotiatedDataStructureNestingLevel));
        initRespPdu.setInitResponseDetail(initRespDetail);
        MMSpdu initiateResponseMMSpdu = new MMSpdu();
        initiateResponseMMSpdu.setInitiateResponsePDU(initRespPdu);
        return initiateResponseMMSpdu;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleConnection() {
        MMSpdu mmsRequestPdu;
        while ((mmsRequestPdu = this.listenForMmsRequest(this.acseAssociation)) != null) {
            ConfirmedRequestPDU confirmedRequestPdu = mmsRequestPdu.getConfirmedRequestPDU();
            if (confirmedRequestPdu.getInvokeID() == null) {
                logger.warn("Got unexpected MMS PDU or no invokeID");
                continue;
            }
            int invokeId = confirmedRequestPdu.getInvokeID().intValue();
            try {
                if (confirmedRequestPdu.getService() == null) {
                    throw new com.beanit.openiec61850.ServiceError(11, "Got an invalid MMS packet: confirmedServiceRequest empty");
                }
                ConfirmedServiceRequest confirmedServiceRequest = confirmedRequestPdu.getService();
                ConfirmedServiceResponse confirmedServiceResponse = new ConfirmedServiceResponse();
                if (confirmedServiceRequest.getGetNameList() != null) {
                    GetNameListRequest getNameListRequest = confirmedServiceRequest.getGetNameList();
                    GetNameListResponse response = null;
                    if (getNameListRequest.getObjectClass().getBasicObjectClass() == null) {
                        throw new com.beanit.openiec61850.ServiceError(11, "Got an invalid MMS packet: ObjectClass was not selected in GetNameList request");
                    }
                    long basicObjectClass = getNameListRequest.getObjectClass().getBasicObjectClass().longValue();
                    if (basicObjectClass == 9L) {
                        logger.debug("Got a GetServerDirectory (MMS GetNameList[DOMAIN]) request");
                        response = this.handleGetServerDirectoryRequest(getNameListRequest);
                    } else if (basicObjectClass == 0L) {
                        logger.debug("Got a Get{LD|LN}Directory (MMS GetNameList[NAMED_VARIABLE]) request");
                        response = this.handleGetDirectoryRequest(getNameListRequest);
                    } else {
                        if (basicObjectClass != 2L) throw new com.beanit.openiec61850.ServiceError(12, "Unable to handle Get directory request for basic object class: " + basicObjectClass);
                        logger.debug("Got a GetLogicalNodeDirectory[DataSet] (MMS GetNameList[NAMED_VARIABLE_LIST]) request");
                        response = this.handleGetDataSetNamesRequest(getNameListRequest);
                    }
                    confirmedServiceResponse.setGetNameList(response);
                } else if (confirmedServiceRequest.getGetVariableAccessAttributes() != null) {
                    logger.debug("Got a GetDataDirectory/GetDataDefinition (MMS GetVariableAccessAttributes) request");
                    GetVariableAccessAttributesResponse getVariableAccessAttributesResponse = this.handleGetVariableAccessAttributesRequest(confirmedServiceRequest.getGetVariableAccessAttributes());
                    confirmedServiceResponse.setGetVariableAccessAttributes(getVariableAccessAttributesResponse);
                } else if (confirmedServiceRequest.getRead() != null) {
                    ReadResponse readResponse = this.handleGetDataValuesRequest(confirmedServiceRequest.getRead());
                    confirmedServiceResponse.setRead(readResponse);
                } else if (confirmedServiceRequest.getWrite() != null) {
                    logger.debug("Got a Write request");
                    WriteResponse writeResponse = this.handleSetDataValuesRequest(confirmedServiceRequest.getWrite());
                    confirmedServiceResponse.setWrite(writeResponse);
                } else if (confirmedServiceRequest.getDefineNamedVariableList() != null) {
                    logger.debug("Got a CreateDataSet request");
                    DefineNamedVariableListResponse defineNamedVariableListResponse = this.handleCreateDataSetRequest(confirmedServiceRequest.getDefineNamedVariableList());
                    confirmedServiceResponse.setDefineNamedVariableList(defineNamedVariableListResponse);
                } else if (confirmedServiceRequest.getGetNamedVariableListAttributes() != null) {
                    logger.debug("Got a GetDataSetDirectory request");
                    GetNamedVariableListAttributesResponse getNamedVariableListAttributesResponse = this.handleGetDataSetDirectoryRequest(confirmedServiceRequest.getGetNamedVariableListAttributes());
                    confirmedServiceResponse.setGetNamedVariableListAttributes(getNamedVariableListAttributesResponse);
                } else {
                    if (confirmedServiceRequest.getDeleteNamedVariableList() == null) throw new com.beanit.openiec61850.ServiceError(11, "invalid MMS packet: unknown request type.");
                    logger.debug("Got a DeleteDataSet request");
                    DeleteNamedVariableListResponse deleteNamedVariableListResponse = this.handleDeleteDataSetRequest(confirmedServiceRequest.getDeleteNamedVariableList());
                    confirmedServiceResponse.setDeleteNamedVariableList(deleteNamedVariableListResponse);
                }
                ConfirmedResponsePDU confirmedResponsePDU = new ConfirmedResponsePDU();
                confirmedResponsePDU.setInvokeID(confirmedRequestPdu.getInvokeID());
                confirmedResponsePDU.setService(confirmedServiceResponse);
                MMSpdu mmsResponsePdu = new MMSpdu();
                mmsResponsePdu.setConfirmedResponsePDU(confirmedResponsePDU);
                if (this.sendAnMmsPdu(mmsResponsePdu)) continue;
                return;
            }
            catch (com.beanit.openiec61850.ServiceError e) {
                logger.warn(e.getMessage());
                if (!this.sendAnMmsPdu(this.createServiceErrorResponse(e, invokeId))) return;
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanUpConnection() {
        ServerModel serverModel = this.serverModel;
        synchronized (serverModel) {
            for (FcModelNode selectedCdo : this.selects) {
                selectedCdo.deselect();
            }
            Iterator<FcModelNode> iterator = this.rsvdURCBs.iterator();
            while (iterator.hasNext()) {
                Urcb rsvdUrcb;
                Urcb urcb = rsvdUrcb = (Urcb)iterator.next();
                synchronized (urcb) {
                    if (rsvdUrcb.enabled) {
                        rsvdUrcb.disable();
                    }
                    rsvdUrcb.reserved = null;
                    rsvdUrcb.getResv().setValue(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean sendAnMmsPdu(MMSpdu mmsResponsePdu) {
        ReverseByteArrayOutputStream reverseByteArrayOutputStream = this.reverseOStream;
        synchronized (reverseByteArrayOutputStream) {
            this.reverseOStream.reset();
            try {
                mmsResponsePdu.encode((OutputStream)this.reverseOStream);
            }
            catch (IOException e1) {
                logger.error("IOException while encoding MMS PDU. Closing association.", (Throwable)e1);
                return false;
            }
            try {
                this.acseAssociation.send(this.reverseOStream.getByteBuffer());
            }
            catch (IOException e) {
                logger.warn("IOException while sending MMS PDU. Closing association.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    private MMSpdu listenForMmsRequest(AcseAssociation acseAssociation) {
        MMSpdu mmsRequestPdu;
        while (true) {
            byte[] buffer;
            mmsRequestPdu = null;
            this.pduBuffer.clear();
            try {
                buffer = acseAssociation.receive(this.pduBuffer);
            }
            catch (EOFException e) {
                logger.debug("Connection was closed by client.");
                return null;
            }
            catch (SocketTimeoutException e) {
                logger.warn("Message fragment timeout occured while receiving request. Closing association.", (Throwable)e);
                return null;
            }
            catch (IOException e) {
                logger.warn("IOException at lower layers while listening for incoming request. Closing association.", (Throwable)e);
                return null;
            }
            catch (DecodingException e) {
                logger.error("Error decoding request at OSI layers.", (Throwable)e);
                continue;
            }
            catch (TimeoutException e) {
                logger.error("Illegal state: message timeout while receiving request though this timeout should 0 and never be thrown", (Throwable)e);
                return null;
            }
            mmsRequestPdu = new MMSpdu();
            try {
                mmsRequestPdu.decode(new ByteArrayInputStream(buffer), null);
            }
            catch (IOException e) {
                logger.warn("IOException decoding received MMS request PDU.", (Throwable)e);
                continue;
            }
            if (mmsRequestPdu.getConfirmedRequestPDU() != null) break;
            if (mmsRequestPdu.getConcludeRequestPDU() != null) {
                logger.debug("Got Conclude request, will close connection");
                return null;
            }
            logger.warn("Got unexpected MMS PDU, will ignore it");
        }
        return mmsRequestPdu;
    }

    private MMSpdu createServiceErrorResponse(com.beanit.openiec61850.ServiceError e, int invokeId) {
        ServiceError.ErrorClass errClass = new ServiceError.ErrorClass();
        switch (e.getErrorCode()) {
            case 0: {
                break;
            }
            case 1: {
                errClass.setAccess(new BerInteger((long)e.getErrorCode()));
                break;
            }
            case 2: {
                errClass.setDefinition(new BerInteger((long)e.getErrorCode()));
                break;
            }
            case 3: {
                errClass.setAccess(new BerInteger((long)e.getErrorCode()));
                break;
            }
            case 4: {
                errClass.setOthers(new BerInteger((long)e.getErrorCode()));
                break;
            }
            case 8: {
                errClass.setFile(new BerInteger(2L));
                break;
            }
            case 10: {
                errClass.setFile(new BerInteger(4L));
                break;
            }
            default: {
                errClass.setOthers(new BerInteger((long)e.getErrorCode()));
            }
        }
        ServiceError asn1ServiceError = null;
        asn1ServiceError = new ServiceError();
        asn1ServiceError.setErrorClass(errClass);
        asn1ServiceError.setAdditionalDescription(new BerVisibleString(e.getMessage()));
        ConfirmedErrorPDU confirmedErrorPDU = new ConfirmedErrorPDU();
        confirmedErrorPDU.setInvokeID(new Unsigned32(invokeId));
        confirmedErrorPDU.setServiceError(asn1ServiceError);
        MMSpdu mmsPdu = new MMSpdu();
        mmsPdu.setConfirmedErrorPDU(confirmedErrorPDU);
        return mmsPdu;
    }

    private GetNameListResponse handleGetServerDirectoryRequest(GetNameListRequest getNameListRequest) throws com.beanit.openiec61850.ServiceError {
        GetNameListResponse.ListOfIdentifier listOfIdentifier = new GetNameListResponse.ListOfIdentifier();
        List<Identifier> identifiers = listOfIdentifier.getIdentifier();
        for (ModelNode ld : this.serverModel) {
            identifiers.add(new Identifier(ld.getName().getBytes()));
        }
        GetNameListResponse getNameListResponse = new GetNameListResponse();
        getNameListResponse.setListOfIdentifier(listOfIdentifier);
        getNameListResponse.setMoreFollows(new BerBoolean(false));
        return getNameListResponse;
    }

    private GetNameListResponse handleGetDirectoryRequest(GetNameListRequest getNameListRequest) throws com.beanit.openiec61850.ServiceError {
        if (getNameListRequest.getObjectScope().getAaSpecific() != null || getNameListRequest.getObjectScope().getVmdSpecific() != null) {
            GetNameListResponse.ListOfIdentifier listOfIden = new GetNameListResponse.ListOfIdentifier();
            listOfIden.getIdentifier();
            GetNameListResponse getNameListResponse = new GetNameListResponse();
            getNameListResponse.setListOfIdentifier(listOfIden);
            getNameListResponse.setMoreFollows(new BerBoolean(false));
            return getNameListResponse;
        }
        String mmsDomainId = getNameListRequest.getObjectScope().getDomainSpecific().toString();
        ModelNode logicalDeviceMn = this.serverModel.getChild(mmsDomainId);
        if (logicalDeviceMn == null) {
            throw new com.beanit.openiec61850.ServiceError(5, "Got an invalid MMS request: given Domain name in GetNameList request is not a Logical Device name");
        }
        LogicalDevice logicalDevice = (LogicalDevice)logicalDeviceMn;
        this.insertRef = true;
        if (getNameListRequest.getContinueAfter() != null) {
            this.continueAfter = getNameListRequest.getContinueAfter().toString();
            this.insertRef = false;
        }
        LinkedList<String> mmsReferences = new LinkedList<String>();
        for (ModelNode logicalNodeMn : logicalDevice) {
            LogicalNode logicalNode = (LogicalNode)logicalNodeMn;
            mmsReferences.add(logicalNode.getName());
            for (String mmsFC : mmsFcs) {
                List<FcDataObject> fcDataObjects;
                Fc fc = Fc.fromString(mmsFC);
                if (fc == null || (fcDataObjects = logicalNode.getChildren(fc)) == null) continue;
                mmsReferences.add(logicalNode.getName() + "$" + mmsFC);
                for (FcDataObject dataObject : fcDataObjects) {
                    ServerAssociation.insertMmsRef(dataObject, mmsReferences, logicalNode.getName() + "$" + mmsFC);
                }
            }
        }
        GetNameListResponse.ListOfIdentifier listOfIden = new GetNameListResponse.ListOfIdentifier();
        List<Identifier> identifiers = listOfIden.getIdentifier();
        int identifierSize = 0;
        boolean moreFollows = false;
        for (String mmsReference : mmsReferences) {
            if (this.insertRef) {
                if (identifierSize > this.negotiatedMaxPduSize - 200) {
                    moreFollows = true;
                    logger.debug(" ->maxMMSPduSize of " + this.negotiatedMaxPduSize + " Bytes reached");
                    break;
                }
                Identifier identifier = null;
                identifier = new Identifier(mmsReference.getBytes());
                identifiers.add(identifier);
                identifierSize += mmsReference.length() + 2;
                continue;
            }
            if (!mmsReference.equals(this.continueAfter)) continue;
            this.insertRef = true;
        }
        GetNameListResponse getNameListResponse = new GetNameListResponse();
        getNameListResponse.setListOfIdentifier(listOfIden);
        getNameListResponse.setMoreFollows(new BerBoolean(moreFollows));
        return getNameListResponse;
    }

    private GetVariableAccessAttributesResponse handleGetVariableAccessAttributesRequest(GetVariableAccessAttributesRequest getVariableAccessAttributesRequest) throws com.beanit.openiec61850.ServiceError {
        if (getVariableAccessAttributesRequest.getName() == null) {
            throw new com.beanit.openiec61850.ServiceError(11, "Got an invalid MMS packet: name is not selected in GetVariableAccessAttributesRequest");
        }
        ObjectName.DomainSpecific domainSpecific = getVariableAccessAttributesRequest.getName().getDomainSpecific();
        if (domainSpecific == null) {
            throw new com.beanit.openiec61850.ServiceError(11, "Got an invalid MMS packet: Domain specific is not selected in GetVariableAccessAttributesRequest");
        }
        ModelNode modelNode = this.serverModel.getChild(domainSpecific.getDomainID().toString());
        if (modelNode == null) {
            throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
        }
        String itemIdString = domainSpecific.getItemID().toString();
        int index1 = itemIdString.indexOf(36);
        LogicalNode logicalNode = null;
        if (index1 != -1) {
            logicalNode = (LogicalNode)modelNode.getChild(itemIdString.substring(0, index1));
            if (logicalNode == null) {
                throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
            }
            int index2 = itemIdString.indexOf(36, index1 + 2);
            if (index2 != -1) {
                ModelNode subNode;
                Fc fc = Fc.fromString(itemIdString.substring(index1 + 1, index2));
                if (fc == null) {
                    throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
                }
                index1 = itemIdString.indexOf(36, index2 + 2);
                if (index1 == -1) {
                    subNode = logicalNode.getChild(itemIdString.substring(index2 + 1), fc);
                    if (subNode == null) {
                        throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
                    }
                } else {
                    subNode = logicalNode.getChild(itemIdString.substring(index2 + 1, index1), fc);
                    if (subNode == null) {
                        throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
                    }
                    index2 = itemIdString.indexOf(36, index1 + 2);
                    while (index2 != -1) {
                        if ((subNode = subNode.getChild(itemIdString.substring(index1 + 1, index2))) == null) {
                            throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
                        }
                        index1 = index2;
                        index2 = itemIdString.indexOf(36, index1 + 2);
                    }
                    if ((subNode = subNode.getChild(itemIdString.substring(index1 + 1))) == null) {
                        throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
                    }
                }
                GetVariableAccessAttributesResponse getVariableAccessAttributesResponse = new GetVariableAccessAttributesResponse();
                getVariableAccessAttributesResponse.setMmsDeletable(new BerBoolean(false));
                getVariableAccessAttributesResponse.setTypeDescription(subNode.getMmsTypeSpec());
                return getVariableAccessAttributesResponse;
            }
            Fc fc = Fc.fromString(itemIdString.substring(index1 + 1));
            if (fc == null) {
                throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
            }
            List<FcDataObject> fcDataObjects = logicalNode.getChildren(fc);
            if (fcDataObjects == null || fcDataObjects.size() == 0) {
                throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
            }
            TypeDescription.Structure.Components comp = new TypeDescription.Structure.Components();
            List<TypeDescription.Structure.Components.SEQUENCE> doStructComponents = comp.getSEQUENCE();
            for (ModelNode modelNode2 : fcDataObjects) {
                TypeSpecification typeSpecification = new TypeSpecification();
                typeSpecification.setTypeDescription(modelNode2.getMmsTypeSpec());
                TypeDescription.Structure.Components.SEQUENCE structComponent = new TypeDescription.Structure.Components.SEQUENCE();
                structComponent.setComponentName(new Identifier(modelNode2.getName().getBytes()));
                structComponent.setComponentType(typeSpecification);
                doStructComponents.add(structComponent);
            }
            TypeDescription.Structure struct = new TypeDescription.Structure();
            struct.setComponents(comp);
            TypeDescription typeDescription = new TypeDescription();
            typeDescription.setStructure(struct);
            GetVariableAccessAttributesResponse getVariableAccessAttributesResponse = new GetVariableAccessAttributesResponse();
            getVariableAccessAttributesResponse.setMmsDeletable(new BerBoolean(false));
            getVariableAccessAttributesResponse.setTypeDescription(typeDescription);
            return getVariableAccessAttributesResponse;
        }
        logicalNode = (LogicalNode)modelNode.getChild(itemIdString);
        if (logicalNode == null) {
            throw new com.beanit.openiec61850.ServiceError(1, "GetVariableAccessAttributes (GetDataDefinition): no object with domainId " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getDomainID()) + " and ItemID " + (Object)((Object)getVariableAccessAttributesRequest.getName().getDomainSpecific().getItemID()) + " was found.");
        }
        TypeDescription.Structure.Components components = new TypeDescription.Structure.Components();
        List<TypeDescription.Structure.Components.SEQUENCE> structComponents = components.getSEQUENCE();
        for (String mmsFc : mmsFcs) {
            TypeSpecification typeSpecification;
            List<FcDataObject> fcDataObjects;
            Fc fc = Fc.fromString(mmsFc);
            if (fc == null || (fcDataObjects = logicalNode.getChildren(fc)) == null) continue;
            TypeDescription.Structure.Components comp = new TypeDescription.Structure.Components();
            List<TypeDescription.Structure.Components.SEQUENCE> doStructComponents = comp.getSEQUENCE();
            for (ModelNode modelNode3 : fcDataObjects) {
                typeSpecification = new TypeSpecification();
                typeSpecification.setTypeDescription(modelNode3.getMmsTypeSpec());
                TypeDescription.Structure.Components.SEQUENCE doStructComponent = new TypeDescription.Structure.Components.SEQUENCE();
                doStructComponent.setComponentName(new Identifier(modelNode3.getName().getBytes()));
                doStructComponent.setComponentType(typeSpecification);
                doStructComponents.add(doStructComponent);
            }
            TypeDescription.Structure struct = new TypeDescription.Structure();
            struct.setComponents(comp);
            TypeDescription typeDescription = new TypeDescription();
            typeDescription.setStructure(struct);
            typeSpecification = new TypeSpecification();
            typeSpecification.setTypeDescription(typeDescription);
            TypeDescription.Structure.Components.SEQUENCE structCom = new TypeDescription.Structure.Components.SEQUENCE();
            structCom.setComponentName(new Identifier(mmsFc.getBytes()));
            structCom.setComponentType(typeSpecification);
            structComponents.add(structCom);
        }
        TypeDescription.Structure struct = new TypeDescription.Structure();
        struct.setComponents(components);
        TypeDescription typeSpec = new TypeDescription();
        typeSpec.setStructure(struct);
        GetVariableAccessAttributesResponse getVariableAccessAttributesResponse = new GetVariableAccessAttributesResponse();
        getVariableAccessAttributesResponse.setMmsDeletable(new BerBoolean(false));
        getVariableAccessAttributesResponse.setTypeDescription(typeSpec);
        return getVariableAccessAttributesResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadResponse handleGetDataValuesRequest(ReadRequest mmsReadRequest) throws com.beanit.openiec61850.ServiceError {
        Iterable<ModelNode> dataSet;
        VariableAccessSpecification variableAccessSpecification = mmsReadRequest.getVariableAccessSpecification();
        if (mmsReadRequest.getSpecificationWithResult() == null || !mmsReadRequest.getSpecificationWithResult().value) {
            if (variableAccessSpecification.getListOfVariable() == null) {
                throw new com.beanit.openiec61850.ServiceError(11, "handleGetDataValuesRequest: Got an invalid MMS packet");
            }
            List<VariableDefs.SEQUENCE> listOfVariable = variableAccessSpecification.getListOfVariable().getSEQUENCE();
            if (listOfVariable.size() < 1) {
                throw new com.beanit.openiec61850.ServiceError(6, "handleGetDataValuesRequest: less than one variableAccessSpecification is not allowed");
            }
            ReadResponse.ListOfAccessResult listOfAccessResult = new ReadResponse.ListOfAccessResult();
            List<AccessResult> accessResults = listOfAccessResult.getAccessResult();
            ServerModel serverModel = this.serverModel;
            synchronized (serverModel) {
                for (VariableDefs.SEQUENCE sEQUENCE : listOfVariable) {
                    FcModelNode modelNode = this.serverModel.getNodeFromVariableDef(sEQUENCE);
                    if (modelNode == null) {
                        logger.debug("Got a GetDataValues request for a non existent model node.");
                        AccessResult accessResult = new AccessResult();
                        accessResult.setFailure(new DataAccessError(10L));
                        accessResults.add(accessResult);
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Got a GetDataValues request for node: " + modelNode);
                        if (!(modelNode instanceof BasicDataAttribute)) {
                            for (BasicDataAttribute bda : modelNode.getBasicDataAttributes()) {
                                logger.debug("sub BDA is:" + bda);
                            }
                        }
                    }
                    accessResults.add(this.getReadResult(modelNode));
                }
            }
            ReadResponse readResponse = new ReadResponse();
            readResponse.setListOfAccessResult(listOfAccessResult);
            return readResponse;
        }
        logger.debug("Got a GetDataSetValues request.");
        String dataSetReference = ServerAssociation.convertToDataSetReference(variableAccessSpecification.getVariableListName());
        if (dataSetReference == null) {
            throw new com.beanit.openiec61850.ServiceError(6, "handleGetDataSetValuesRequest: DataSet name incorrect");
        }
        ReadResponse.ListOfAccessResult listOfAccessResult = new ReadResponse.ListOfAccessResult();
        List<AccessResult> accessResults = listOfAccessResult.getAccessResult();
        if (dataSetReference.startsWith("@")) {
            dataSet = this.nonPersistentDataSets.get(dataSetReference);
            if (dataSet == null) {
                throw new com.beanit.openiec61850.ServiceError(6, "handleGetDataSetValuesRequest: a DataSet with the given reference does not exist");
            }
            for (FcModelNode fcModelNode : dataSet) {
                accessResults.add(this.getReadResult(fcModelNode));
            }
        } else {
            dataSet = this.serverModel;
            synchronized (dataSet) {
                DataSet dataSet2 = this.serverModel.getDataSet(dataSetReference);
                if (dataSet2 == null) {
                    throw new com.beanit.openiec61850.ServiceError(6, "handleGetDataSetValuesRequest: a DataSet with the given reference does not exist");
                }
                for (FcModelNode dsMember : dataSet2) {
                    accessResults.add(this.getReadResult(dsMember));
                }
            }
        }
        ReadResponse readResponse = new ReadResponse();
        readResponse.setListOfAccessResult(listOfAccessResult);
        return readResponse;
    }

    private AccessResult getReadResult(FcModelNode modelNode) {
        AccessResult accessResult = new AccessResult();
        if (modelNode.getFc() == Fc.CO && modelNode.getName().equals("SBO")) {
            FcModelNode cdcParent = (FcModelNode)modelNode.getParent();
            ModelNode ctlModelNode = this.serverModel.findModelNode(cdcParent.getReference(), Fc.CF).getChild("ctlModel");
            if (ctlModelNode == null || !(ctlModelNode instanceof BdaInt8) || ((BdaInt8)ctlModelNode).getValue() != 2) {
                logger.warn("Selecting controle DO fails because ctlModel is not set to \"sbo-with-normal-security\"");
                accessResult.setFailure(new DataAccessError(3L));
                return accessResult;
            }
            if (!cdcParent.select(this, this.serverSap.timer)) {
                Data data = new Data();
                data.setVisibleString(new BerVisibleString(""));
                accessResult.setSuccess(data);
                return accessResult;
            }
            Data data = new Data();
            data.setVisibleString(new BerVisibleString("success"));
            accessResult.setSuccess(data);
            return accessResult;
        }
        Data data = modelNode.getMmsDataObj();
        if (data == null) {
            accessResult.setFailure(new DataAccessError(11L));
            return accessResult;
        }
        accessResult.setSuccess(data);
        return accessResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteResponse handleSetDataValuesRequest(WriteRequest mmsWriteRequest) throws com.beanit.openiec61850.ServiceError {
        VariableAccessSpecification variableAccessSpecification = mmsWriteRequest.getVariableAccessSpecification();
        List<Data> listOfData = mmsWriteRequest.getListOfData().getData();
        WriteResponse writeResponse = new WriteResponse();
        List<WriteResponse.CHOICE> mmsResponseValues = writeResponse.getCHOICE();
        if (variableAccessSpecification.getListOfVariable() != null) {
            logger.debug("Got a SetDataValues request.");
            List<VariableDefs.SEQUENCE> listOfVariable = variableAccessSpecification.getListOfVariable().getSEQUENCE();
            if (listOfVariable.size() < 1 || listOfData.size() < 1 || listOfVariable.size() != listOfData.size()) {
                throw new com.beanit.openiec61850.ServiceError(6, "handleSetDataValuesRequest: less than one variableAccessSpecification or data element is not allowed, or listOfData ne listOfVar");
            }
            Iterator<Data> mmsDataIterator = listOfData.iterator();
            ArrayList<BasicDataAttribute> totalBdasToBeWritten = new ArrayList<BasicDataAttribute>();
            int[] numBdas = new int[listOfData.size()];
            int i = -1;
            ServerModel serverModel = this.serverModel;
            synchronized (serverModel) {
                for (VariableDefs.SEQUENCE variableDef : listOfVariable) {
                    ++i;
                    Data mmsData = mmsDataIterator.next();
                    FcModelNode modelNode = this.serverModel.getNodeFromVariableDef(variableDef);
                    if (modelNode == null) {
                        WriteResponse.CHOICE writeResponseChoice = new WriteResponse.CHOICE();
                        writeResponseChoice.setFailure(new DataAccessError(10L));
                        mmsResponseValues.add(writeResponseChoice);
                        continue;
                    }
                    this.getFirstWriteResults(mmsResponseValues, totalBdasToBeWritten, numBdas, i, modelNode, mmsData);
                }
                this.writeAndFillMissingWriteResults(mmsResponseValues, totalBdasToBeWritten, numBdas);
            }
        } else if (variableAccessSpecification.getVariableListName() != null) {
            logger.debug("Got a SetDataSetValues request.");
            String dataSetRef = ServerAssociation.convertToDataSetReference(variableAccessSpecification.getVariableListName());
            DataSet dataSet = this.serverModel.getDataSet(dataSetRef);
            Iterator<Data> mmsDataIterator = listOfData.iterator();
            ArrayList<BasicDataAttribute> totalBdasToBeWritten = new ArrayList<BasicDataAttribute>();
            int[] numBdas = new int[listOfData.size()];
            int i = -1;
            ServerModel serverModel = this.serverModel;
            synchronized (serverModel) {
                for (FcModelNode dataSetMember : dataSet) {
                    Data mmsData = mmsDataIterator.next();
                    this.getFirstWriteResults(mmsResponseValues, totalBdasToBeWritten, numBdas, ++i, dataSetMember, mmsData);
                }
                this.writeAndFillMissingWriteResults(mmsResponseValues, totalBdasToBeWritten, numBdas);
            }
        } else {
            throw new com.beanit.openiec61850.ServiceError(5, "handleSetDataValuesRequest: invalid MMS request");
        }
        return writeResponse;
    }

    private void writeAndFillMissingWriteResults(List<WriteResponse.CHOICE> mmsResponseValues, List<BasicDataAttribute> totalBdasToBeWritten, int[] numBdas) {
        block7: {
            if (totalBdasToBeWritten.size() == 0) break block7;
            List<com.beanit.openiec61850.ServiceError> serviceErrors = this.serverSap.serverEventListener.write(totalBdasToBeWritten);
            ListIterator<WriteResponse.CHOICE> mmsResponseIterator = mmsResponseValues.listIterator();
            if (serviceErrors == null || serviceErrors.size() != totalBdasToBeWritten.size()) {
                while (mmsResponseIterator.hasNext()) {
                    if (mmsResponseIterator.next() != null) continue;
                    mmsResponseIterator.set(writeSuccess);
                }
                for (BasicDataAttribute bda : totalBdasToBeWritten) {
                    bda.mirror.setValueFrom(bda);
                }
            } else {
                int i = -1;
                Iterator<com.beanit.openiec61850.ServiceError> serviceErrorIterator = serviceErrors.iterator();
                Iterator<BasicDataAttribute> bdaToBeWrittenIterator = totalBdasToBeWritten.iterator();
                while (mmsResponseIterator.hasNext()) {
                    ++i;
                    if (mmsResponseIterator.next() != null) continue;
                    for (int j = 0; j < numBdas[i]; ++j) {
                        com.beanit.openiec61850.ServiceError serviceError = serviceErrorIterator.next();
                        BasicDataAttribute bda = bdaToBeWrittenIterator.next();
                        if (serviceError != null) {
                            WriteResponse.CHOICE writeResponseChoice = new WriteResponse.CHOICE();
                            writeResponseChoice.setFailure(new DataAccessError(this.serviceErrorToMmsError(serviceError)));
                            mmsResponseIterator.set(writeResponseChoice);
                            continue;
                        }
                        bda.mirror.setValueFrom(bda);
                    }
                }
            }
        }
    }

    private void getFirstWriteResults(List<WriteResponse.CHOICE> mmsResponseValues, List<BasicDataAttribute> totalBdasToBeWritten, int[] numBdas, int i, FcModelNode fcModelNode, Data mmsData) {
        WriteResponse.CHOICE writeResult = this.getWriteResult(fcModelNode, mmsData);
        if (writeResult == null) {
            FcModelNode fcModelNodeCopy = (FcModelNode)fcModelNode.copy();
            try {
                fcModelNodeCopy.setValueFromMmsDataObj(mmsData);
            }
            catch (com.beanit.openiec61850.ServiceError e) {
                logger.warn("SetDataValues failed because of data missmatch.", (Throwable)e);
                WriteResponse.CHOICE writeResponseChoice = new WriteResponse.CHOICE();
                writeResponseChoice.setFailure(new DataAccessError(this.serviceErrorToMmsError(e)));
                mmsResponseValues.add(writeResponseChoice);
                return;
            }
            if (fcModelNodeCopy.fc == Fc.CO) {
                fcModelNodeCopy = (FcModelNode)fcModelNodeCopy.getChild("ctlVal");
            }
            List<BasicDataAttribute> bdas = fcModelNodeCopy.getBasicDataAttributes();
            totalBdasToBeWritten.addAll(bdas);
            numBdas[i] = bdas.size();
            mmsResponseValues.add(null);
        } else {
            mmsResponseValues.add(writeResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriteResponse.CHOICE getWriteResult(FcModelNode modelNode, Data mmsData) {
        WriteResponse.CHOICE writeResponse = new WriteResponse.CHOICE();
        Fc fc = modelNode.getFc();
        if (fc == Fc.ST || fc == Fc.MX || fc == Fc.OR || fc == Fc.EX) {
            writeResponse.setFailure(new DataAccessError(3L));
            return writeResponse;
        }
        if (fc == Fc.CO) {
            String nodeName = modelNode.getName();
            if (nodeName.equals("Oper")) {
                FcModelNode cdcParent = (FcModelNode)modelNode.getParent();
                ModelNode ctlModelNode = this.serverModel.findModelNode(cdcParent.getReference(), Fc.CF).getChild("ctlModel");
                if (ctlModelNode == null || !(ctlModelNode instanceof BdaInt8)) {
                    logger.warn("Operatring controle DO failed because ctlModel is not set.");
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                byte ctlModel = ((BdaInt8)ctlModelNode).getValue();
                if (ctlModel == 1) {
                    return null;
                }
                if (ctlModel == 2) {
                    if (cdcParent.isSelectedBy(this)) {
                        return null;
                    }
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                logger.warn("SetDataValues failed because of unsupported ctlModel: " + ctlModel);
                writeResponse.setFailure(new DataAccessError(9L));
                return writeResponse;
            }
            logger.warn("SetDataValues failed because of the operation is not allowed yet: " + modelNode.getName());
            writeResponse.setFailure(new DataAccessError(9L));
            return writeResponse;
        }
        if (fc == Fc.RP) {
            if (modelNode instanceof Rcb) {
                writeResponse.setFailure(new DataAccessError(3L));
                return writeResponse;
            }
            FcModelNode fcModelNodeCopy = (FcModelNode)modelNode.copy();
            try {
                fcModelNodeCopy.setValueFromMmsDataObj(mmsData);
            }
            catch (com.beanit.openiec61850.ServiceError e) {
                WriteResponse.CHOICE writeResponseChoice = new WriteResponse.CHOICE();
                writeResponseChoice.setFailure(new DataAccessError(this.serviceErrorToMmsError(e)));
                return writeResponseChoice;
            }
            Urcb urcb = (Urcb)modelNode.getParent();
            String nodeName = modelNode.getName();
            Urcb urcb2 = urcb;
            synchronized (urcb2) {
                if (nodeName.equals("RptEna")) {
                    BdaBoolean rptEnaNode = (BdaBoolean)fcModelNodeCopy;
                    if (rptEnaNode.getValue()) {
                        if (urcb.dataSet == null) {
                            logger.info("client tried to enable RCB even though there is no configured data set");
                            writeResponse.setFailure(new DataAccessError(3L));
                            return writeResponse;
                        }
                        if (urcb.reserved == null) {
                            urcb.reserved = this;
                            urcb.enable();
                            this.rsvdURCBs.add(urcb);
                            ((BdaBoolean)modelNode).setValue(true);
                            return writeSuccess;
                        }
                        if (urcb.reserved == this) {
                            urcb.enable();
                            ((BdaBoolean)modelNode).setValue(true);
                            return writeSuccess;
                        }
                        writeResponse.setFailure(new DataAccessError(3L));
                        return writeResponse;
                    }
                    if (urcb.reserved == this) {
                        urcb.disable();
                        ((BdaBoolean)modelNode).setValue(false);
                        return writeSuccess;
                    }
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                if (nodeName.equals("Resv")) {
                    BdaBoolean rptResvNode = (BdaBoolean)fcModelNodeCopy;
                    if (rptResvNode.getValue()) {
                        if (urcb.reserved == null) {
                            urcb.reserved = this;
                            urcb.getResv().setValue(true);
                            this.rsvdURCBs.add(urcb);
                            return writeSuccess;
                        }
                        if (urcb.reserved == this) {
                            return writeSuccess;
                        }
                        writeResponse.setFailure(new DataAccessError(3L));
                        return writeResponse;
                    }
                    if (urcb.reserved == this) {
                        urcb.reserved = null;
                        urcb.getResv().setValue(false);
                        this.rsvdURCBs.remove(urcb);
                        return writeSuccess;
                    }
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                if (nodeName.equals("DatSet")) {
                    if (!(urcb.reserved != null && urcb.reserved != this || urcb.enabled)) {
                        String dataSetRef = ((BdaVisibleString)fcModelNodeCopy).getStringValue().replace('$', '.');
                        if (dataSetRef.isEmpty()) {
                            urcb.dataSet = null;
                            ((BasicDataAttribute)modelNode).setValueFrom((BasicDataAttribute)fcModelNodeCopy);
                            return writeSuccess;
                        }
                        DataSet dataSet = this.serverModel.getDataSet(dataSetRef);
                        if (dataSet == null) {
                            dataSet = this.nonPersistentDataSets.get(dataSetRef);
                        }
                        if (dataSet != null) {
                            urcb.dataSet = dataSet;
                            ((BasicDataAttribute)modelNode).setValueFrom((BasicDataAttribute)fcModelNodeCopy);
                            return writeSuccess;
                        }
                        logger.info("Client tried to set dataSetReference of URCB to non existant data set.");
                        writeResponse.setFailure(new DataAccessError(3L));
                        return writeResponse;
                    }
                    logger.info("Client tried to write RCB parameter even though URCB is reserved by other client or already enabled.");
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                if (nodeName.equals("OptFlds")) {
                    if (!(urcb.reserved != null && urcb.reserved != this || urcb.enabled)) {
                        if (!(((BdaOptFlds)modelNode).isBufferOverflow() || ((BdaOptFlds)modelNode).isConfigRevision() || ((BdaOptFlds)modelNode).isDataReference() || ((BdaOptFlds)modelNode).isEntryId())) {
                            ((BasicDataAttribute)modelNode).setValueFrom((BasicDataAttribute)fcModelNodeCopy);
                            return writeSuccess;
                        }
                        logger.info("Client tried to write OptFlds with usupported field set to true.");
                        writeResponse.setFailure(new DataAccessError(3L));
                        return writeResponse;
                    }
                    logger.info("Client tried to write RCB parameter even though URCB is reserved by other client or already enabled.");
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                if (nodeName.equals("GI")) {
                    if (urcb.reserved == this && urcb.enabled && ((BdaTriggerConditions)urcb.getChild("TrgOps")).isGeneralInterrogation()) {
                        urcb.generalInterrogation();
                        return writeSuccess;
                    }
                    logger.info("Client tried to initiate a general interrogation even though URCB is not enabled by this client or general interrogation is not enabled in the trigger options.");
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                if (nodeName.equals("RptID") || nodeName.equals("BufTm") || nodeName.equals("TrgOps") || nodeName.equals("IntgPd")) {
                    if (!(urcb.reserved != null && urcb.reserved != this || urcb.enabled)) {
                        ((BasicDataAttribute)modelNode).setValueFrom((BasicDataAttribute)fcModelNodeCopy);
                        return writeSuccess;
                    }
                    writeResponse.setFailure(new DataAccessError(3L));
                    return writeResponse;
                }
                writeResponse.setFailure(new DataAccessError(3L));
                return writeResponse;
            }
        }
        return null;
    }

    private int serviceErrorToMmsError(com.beanit.openiec61850.ServiceError e) {
        switch (e.getErrorCode()) {
            case 12: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 10: {
                return 7;
            }
            case 1: {
                return 10;
            }
            case 6: {
                return 11;
            }
        }
        return 9;
    }

    private GetNameListResponse handleGetDataSetNamesRequest(GetNameListRequest getNameListRequest) throws com.beanit.openiec61850.ServiceError {
        Identifier domainSpecific = getNameListRequest.getObjectScope().getDomainSpecific();
        List<String> dsList = null;
        if (domainSpecific == null) {
            dsList = new ArrayList<String>(this.nonPersistentDataSets.size());
            for (String dataSet : this.nonPersistentDataSets.keySet()) {
                dsList.add(dataSet);
            }
        } else {
            dsList = this.serverModel.getDataSetNames(domainSpecific.toString());
        }
        this.insertRef = true;
        if (getNameListRequest.getContinueAfter() != null) {
            this.continueAfter = getNameListRequest.getContinueAfter().toString();
            this.insertRef = false;
        }
        GetNameListResponse.ListOfIdentifier listOf = new GetNameListResponse.ListOfIdentifier();
        List<Identifier> identifiers = listOf.getIdentifier();
        int identifierSize = 0;
        boolean moreFollows = false;
        if (dsList != null) {
            for (String dsRef : dsList) {
                if (this.insertRef) {
                    if (identifierSize > this.negotiatedMaxPduSize - 200) {
                        moreFollows = true;
                        logger.info("maxMMSPduSize reached");
                        break;
                    }
                    identifiers.add(new Identifier(dsRef.getBytes()));
                    identifierSize += dsRef.length() + 2;
                    continue;
                }
                if (!dsRef.equals(this.continueAfter)) continue;
                this.insertRef = true;
            }
        }
        GetNameListResponse getNameListResponse = new GetNameListResponse();
        getNameListResponse.setListOfIdentifier(listOf);
        getNameListResponse.setMoreFollows(new BerBoolean(moreFollows));
        return getNameListResponse;
    }

    private GetNamedVariableListAttributesResponse handleGetDataSetDirectoryRequest(ObjectName mmsGetNamedVarListAttReq) throws com.beanit.openiec61850.ServiceError {
        String dataSetReference = ServerAssociation.convertToDataSetReference(mmsGetNamedVarListAttReq);
        DataSet dataSet = dataSetReference.startsWith("@") ? this.nonPersistentDataSets.get(dataSetReference) : this.serverModel.getDataSet(dataSetReference);
        if (dataSet == null) {
            throw new com.beanit.openiec61850.ServiceError(5, "DataSet with that reference is does not exist.");
        }
        VariableDefs variableDefs = new VariableDefs();
        List<VariableDefs.SEQUENCE> listOfVariable = variableDefs.getSEQUENCE();
        for (FcModelNode member : dataSet) {
            listOfVariable.add(member.getMmsVariableDef());
        }
        GetNamedVariableListAttributesResponse getNamedVariableListAttributesResponse = new GetNamedVariableListAttributesResponse();
        getNamedVariableListAttributesResponse.setListOfVariable(variableDefs);
        getNamedVariableListAttributesResponse.setMmsDeletable(new BerBoolean(dataSet.isDeletable()));
        return getNamedVariableListAttributesResponse;
    }

    private DefineNamedVariableListResponse handleCreateDataSetRequest(DefineNamedVariableListRequest mmsDefineNamedVariableListRequest) throws com.beanit.openiec61850.ServiceError {
        String dataSetReference = ServerAssociation.convertToDataSetReference(mmsDefineNamedVariableListRequest.getVariableListName());
        if (dataSetReference == null) {
            throw new com.beanit.openiec61850.ServiceError(6, "handleCreateDataSetRequest: invalid MMS request (No DataSet Name Specified)");
        }
        List<VariableDefs.SEQUENCE> nameList = mmsDefineNamedVariableListRequest.getListOfVariable().getSEQUENCE();
        ArrayList<FcModelNode> dataSetMembers = new ArrayList<FcModelNode>(nameList.size());
        for (VariableDefs.SEQUENCE variableDef : nameList) {
            dataSetMembers.add(this.serverModel.getNodeFromVariableDef(variableDef));
        }
        DataSet dataSet = new DataSet(dataSetReference, dataSetMembers, true);
        if (dataSetReference.startsWith("@")) {
            if (this.nonPersistentDataSets.containsKey(dataSetReference)) {
                throw new com.beanit.openiec61850.ServiceError(5, "data set with that name exists already");
            }
            this.nonPersistentDataSets.put(dataSetReference, dataSet);
        } else {
            this.serverModel.addDataSet(dataSet);
        }
        return new DefineNamedVariableListResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeleteNamedVariableListResponse handleDeleteDataSetRequest(DeleteNamedVariableListRequest mmsDelNamVarListReq) throws com.beanit.openiec61850.ServiceError {
        String dataSetReference = ServerAssociation.convertToDataSetReference(mmsDelNamVarListReq.getListOfVariableListName().getObjectName().get(0));
        DeleteNamedVariableListResponse deleteNamedVariableListResponse = new DeleteNamedVariableListResponse();
        if (dataSetReference.startsWith("@")) {
            if (this.nonPersistentDataSets.remove(dataSetReference) == null) {
                deleteNamedVariableListResponse.setNumberMatched(new Unsigned32(0L));
                deleteNamedVariableListResponse.setNumberDeleted(new Unsigned32(0L));
                return deleteNamedVariableListResponse;
            }
            deleteNamedVariableListResponse.setNumberMatched(new Unsigned32(1L));
            deleteNamedVariableListResponse.setNumberDeleted(new Unsigned32(1L));
            return deleteNamedVariableListResponse;
        }
        ServerModel serverModel = this.serverModel;
        synchronized (serverModel) {
            if (this.serverModel.removeDataSet(dataSetReference) == null) {
                if (this.serverModel.getDataSet(dataSetReference) == null) {
                    deleteNamedVariableListResponse.setNumberMatched(new Unsigned32(0L));
                    deleteNamedVariableListResponse.setNumberDeleted(new Unsigned32(0L));
                    return deleteNamedVariableListResponse;
                }
                deleteNamedVariableListResponse.setNumberMatched(new Unsigned32(1L));
                deleteNamedVariableListResponse.setNumberDeleted(new Unsigned32(0L));
                return deleteNamedVariableListResponse;
            }
            deleteNamedVariableListResponse.setNumberMatched(new Unsigned32(1L));
            deleteNamedVariableListResponse.setNumberDeleted(new Unsigned32(1L));
            return deleteNamedVariableListResponse;
        }
    }

    void close() {
        this.cleanUpConnection();
        this.executor.shutdown();
        if (this.acseAssociation != null) {
            this.acseAssociation.disconnect();
        }
    }

    static {
        writeSuccess.setSuccess(new BerNull());
    }
}

