/*
 * Decompiled with CFR 0.152.
 */
package com.beanit.openiec61850;

import com.beanit.josistack.AcseAssociation;
import com.beanit.josistack.ServerAcseSap;
import com.beanit.openiec61850.AcseListener;
import com.beanit.openiec61850.BasicDataAttribute;
import com.beanit.openiec61850.ServerAssociation;
import com.beanit.openiec61850.ServerEventListener;
import com.beanit.openiec61850.ServerModel;
import com.beanit.openiec61850.Urcb;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import javax.net.ServerSocketFactory;

public final class ServerSap {
    static final int MINIMUM_MMS_PDU_SIZE = 64;
    private static final int MAXIMUM_MMS_PDU_SIZE = 65000;
    final ServerModel serverModel;
    byte[] servicesSupportedCalled = new byte[]{-18, 28, 0, 0, 4, 8, 0, 0, 121, -17, 24};
    byte[] cbbBitString = new byte[]{-5, 0};
    ServerEventListener serverEventListener;
    Timer timer;
    List<ServerAssociation> associations = new ArrayList<ServerAssociation>();
    boolean listening = false;
    private int proposedMaxMmsPduSize = 65000;
    private int proposedMaxServOutstandingCalling = 5;
    private int proposedMaxServOutstandingCalled = 5;
    private int proposedDataStructureNestingLevel = 10;
    private int maxAssociations = 100;
    private ServerAcseSap acseSap;
    private int port = 102;
    private int backlog = 0;
    private InetAddress bindAddr = null;
    private ServerSocketFactory serverSocketFactory = null;

    public ServerSap(int port, int backlog, InetAddress bindAddr, ServerModel serverModel, ServerSocketFactory serverSocketFactory) {
        this.port = port;
        this.backlog = backlog;
        this.bindAddr = bindAddr;
        this.serverSocketFactory = serverSocketFactory;
        this.serverModel = serverModel;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public InetAddress getBindAddress() {
        return this.bindAddr;
    }

    public void setBindAddress(InetAddress bindAddr) {
        this.bindAddr = bindAddr;
    }

    public void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    public int getMaxMmsPduSize() {
        return this.proposedMaxMmsPduSize;
    }

    public void setMaxMmsPduSize(int size) {
        if (size < 64 || size > 65000) {
            throw new IllegalArgumentException("maximum size is out of bound");
        }
        this.proposedMaxMmsPduSize = size;
    }

    public void setMaxAssociations(int maxAssociations) {
        this.maxAssociations = maxAssociations;
    }

    public void setMessageFragmentTimeout(int timeout) {
        this.acseSap.serverTSap.setMessageFragmentTimeout(timeout);
    }

    public int getProposedMaxServOutstandingCalling() {
        return this.proposedMaxServOutstandingCalling;
    }

    public void setProposedMaxServOutstandingCalling(int maxCalling) {
        this.proposedMaxServOutstandingCalling = maxCalling;
    }

    public int getProposedMaxServOutstandingCalled() {
        return this.proposedMaxServOutstandingCalled;
    }

    public void setProposedMaxServOutstandingCalled(int maxCalled) {
        this.proposedMaxServOutstandingCalled = maxCalled;
    }

    public int getProposedDataStructureNestingLevel() {
        return this.proposedDataStructureNestingLevel;
    }

    public void setProposedDataStructureNestingLevel(int nestingLevel) {
        this.proposedDataStructureNestingLevel = nestingLevel;
    }

    public byte[] getServicesSupportedCalled() {
        return this.servicesSupportedCalled;
    }

    public void setServicesSupportedCalled(byte[] services) {
        if (services.length != 11) {
            throw new IllegalArgumentException("The services parameter needs to be of lenth 11");
        }
        this.servicesSupportedCalled = services;
    }

    public void startListening(ServerEventListener serverEventListener) throws IOException {
        this.timer = new Timer();
        if (this.serverSocketFactory == null) {
            this.serverSocketFactory = ServerSocketFactory.getDefault();
        }
        this.acseSap = new ServerAcseSap(this.port, this.backlog, this.bindAddr, new AcseListener(this), this.serverSocketFactory);
        this.acseSap.serverTSap.setMaxConnections(this.maxAssociations);
        this.serverEventListener = serverEventListener;
        this.listening = true;
        this.acseSap.startListening();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.acseSap.stopListening();
        List<ServerAssociation> list = this.associations;
        synchronized (list) {
            this.listening = false;
            for (ServerAssociation association : this.associations) {
                association.close();
            }
            this.associations.clear();
        }
        this.timer.cancel();
        this.timer.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectionIndication(AcseAssociation acseAssociation, ByteBuffer psdu) {
        ServerAssociation association;
        List<ServerAssociation> list = this.associations;
        synchronized (list) {
            if (!this.listening) {
                acseAssociation.close();
                return;
            }
            association = new ServerAssociation(this);
            this.associations.add(association);
        }
        try {
            association.handleNewAssociation(acseAssociation, psdu);
        }
        catch (Exception exception) {
            // empty catch block
        }
        association.close();
        list = this.associations;
        synchronized (list) {
            this.associations.remove(association);
        }
    }

    void serverStoppedListeningIndication(IOException e) {
        if (this.serverEventListener != null) {
            this.serverEventListener.serverStoppedListening(this);
        }
    }

    public ServerModel getModelCopy() {
        return this.serverModel.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(List<BasicDataAttribute> bdas) {
        ServerModel serverModel = this.serverModel;
        synchronized (serverModel) {
            for (BasicDataAttribute bda : bdas) {
                List<Urcb> list;
                BasicDataAttribute bdaMirror = bda.mirror;
                if (bdaMirror.dchg && bdaMirror.chgRcbs.size() != 0 && !bda.equals(bdaMirror)) {
                    bdaMirror.setValueFrom(bda);
                    list = bdaMirror.chgRcbs;
                    synchronized (list) {
                        for (Urcb urcb : bdaMirror.chgRcbs) {
                            if (bdaMirror.dupd && urcb.getTrgOps().isDataUpdate()) {
                                urcb.report(bdaMirror, true, false, true);
                                continue;
                            }
                            urcb.report(bdaMirror, true, false, false);
                        }
                        continue;
                    }
                }
                if (bdaMirror.dupd && bdaMirror.dupdRcbs.size() != 0) {
                    bdaMirror.setValueFrom(bda);
                    list = bdaMirror.dupdRcbs;
                    synchronized (list) {
                        for (Urcb urcb : bdaMirror.dupdRcbs) {
                            urcb.report(bdaMirror, false, false, true);
                        }
                        continue;
                    }
                }
                if (bdaMirror.qchg && bdaMirror.chgRcbs.size() != 0 && !bda.equals(bdaMirror)) {
                    bdaMirror.setValueFrom(bda);
                    list = bdaMirror.chgRcbs;
                    synchronized (list) {
                        for (Urcb urcb : bdaMirror.chgRcbs) {
                            urcb.report(bdaMirror, false, true, false);
                        }
                        continue;
                    }
                }
                bdaMirror.setValueFrom(bda);
            }
        }
    }
}

